/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Checkcast;
import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.D2f;
import com.tangosol.dev.assembler.D2i;
import com.tangosol.dev.assembler.D2l;
import com.tangosol.dev.assembler.F2d;
import com.tangosol.dev.assembler.F2i;
import com.tangosol.dev.assembler.F2l;
import com.tangosol.dev.assembler.I2b;
import com.tangosol.dev.assembler.I2c;
import com.tangosol.dev.assembler.I2d;
import com.tangosol.dev.assembler.I2f;
import com.tangosol.dev.assembler.I2l;
import com.tangosol.dev.assembler.I2s;
import com.tangosol.dev.assembler.L2d;
import com.tangosol.dev.assembler.L2f;
import com.tangosol.dev.assembler.L2i;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.compiler.java.UnaryExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class CastExpression
extends UnaryExpression {
    private static final String CLASS = "CastExpression";
    private TypeExpression exprType;

    public CastExpression(Token operator, Expression expr, TypeExpression exprType) {
        super(operator, expr);
        this.exprType = exprType;
    }

    public CastExpression(Expression expr, DataType type) {
        super(expr.getStartToken(), expr);
        this.setType(type);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        this.setExpression(expr);
        TypeExpression exprType = this.exprType;
        if (exprType != null) {
            this.exprType = exprType = (TypeExpression)exprType.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
            DataType dt = exprType.getType();
            expr.checkCastable(ctx, dt, errlist);
            this.setType(dt);
        }
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        DataType typeExpr = expr.getType();
        DataType typeCast = this.getType();
        expr.compile(ctx, code, fReached, errlist);
        switch (typeExpr.getTypeString().charAt(0)) {
            case 'Z': {
                break;
            }
            case 'B': {
                switch (typeCast.getTypeString().charAt(0)) {
                    case 'C': {
                        code.add(new I2c());
                        break;
                    }
                    case 'S': {
                        code.add(new I2s());
                        break;
                    }
                    case 'J': {
                        code.add(new I2l());
                        break;
                    }
                    case 'F': {
                        code.add(new I2f());
                        break;
                    }
                    case 'D': {
                        code.add(new I2d());
                    }
                }
                break;
            }
            case 'C': {
                switch (typeCast.getTypeString().charAt(0)) {
                    case 'B': {
                        code.add(new I2b());
                        break;
                    }
                    case 'S': {
                        code.add(new I2s());
                        break;
                    }
                    case 'J': {
                        code.add(new I2l());
                        break;
                    }
                    case 'F': {
                        code.add(new I2f());
                        break;
                    }
                    case 'D': {
                        code.add(new I2d());
                    }
                }
                break;
            }
            case 'S': {
                switch (typeCast.getTypeString().charAt(0)) {
                    case 'B': {
                        code.add(new I2b());
                        break;
                    }
                    case 'C': {
                        code.add(new I2c());
                        break;
                    }
                    case 'J': {
                        code.add(new I2l());
                        break;
                    }
                    case 'F': {
                        code.add(new I2f());
                        break;
                    }
                    case 'D': {
                        code.add(new I2d());
                    }
                }
                break;
            }
            case 'I': {
                switch (typeCast.getTypeString().charAt(0)) {
                    case 'B': {
                        code.add(new I2b());
                        break;
                    }
                    case 'C': {
                        code.add(new I2c());
                        break;
                    }
                    case 'S': {
                        code.add(new I2s());
                        break;
                    }
                    case 'J': {
                        code.add(new I2l());
                        break;
                    }
                    case 'F': {
                        code.add(new I2f());
                        break;
                    }
                    case 'D': {
                        code.add(new I2d());
                    }
                }
                break;
            }
            case 'J': {
                switch (typeCast.getTypeString().charAt(0)) {
                    case 'B': {
                        code.add(new L2i());
                        code.add(new I2b());
                        break;
                    }
                    case 'C': {
                        code.add(new L2i());
                        code.add(new I2c());
                        break;
                    }
                    case 'S': {
                        code.add(new L2i());
                        code.add(new I2s());
                        break;
                    }
                    case 'I': {
                        code.add(new L2i());
                        break;
                    }
                    case 'F': {
                        code.add(new L2f());
                        break;
                    }
                    case 'D': {
                        code.add(new L2d());
                    }
                }
                break;
            }
            case 'F': {
                switch (typeCast.getTypeString().charAt(0)) {
                    case 'B': {
                        code.add(new F2i());
                        code.add(new I2b());
                        break;
                    }
                    case 'C': {
                        code.add(new F2i());
                        code.add(new I2c());
                        break;
                    }
                    case 'S': {
                        code.add(new F2i());
                        code.add(new I2s());
                        break;
                    }
                    case 'I': {
                        code.add(new F2i());
                        break;
                    }
                    case 'J': {
                        code.add(new F2l());
                        break;
                    }
                    case 'D': {
                        code.add(new F2d());
                    }
                }
                break;
            }
            case 'D': {
                switch (typeCast.getTypeString().charAt(0)) {
                    case 'B': {
                        code.add(new D2i());
                        code.add(new I2b());
                        break;
                    }
                    case 'C': {
                        code.add(new D2i());
                        code.add(new I2c());
                        break;
                    }
                    case 'S': {
                        code.add(new D2i());
                        code.add(new I2s());
                        break;
                    }
                    case 'I': {
                        code.add(new D2i());
                        break;
                    }
                    case 'J': {
                        code.add(new D2l());
                        break;
                    }
                    case 'F': {
                        code.add(new D2f());
                    }
                }
                break;
            }
            case 'N': {
                break;
            }
            case 'L': 
            case 'R': 
            case '[': {
                if (this.exprType.checkAssignable(ctx, typeCast, null)) break;
                code.add(new Checkcast((ClassConstant)ctx.getTypeInfo(typeCast).getConstant()));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return fReached;
    }

    public TypeExpression getTypeExpression() {
        return this.exprType;
    }

    @Override
    public boolean isConstant() {
        return this.getExpression().isConstant() && this.getType().isNumeric();
    }

    @Override
    public Object getValue() {
        Number number = (Number)this.getExpression().getValue();
        switch (this.getType().getTypeString().charAt(0)) {
            case 'B': {
                return new Byte(number.byteValue());
            }
            case 'C': {
                return CastExpression.makeInteger((char)number.intValue());
            }
            case 'S': {
                return new Short(number.shortValue());
            }
            case 'I': {
                return CastExpression.makeInteger(number.intValue());
            }
            case 'J': {
                return CastExpression.makeLong(number.longValue());
            }
            case 'F': {
                return new Float(number.floatValue());
            }
            case 'D': {
                return new Double(number.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void print(String sIndent) {
        CastExpression.out(sIndent + this.toString());
        DataType type = this.getType();
        CastExpression.out(sIndent + "  Cast to:  " + (this.exprType == null ? type.toString() : ""));
        if (this.exprType != null) {
            this.exprType.print(sIndent + "    ");
        }
        CastExpression.out(sIndent + "  Sub-expression:");
        this.getExpression().print(sIndent + "    ");
    }
}

