/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Ifeq;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.BooleanExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConditionalExpression
extends Expression {
    private static final String CLASS = "ConditionalExpression";
    private static final DataType UNKNOWN = DataType.UNKNOWN;
    private static final DataType NULL = DataType.NULL;
    private static final DataType BOOLEAN = DataType.BOOLEAN;
    private static final DataType BYTE = DataType.BYTE;
    private static final DataType CHAR = DataType.CHAR;
    private static final DataType SHORT = DataType.SHORT;
    private static final DataType INT = DataType.INT;
    private Expression test;
    private Token operator;
    private Expression iftrue;
    private Token separator;
    private Expression iffalse;

    public ConditionalExpression(Expression test, Token operator, Expression iftrue, Token separator, Expression iffalse) {
        super(test.getBlock(), test.getStartToken(), iffalse.getEndToken());
        this.test = test;
        this.operator = operator;
        this.iftrue = iftrue;
        this.separator = separator;
        this.iffalse = iffalse;
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression test = this.test;
        Expression iftrue = this.iftrue;
        Expression iffalse = this.iffalse;
        this.test = test = (Expression)test.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        test.checkBoolean(errlist);
        DualSet setUTrue = new DualSet(setUVars.getTrueSet());
        DualSet setFTrue = new DualSet(setFVars.getTrueSet());
        this.iftrue = iftrue = (Expression)iftrue.precompile(ctx, setUTrue, setFVars, mapThrown, errlist);
        DualSet setUFalse = new DualSet(setUVars.getFalseSet());
        DualSet setFFalse = new DualSet(setFVars.getFalseSet());
        this.iffalse = iffalse = (Expression)iffalse.precompile(ctx, setUTrue, setFVars, mapThrown, errlist);
        DataType dtTrue = iftrue.getType();
        DataType dtFalse = iffalse.getType();
        DataType dtResult = UNKNOWN;
        if (dtTrue == BOOLEAN) {
            HashSet setAssigned;
            Set setRightFalse;
            Set setRightTrue;
            Set setLeftFalse;
            Set setLeftTrue;
            if (setUTrue.isModified() && setUFalse.isModified()) {
                setLeftTrue = setUTrue.getTrueSet().getRemoved();
                setLeftFalse = setUTrue.getFalseSet().getRemoved();
                setRightTrue = setUFalse.getTrueSet().getRemoved();
                setRightFalse = setUFalse.getFalseSet().getRemoved();
                setAssigned = new HashSet(setLeftTrue);
                setAssigned.retainAll(setRightTrue);
                setUVars.getTrueSet().removeAll(setAssigned);
                setAssigned = new HashSet(setLeftFalse);
                setAssigned.retainAll(setRightFalse);
                setUVars.getFalseSet().removeAll(setAssigned);
            }
            if (setFTrue.isModified() && setFFalse.isModified()) {
                setLeftTrue = setFTrue.getTrueSet().getAdded();
                setLeftFalse = setFTrue.getFalseSet().getAdded();
                setRightTrue = setFFalse.getTrueSet().getAdded();
                setRightFalse = setFFalse.getFalseSet().getAdded();
                setAssigned = new HashSet(setLeftTrue);
                setAssigned.addAll(setRightTrue);
                setUVars.getTrueSet().addAll(setAssigned);
                setAssigned = new HashSet(setLeftFalse);
                setAssigned.addAll(setRightFalse);
                setUVars.getFalseSet().addAll(setAssigned);
            }
            iffalse.checkBoolean(errlist);
            dtResult = BOOLEAN;
        } else {
            setUTrue.resolve();
            setUFalse.resolve();
            setFTrue.resolve();
            setFFalse.resolve();
            if (dtTrue.isReference()) {
                DataType NULL = ConditionalExpression.NULL;
                if (dtTrue == dtFalse || !iffalse.checkReference(errlist)) {
                    dtResult = dtTrue;
                } else if (dtTrue == NULL) {
                    dtResult = dtFalse;
                } else if (dtFalse == NULL) {
                    dtResult = dtTrue;
                } else if (iffalse.checkAssignable(ctx, dtTrue, null)) {
                    iffalse = iffalse.convertAssignable(ctx, dtTrue);
                    dtResult = dtTrue;
                } else if (iftrue.checkAssignable(ctx, dtFalse, errlist)) {
                    iftrue = iftrue.convertAssignable(ctx, dtFalse);
                    dtResult = dtFalse;
                } else {
                    dtResult = NULL;
                }
            } else if (iftrue.checkNumeric(errlist) & iffalse.checkNumeric(errlist)) {
                DataType BYTE = ConditionalExpression.BYTE;
                DataType CHAR = ConditionalExpression.CHAR;
                DataType SHORT = ConditionalExpression.SHORT;
                DataType INT = ConditionalExpression.INT;
                if (dtTrue == dtFalse) {
                    dtResult = dtTrue;
                } else if (!(dtTrue != BYTE && dtTrue != SHORT || dtFalse != BYTE && dtFalse != SHORT)) {
                    dtResult = SHORT;
                } else if ((dtTrue == BYTE || dtTrue == SHORT || dtTrue == CHAR) && dtFalse == INT && iffalse.isConstant() && iffalse.checkAssignable(ctx, dtTrue, null)) {
                    iffalse = iffalse.convertAssignable(ctx, dtTrue);
                    dtResult = dtTrue;
                } else if ((dtFalse == BYTE || dtFalse == SHORT || dtFalse == CHAR) && dtTrue == INT && iftrue.isConstant() && iftrue.checkAssignable(ctx, dtFalse, null)) {
                    iftrue = iftrue.convertAssignable(ctx, dtFalse);
                    dtResult = dtFalse;
                } else {
                    iftrue = iftrue.promoteNumeric(iffalse);
                    iffalse = iffalse.promoteNumeric(iftrue);
                    dtResult = iftrue.getType();
                }
            }
        }
        this.test = test;
        this.iftrue = iftrue;
        this.iffalse = iffalse;
        this.setType(dtResult);
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            return super.compile(ctx, code, fReached, errlist);
        }
        Expression test = this.test;
        Expression iftrue = this.iftrue;
        Expression iffalse = this.iffalse;
        if (test instanceof BooleanExpression || !ctx.isDebug() && test.isConstant()) {
            Expression result = (Boolean)test.getValue() != false ? iftrue : iffalse;
            result.compile(ctx, code, fReached, errlist);
        } else {
            Label lblElse = new Label();
            Label lblExit = new Label();
            test.compile(ctx, code, fReached, errlist);
            code.add(new Ifeq(lblElse));
            iftrue.compile(ctx, code, fReached, errlist);
            code.add(new Goto(lblExit));
            code.add(lblElse);
            iffalse.compile(ctx, code, fReached, errlist);
            code.add(lblExit);
        }
        return fReached;
    }

    @Override
    public boolean isConstant() {
        Expression test = this.test;
        if (test.getType() == BOOLEAN && test.isConstant()) {
            return ((Boolean)test.getValue() != false ? this.iftrue : this.iffalse).isConstant();
        }
        return false;
    }

    @Override
    public Object getValue() {
        return ((Boolean)this.test.getValue() != false ? this.iftrue : this.iffalse).getValue();
    }

    public Expression getTest() {
        return this.test;
    }

    protected void setTest(Expression test) {
        this.test = test;
    }

    public Expression getTrueExpression() {
        return this.iftrue;
    }

    public void setTrueExpression(Expression iftrue) {
        this.iftrue = iftrue;
    }

    public Expression getFalseExpression() {
        return this.iffalse;
    }

    public void setFalseExpression(Expression iffalse) {
        this.iffalse = iffalse;
    }

    @Override
    public void print(String sIndent) {
        ConditionalExpression.out(sIndent + this.toString());
        ConditionalExpression.out(sIndent + "  test:");
        this.test.print(sIndent + "    ");
        ConditionalExpression.out(sIndent + "  value if true:");
        this.iftrue.print(sIndent + "    ");
        ConditionalExpression.out(sIndent + "  value if false:");
        this.iffalse.print(sIndent + "    ");
    }
}

