/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Baload;
import com.tangosol.dev.assembler.Bastore;
import com.tangosol.dev.assembler.Caload;
import com.tangosol.dev.assembler.Castore;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Dadd;
import com.tangosol.dev.assembler.Daload;
import com.tangosol.dev.assembler.Dastore;
import com.tangosol.dev.assembler.Dconst;
import com.tangosol.dev.assembler.Dload;
import com.tangosol.dev.assembler.DoubleConstant;
import com.tangosol.dev.assembler.Dstore;
import com.tangosol.dev.assembler.Dsub;
import com.tangosol.dev.assembler.Dup;
import com.tangosol.dev.assembler.Dup2;
import com.tangosol.dev.assembler.Dup2_x1;
import com.tangosol.dev.assembler.Dup2_x2;
import com.tangosol.dev.assembler.Dup_x1;
import com.tangosol.dev.assembler.Dup_x2;
import com.tangosol.dev.assembler.Dvar;
import com.tangosol.dev.assembler.Fadd;
import com.tangosol.dev.assembler.Faload;
import com.tangosol.dev.assembler.Fastore;
import com.tangosol.dev.assembler.Fconst;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.Fload;
import com.tangosol.dev.assembler.FloatConstant;
import com.tangosol.dev.assembler.Fstore;
import com.tangosol.dev.assembler.Fsub;
import com.tangosol.dev.assembler.Fvar;
import com.tangosol.dev.assembler.Getfield;
import com.tangosol.dev.assembler.Getstatic;
import com.tangosol.dev.assembler.I2b;
import com.tangosol.dev.assembler.I2c;
import com.tangosol.dev.assembler.I2s;
import com.tangosol.dev.assembler.Iadd;
import com.tangosol.dev.assembler.Iaload;
import com.tangosol.dev.assembler.Iastore;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.Iinc;
import com.tangosol.dev.assembler.Iload;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.Istore;
import com.tangosol.dev.assembler.Isub;
import com.tangosol.dev.assembler.Ivar;
import com.tangosol.dev.assembler.Ladd;
import com.tangosol.dev.assembler.Laload;
import com.tangosol.dev.assembler.Lastore;
import com.tangosol.dev.assembler.Lconst;
import com.tangosol.dev.assembler.Lload;
import com.tangosol.dev.assembler.LongConstant;
import com.tangosol.dev.assembler.Lstore;
import com.tangosol.dev.assembler.Lsub;
import com.tangosol.dev.assembler.Lvar;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.OpLoad;
import com.tangosol.dev.assembler.OpStore;
import com.tangosol.dev.assembler.Putfield;
import com.tangosol.dev.assembler.Putstatic;
import com.tangosol.dev.assembler.Saload;
import com.tangosol.dev.assembler.Sastore;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.ArrayAccessExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.FieldAccessExpression;
import com.tangosol.dev.compiler.java.PostDecExpression;
import com.tangosol.dev.compiler.java.PreDecExpression;
import com.tangosol.dev.compiler.java.PreIncExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.UnaryExpression;
import com.tangosol.dev.compiler.java.Variable;
import com.tangosol.dev.compiler.java.VariableExpression;
import com.tangosol.util.ErrorList;
import java.util.Map;

public abstract class IncExpression
extends UnaryExpression {
    private static final String CLASS = "IncExpression";
    private static final IntConstant CONSTANT_ICONST_1 = Constants.CONSTANT_ICONST_1;
    private static final LongConstant CONSTANT_LCONST_1 = Constants.CONSTANT_LCONST_1;
    private static final FloatConstant CONSTANT_FCONST_1 = Constants.CONSTANT_FCONST_1;
    private static final DoubleConstant CONSTANT_DCONST_1 = Constants.CONSTANT_DCONST_1;

    protected IncExpression(Token operator, Expression expr) {
        super(operator, expr);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        if (expr.checkAssignable(errlist)) {
            expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
            expr.checkNumeric(errlist);
        }
        this.setExpression(expr);
        this.setType(expr.getType());
        if (expr instanceof VariableExpression) {
            Variable var = ((VariableExpression)expr).getVariable();
            if (setUVars.contains(var)) {
                this.logError(3, "JC-035", new String[]{var.getName()}, errlist);
            }
            setUVars.remove(var);
            if (var.isFinal()) {
                setFVars.add(var);
            }
        }
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        char chType = expr.getType().getTypeString().charAt(0);
        boolean fDiscard = this.isDiscarded();
        boolean fWide = chType == 'J' || chType == 'D';
        boolean fSub = this instanceof PreDecExpression || this instanceof PostDecExpression;
        boolean fPre = this instanceof PreIncExpression || this instanceof PreDecExpression;
        boolean fPost = !fPre;
        Op opFinal = null;
        Op opDup = null;
        if (expr instanceof VariableExpression) {
            OpDeclare opVar = ((VariableExpression)expr).getVariable().getOp();
            OpLoad opLoad = null;
            OpStore opStore = null;
            switch (chType) {
                case 'B': 
                case 'C': 
                case 'S': {
                    opLoad = new Iload((Ivar)opVar);
                    opStore = new Istore((Ivar)opVar);
                    break;
                }
                case 'I': {
                    Ivar var = (Ivar)opVar;
                    if (!fDiscard && fPost) {
                        code.add(new Iload(var));
                    }
                    code.add(new Iinc(var, fSub ? (short)-1 : 1));
                    if (!fDiscard && fPre) {
                        code.add(new Iload(var));
                    }
                    return fReached;
                }
                case 'J': {
                    opLoad = new Lload((Lvar)opVar);
                    opStore = new Lstore((Lvar)opVar);
                    break;
                }
                case 'F': {
                    opLoad = new Fload((Fvar)opVar);
                    opStore = new Fstore((Fvar)opVar);
                    break;
                }
                case 'D': {
                    opLoad = new Dload((Dvar)opVar);
                    opStore = new Dstore((Dvar)opVar);
                }
            }
            code.add(opLoad);
            if (!fDiscard) {
                opDup = fWide ? new Dup2() : new Dup();
            }
            opFinal = opStore;
        } else if (expr instanceof FieldAccessExpression) {
            FieldAccessExpression exprField = (FieldAccessExpression)expr;
            FieldConstant field = exprField.getFieldConstant();
            boolean fStatic = exprField.isStatic();
            if (fStatic) {
                code.add(new Getstatic(field));
                opDup = fWide ? new Dup2() : new Dup();
                opFinal = new Putstatic(field);
            } else {
                exprField.getExpression().compile(ctx, code, fReached, errlist);
                code.add(new Dup());
                code.add(new Getfield(field));
                opDup = fWide ? new Dup2_x1() : new Dup_x1();
                opFinal = new Putfield(field);
            }
        } else if (expr instanceof ArrayAccessExpression) {
            Op opLoad = null;
            Op opStore = null;
            switch (chType) {
                case 'B': {
                    opLoad = new Baload();
                    opStore = new Bastore();
                    break;
                }
                case 'C': {
                    opLoad = new Caload();
                    opStore = new Castore();
                    break;
                }
                case 'S': {
                    opLoad = new Saload();
                    opStore = new Sastore();
                    break;
                }
                case 'I': {
                    opLoad = new Iaload();
                    opStore = new Iastore();
                    break;
                }
                case 'J': {
                    opLoad = new Laload();
                    opStore = new Lastore();
                    break;
                }
                case 'F': {
                    opLoad = new Faload();
                    opStore = new Fastore();
                    break;
                }
                case 'D': {
                    opLoad = new Daload();
                    opStore = new Dastore();
                }
            }
            ArrayAccessExpression exprElement = (ArrayAccessExpression)expr;
            exprElement.getArray().compile(ctx, code, fReached, errlist);
            exprElement.getIndex().compile(ctx, code, fReached, errlist);
            code.add(new Dup2());
            code.add(opLoad);
            if (!fDiscard) {
                opDup = fWide ? new Dup2_x2() : new Dup_x2();
            }
            opFinal = opStore;
        } else {
            throw new IllegalStateException();
        }
        Op opConst = null;
        Op opAdd = null;
        Op opConv = null;
        switch (chType) {
            case 'B': {
                opConst = new Iconst(CONSTANT_ICONST_1);
                opAdd = fSub ? new Isub() : new Iadd();
                opConv = new I2b();
                break;
            }
            case 'C': {
                opConst = new Iconst(CONSTANT_ICONST_1);
                opAdd = fSub ? new Isub() : new Iadd();
                opConv = new I2c();
                break;
            }
            case 'S': {
                opConst = new Iconst(CONSTANT_ICONST_1);
                opAdd = fSub ? new Isub() : new Iadd();
                opConv = new I2s();
                break;
            }
            case 'I': {
                opConst = new Iconst(CONSTANT_ICONST_1);
                opAdd = fSub ? new Isub() : new Iadd();
                break;
            }
            case 'J': {
                opConst = new Lconst(CONSTANT_LCONST_1);
                opAdd = fSub ? new Lsub() : new Ladd();
                break;
            }
            case 'F': {
                opConst = new Fconst(CONSTANT_FCONST_1);
                opAdd = fSub ? new Fsub() : new Fadd();
                break;
            }
            case 'D': {
                opConst = new Dconst(CONSTANT_DCONST_1);
                opAdd = fSub ? new Dsub() : new Dadd();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (fPost && opDup != null) {
            code.add(opDup);
        }
        code.add(opConst);
        code.add(opAdd);
        if (opConv != null) {
            code.add(opConv);
        }
        if (fPre && opDup != null) {
            code.add(opDup);
        }
        if (opFinal != null) {
            code.add(opFinal);
        }
        return fReached;
    }
}

