/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Extractor;
import com.tangosol.dev.component.Storage;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.ErrorList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CacheStorage
extends Extractor {
    private static final String CLASS = "CacheStorage";
    private Map m_tblComponent = new LocalCache(128, 0);
    private Map m_tblSignature = new LocalCache(512, 0);

    public CacheStorage(Storage storage) {
        super(storage);
    }

    @Override
    public synchronized Component loadComponent(String sName, boolean fReadOnly, ErrorList errlist) throws ComponentException {
        Component cd;
        if (fReadOnly && this.m_tblComponent.containsKey(sName)) {
            cd = (Component)this.m_tblComponent.get(sName);
        } else {
            cd = super.loadComponent(sName, true, errlist);
            this.m_tblComponent.put(sName, cd);
        }
        if (cd != null && !fReadOnly) {
            try {
                cd = (Component)cd.clone();
                cd.setModifiable(true);
            }
            catch (CloneNotSupportedException e) {
                throw new ComponentException(e.toString());
            }
        }
        return cd;
    }

    @Override
    public synchronized void storeComponent(Component cd, ErrorList errlist) throws ComponentException {
        super.storeComponent(cd, errlist);
        String sName = cd.getQualifiedName();
        this.flushComponentCache(sName);
        if (cd.isSignature()) {
            this.flushSignatureCache(sName, cd.isInterface());
        }
    }

    @Override
    public synchronized void removeComponent(String sName) throws ComponentException {
        super.removeComponent(sName);
        this.flushComponentCache(sName);
        if (!Component.isQualifiedNameLegal(sName)) {
            this.flushSignatureCache(sName, true);
        }
    }

    @Override
    public synchronized Component loadSignature(String sName) throws ComponentException {
        Component cdJCS = null;
        if (this.m_tblSignature.containsKey(sName)) {
            cdJCS = (Component)this.m_tblSignature.get(sName);
        } else {
            cdJCS = super.loadSignature(sName);
            this.m_tblSignature.put(sName, cdJCS);
        }
        if (cdJCS != null) {
            cdJCS.setModifiable(false);
        }
        return cdJCS;
    }

    @Override
    public synchronized void storeSignature(Component cdJCS) throws ComponentException {
        super.storeSignature(cdJCS);
        this.flushSignatureCache(cdJCS.getName(), cdJCS.isInterface());
    }

    private void flushComponentCache(String sName) {
        Iterator iter = this.m_tblComponent.keySet().iterator();
        while (iter.hasNext()) {
            String sCached = (String)iter.next();
            Component cdCached = (Component)this.m_tblComponent.get(sCached);
            if (cdCached == null || !cdCached.isImpactedBy(sName)) continue;
            iter.remove();
        }
        this.m_tblComponent.remove(sName);
    }

    private void flushSignatureCache(String sName, boolean fInterface) throws ComponentException {
        HashMap mapImpacted = new HashMap();
        LinkedList listCached = new LinkedList(this.m_tblSignature.keySet());
        Iterator<Object> iter = listCached.iterator();
        while (iter.hasNext()) {
            this.collectImpactedJavaClassSignatures(sName, fInterface, (String)iter.next(), mapImpacted);
        }
        for (String sImpacted : mapImpacted.keySet()) {
            this.m_tblSignature.remove(sImpacted);
        }
        this.m_tblSignature.remove(sName);
    }

    private boolean collectImpactedJavaClassSignatures(String sModified, boolean fInterface, String sJcs, HashMap mapImpacted) throws ComponentException {
        if (sJcs.equals(sModified)) {
            return true;
        }
        Component jcs = this.loadSignature(sJcs);
        if (jcs == null) {
            return true;
        }
        String sSuper = jcs.getSuperName();
        if (sSuper.length() != 0 && this.collectImpactedJavaClassSignatures(sModified, fInterface, sSuper, mapImpacted)) {
            mapImpacted.put(sJcs, null);
            return true;
        }
        if (fInterface) {
            String[] asImplements = jcs.getImplements();
            for (int i = 0; i < asImplements.length; ++i) {
                if (!this.collectImpactedJavaClassSignatures(sModified, fInterface, asImplements[i], mapImpacted)) continue;
                mapImpacted.put(sJcs, null);
                return true;
            }
        }
        return false;
    }

    public void flush() {
        this.m_tblComponent.clear();
        this.m_tblSignature.clear();
    }

    @Override
    public String toString() {
        String sExtractor = super.toString();
        return CLASS + sExtractor.substring(sExtractor.indexOf(40));
    }
}

