/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.engarde;

import com.tangosol.engarde.ApplicationEntry;
import com.tangosol.engarde.ApplicationReader;
import com.tangosol.engarde.ApplicationWriter;
import com.tangosol.engarde.JarStorage;
import com.tangosol.util.Base;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.StringTable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarFile;

public class DirectoryStorage
extends Base
implements ApplicationReader,
ApplicationWriter {
    private boolean m_fAllowRead;
    private boolean m_fAllowWrite;
    private File m_dirRoot;
    private Entry m_currEntry;
    private OutputStream m_currOut;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    private static final String CLASS = "DirectoryStorage";

    public DirectoryStorage(File dirRoot, int iAccess) throws IOException {
        DirectoryStorage.azzert((iAccess & 3) != 0, "Illegal access mode: " + iAccess);
        if (dirRoot == null || !dirRoot.isDirectory()) {
            throw new IOException("Not a directory: " + dirRoot);
        }
        this.m_dirRoot = dirRoot.getCanonicalFile();
        this.m_fAllowRead = (iAccess & 1) != 0;
        this.m_fAllowWrite = (iAccess & 2) != 0;
    }

    public File getRoot() {
        return this.m_dirRoot;
    }

    public String toString() {
        return "DirectoryStorage: " + this.m_dirRoot;
    }

    @Override
    public InputStream getInputStream(ApplicationEntry entry) throws IOException {
        if (!this.m_fAllowRead) {
            throw new IllegalStateException("ApplicationReader operation is not allowed");
        }
        File file = new File(this.m_dirRoot, entry.getName());
        return file.isFile() ? new FileInputStream(file) : new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public ApplicationReader extractApplication(String sName) throws IOException {
        if (!this.m_fAllowRead) {
            throw new IllegalStateException("ApplicationReader operation is not allowed");
        }
        File file = new File(this.m_dirRoot, sName);
        if (file.exists()) {
            return file.isDirectory() ? new DirectoryStorage(file, this.m_fAllowWrite ? 3 : 1) : new JarStorage(new JarFile(file.getCanonicalFile()));
        }
        return null;
    }

    @Override
    public ApplicationEntry getEntry(String sName) {
        if (!this.m_fAllowRead) {
            throw new IllegalStateException("ApplicationReader operation is not allowed");
        }
        File file = new File(this.m_dirRoot, sName);
        return file.exists() ? new Entry(sName, file.isDirectory()) : null;
    }

    @Override
    public Enumeration entries() {
        if (!this.m_fAllowRead) {
            throw new IllegalStateException("ApplicationReader operation is not allowed");
        }
        StringTable tbl = new StringTable();
        this.collectEntries(this.m_dirRoot, tbl);
        return tbl.elements();
    }

    private void collectEntries(File dir, StringTable tbl) {
        File[] aFile = dir.listFiles();
        if (aFile != null) {
            String sRoot = this.m_dirRoot.getPath() + File.separatorChar;
            int cchRoot = sRoot.length();
            for (File file : aFile) {
                String sPath = file.getPath();
                DirectoryStorage.azzert(sPath.startsWith(sRoot));
                sPath = sPath.substring(cchRoot).replace(File.separatorChar, '/');
                if (file.isFile()) {
                    tbl.put(sPath, new Entry(sPath, false));
                    continue;
                }
                if (!file.isDirectory()) continue;
                tbl.put(sPath, new Entry(sPath, true));
                this.collectEntries(file, tbl);
            }
        }
    }

    @Override
    public void close() {
        this.m_fAllowRead = false;
        if (this.m_fAllowWrite) {
            try {
                this.closeEntry();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_fAllowWrite = false;
        }
    }

    @Override
    public ApplicationEntry createEntry(ApplicationEntry entry) throws IOException {
        if (!this.m_fAllowWrite) {
            throw new IllegalStateException("ApplicationWriter operation is not allowed");
        }
        Entry entryCurr = this.m_currEntry;
        if (entryCurr != null) {
            this.closeEntry();
        }
        entryCurr = this.ensureEntry(entry.getName(), entry instanceof Entry && ((Entry)entry).isDirectory());
        entryCurr.setTime(entry.getTime());
        return entryCurr;
    }

    @Override
    public ApplicationEntry createEntry(String sName) throws IOException {
        if (!this.m_fAllowWrite) {
            throw new IllegalStateException("ApplicationWriter operation is not allowed");
        }
        Entry entry = this.m_currEntry;
        if (entry != null) {
            this.closeEntry();
        }
        return this.ensureEntry(sName, sName.endsWith("/"));
    }

    private Entry ensureEntry(String sName, boolean fDir) throws IOException {
        File file = new File(this.m_dirRoot, sName).getCanonicalFile();
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("DirectoryStorage: Failure to create directory: " + dir);
        }
        this.m_currOut = fDir ? NullImplementation.getOutputStream() : new FileOutputStream(file);
        this.m_currEntry = new Entry(sName, fDir);
        return this.m_currEntry;
    }

    @Override
    public void writeEntryData(byte[] ab, int of, int cb) throws IOException {
        if (!this.m_fAllowWrite) {
            throw new IllegalStateException("ApplicationWriter operation is not allowed");
        }
        if (this.m_currOut == null) {
            throw new IllegalStateException("Request is out of sequence");
        }
        if (this.m_currEntry.isDirectory() && cb > 0) {
            throw new IllegalStateException("Illegal write operation to a directory: " + this.m_currEntry);
        }
        if (cb > 0) {
            this.m_currOut.write(ab, of, cb);
        }
    }

    @Override
    public void closeEntry() throws IOException {
        if (!this.m_fAllowWrite) {
            throw new IllegalStateException("ApplicationWriter operation is not allowed");
        }
        Entry entry = this.m_currEntry;
        if (entry != null) {
            this.m_currOut.close();
            entry.getFile().setLastModified(entry.getTime());
            this.m_currOut = null;
            this.m_currEntry = null;
        }
    }

    public class Entry
    implements ApplicationEntry {
        private String m_sPath;
        private boolean m_fDir;
        private long m_lTime;

        protected Entry(String sPath, boolean fDir) {
            Base.azzert(sPath != null);
            this.m_sPath = sPath;
            this.m_fDir = fDir;
        }

        public File getFile() {
            return new File(DirectoryStorage.this.m_dirRoot, this.m_sPath);
        }

        public boolean isDirectory() {
            return this.m_fDir;
        }

        @Override
        public String getName() {
            return this.m_sPath;
        }

        @Override
        public long getTime() {
            return this.m_lTime == 0L ? this.getFile().lastModified() : this.m_lTime;
        }

        @Override
        public void setTime(long lTime) {
            this.m_lTime = lTime;
        }

        @Override
        public long getSize() {
            return this.getFile().length();
        }

        @Override
        public void setSize(long lSize) {
        }

        public String toString() {
            return "DirectoryStorage$Entry: " + this.getFile();
        }
    }
}

