/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.InputStreaming;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class Base64InputStream
extends InputStream
implements InputStreaming {
    protected static final byte[] EMPTY = new byte[0];
    protected boolean m_fClosed;
    protected boolean m_fEOF;
    protected Reader m_reader;
    protected int[] m_abGroup = new int[3];
    protected int m_ofbGroup = this.m_abGroup.length;

    public Base64InputStream(Reader reader) {
        this.m_reader = reader;
    }

    @Override
    public int read() throws IOException {
        int ofbGroup;
        if (this.m_fClosed) {
            throw new IOException("Base64InputStream is closed");
        }
        int ofb = this.m_ofbGroup;
        int[] ab = this.m_abGroup;
        int cb = ab.length;
        if (ofb < cb) {
            this.m_ofbGroup = ofb + 1;
            return ab[ofb];
        }
        if (this.m_fEOF) {
            return -1;
        }
        Reader reader = this.m_reader;
        int nGroup = 0;
        int cch = 0;
        while (cch < 4) {
            int nch = reader.read();
            int nHexit = -1;
            block0 : switch (nch) {
                case -1: {
                    this.m_fEOF = true;
                    if (cch > 0) {
                        throw new EOFException();
                    }
                    return -1;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    nHexit = nch - 65;
                    break;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    nHexit = 26 + nch - 97;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    nHexit = 52 + nch - 48;
                    break;
                }
                case 43: {
                    nHexit = 62;
                    break;
                }
                case 47: {
                    nHexit = 63;
                    break;
                }
                case 61: {
                    this.m_fEOF = true;
                    switch (cch) {
                        case 0: 
                        case 1: {
                            throw new IOException("illegal base64 pad:  at offset " + cch + " in a 4-char group");
                        }
                        case 2: {
                            block19: while (true) {
                                switch (reader.read()) {
                                    case -1: 
                                    case 61: {
                                        break block0;
                                    }
                                    case 9: 
                                    case 10: 
                                    case 12: 
                                    case 13: 
                                    case 32: {
                                        continue block19;
                                    }
                                }
                                break;
                            }
                            throw new IOException("missing final base64 pad");
                        }
                    }
                    break;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    this.m_fEOF = true;
                    throw new IOException("illegal base64 encoding character: " + (char)nch);
                }
            }
            if (nHexit >= 0) {
                nGroup |= nHexit << 6 * (4 - ++cch);
            }
            if (!this.m_fEOF) continue;
            break;
        }
        int ofbCur = ofbGroup = 4 - cch;
        int cBits = 16;
        while (ofbCur < 3) {
            ab[ofbCur] = nGroup >> cBits & 0xFF;
            ++ofbCur;
            cBits -= 8;
        }
        this.m_ofbGroup = ofbGroup;
        return this.read();
    }

    @Override
    public int available() throws IOException {
        return this.m_fClosed ? 0 : this.m_abGroup.length - this.m_ofbGroup;
    }

    @Override
    public void close() throws IOException {
        this.m_fClosed = true;
    }

    public static byte[] decode(char[] ach) {
        return Base64InputStream.decode(ach, true);
    }

    public static byte[] decode(char[] ach, boolean fJunk) {
        return Base64InputStream.decode(ach, 0, ach.length, fJunk);
    }

    public static byte[] decode(char[] ach, int of, int cch) {
        return Base64InputStream.decode(ach, of, cch, true);
    }

    public static byte[] decode(char[] ach, int of, int cch, boolean fJunk) {
        if (fJunk) {
            char[] achNew = null;
            int ofNew = 0;
            int ofPrev = of;
            int ofEnd = of + cch;
            block4: for (int ofCur = of; ofCur < ofEnd; ++ofCur) {
                switch (ach[ofCur]) {
                    case '+': 
                    case '/': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case '=': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        continue block4;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (ofPrev == ofCur) {
                            ++ofPrev;
                            continue block4;
                        }
                        if (achNew == null) {
                            achNew = new char[cch];
                        }
                        if (ofCur > ofPrev) {
                            int cchCopy = ofCur - ofPrev;
                            System.arraycopy(ach, ofPrev, achNew, ofNew, cchCopy);
                            ofNew += cchCopy;
                        }
                        ofPrev = ofCur + 1;
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal base64 encoding character: " + ach[ofCur]);
                    }
                }
            }
            if (achNew != null) {
                if (ofPrev < ofEnd) {
                    int cchCopy = ofEnd - ofPrev;
                    System.arraycopy(ach, ofPrev, achNew, ofNew, cchCopy);
                    ofNew += cchCopy;
                }
                ach = achNew;
                of = 0;
                cch = ofNew;
            }
        }
        if (cch == 0) {
            return EMPTY;
        }
        int cGroups = cch / 4;
        int cchRem = cch % 4;
        if (cchRem == 0) {
            --cGroups;
            cchRem = 4;
        }
        int ofRem = of + cch - cchRem;
        int nGroup = 0;
        int cchGroup = 0;
        boolean fDone = false;
        for (int i = 0; i < cchRem; ++i) {
            char ch = ach[ofRem + i];
            if (ch == '=') {
                if (i < 2) {
                    throw new IllegalArgumentException("illegal base64 ending pad:  pad can not start before the third base64 alpha of the final group");
                }
                fDone = true;
                continue;
            }
            if (fDone) {
                throw new IllegalArgumentException("illegal base64 ending pad:  pad can not be followed by a legit base64 alpha");
            }
            nGroup |= Base64InputStream.decode(ch) << 6 * (4 - ++cchGroup);
        }
        if (cchGroup < 2) {
            throw new IllegalArgumentException("illegal base64 ending group:  group must contain at least two base64 alpha chars");
        }
        int cb = cGroups * 3 + cchGroup - 1;
        byte[] ab = new byte[cb];
        int i = 0;
        int c = cchGroup - 1;
        int ofb = cb - c;
        int cBits = 16;
        while (i < c) {
            ab[ofb] = (byte)(nGroup >> cBits & 0xFF);
            ++i;
            ++ofb;
            cBits -= 8;
        }
        int ofb2 = 0;
        for (int iGroup = 0; iGroup < cGroups; ++iGroup) {
            nGroup = Base64InputStream.decode(ach[of++]) << 18 | Base64InputStream.decode(ach[of++]) << 12 | Base64InputStream.decode(ach[of++]) << 6 | Base64InputStream.decode(ach[of++]);
            ab[ofb2++] = (byte)(nGroup >> 16);
            ab[ofb2++] = (byte)(nGroup >> 8 & 0xFF);
            ab[ofb2++] = (byte)(nGroup & 0xFF);
        }
        return ab;
    }

    public static int decode(char ch) {
        switch (ch) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': {
                return ch - 65;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return 26 + ch - 97;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return 52 + ch - 48;
            }
            case '+': {
                return 62;
            }
            case '/': {
                return 63;
            }
        }
        throw new IllegalArgumentException("illegal base64 encoding character: " + ch);
    }
}

