/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;

public class Utf8Reader
extends Reader {
    private InputStream m_stream;

    public Utf8Reader(byte[] ab) {
        this(new ByteArrayInputStream(ab));
    }

    public Utf8Reader(InputStream stream) {
        this.m_stream = stream;
    }

    @Override
    public int read() throws IOException {
        InputStream stream = this.m_stream;
        int ch = stream.read();
        switch ((ch & 0xF0) >>> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (char)ch;
            }
            case 12: 
            case 13: {
                int ch2 = stream.read();
                if ((ch2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                return (ch & 0x1F) << 6 | ch2 & 0x3F;
            }
            case 14: {
                int ch2 = stream.read();
                int ch3 = stream.read();
                if ((ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                return (ch & 0xF) << 12 | (ch2 & 0x3F) << 6 | ch3 & 0x3F;
            }
            case 15: {
                if (ch != -1) break;
                return -1;
            }
        }
        throw new UTFDataFormatException("illegal leading UTF byte: " + ch);
    }

    @Override
    public int read(char[] ach) throws IOException {
        return this.read(ach, 0, ach.length);
    }

    @Override
    public int read(char[] ach, int of, int cch) throws IOException {
        int cchActual = 0;
        int ofEnd = of + cch;
        while (of < ofEnd) {
            int ch = this.read();
            if (ch == -1) {
                if (cchActual != 0) break;
                return -1;
            }
            ach[of] = (char)ch;
            ++of;
            ++cchActual;
        }
        return cchActual;
    }

    @Override
    public long skip(long cch) throws IOException {
        int cchActual = 0;
        while ((long)cchActual < cch && this.read() != -1) {
            ++cchActual;
        }
        return cchActual;
    }

    @Override
    public boolean ready() throws IOException {
        return this.m_stream instanceof ByteArrayInputStream;
    }

    @Override
    public boolean markSupported() {
        return this.m_stream.markSupported();
    }

    @Override
    public void mark(int cchLimit) throws IOException {
        this.m_stream.mark(cchLimit * 3);
    }

    @Override
    public void reset() throws IOException {
        this.m_stream.reset();
    }

    @Override
    public void close() throws IOException {
    }
}

