/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;

public class WrapperBufferInput
extends Base
implements ReadBuffer.BufferInput {
    private final DataInput m_in;
    private final ReadBuffer m_rb;

    public WrapperBufferInput(DataInput in) {
        this(in, in instanceof ReadBuffer.BufferInput ? ((ReadBuffer.BufferInput)in).getBuffer() : null);
    }

    public WrapperBufferInput(DataInput in, ReadBuffer rb) {
        this.m_in = in;
        this.m_rb = rb;
    }

    @Override
    public int read() throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStreaming) {
            return ((InputStreaming)((Object)in)).read();
        }
        if (in instanceof InputStream) {
            return ((InputStream)((Object)in)).read();
        }
        if (in instanceof ObjectInput) {
            return ((ObjectInput)in).read();
        }
        try {
            return this.readUnsignedByte();
        }
        catch (EOFException e) {
            return -1;
        }
    }

    @Override
    public int read(byte[] ab) throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStreaming) {
            return ((InputStreaming)((Object)in)).read(ab);
        }
        if (in instanceof InputStream) {
            return ((InputStream)((Object)in)).read(ab);
        }
        if (in instanceof ObjectInput) {
            return ((ObjectInput)in).read(ab);
        }
        int cb = ab.length;
        for (int of = 0; of < cb; ++of) {
            try {
                ab[of] = (byte)this.readUnsignedByte();
                continue;
            }
            catch (EOFException e) {
                return cb == 0 ? -1 : cb;
            }
        }
        return cb;
    }

    @Override
    public int read(byte[] ab, int of, int cb) throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStreaming) {
            return ((InputStreaming)((Object)in)).read(ab, of, cb);
        }
        if (in instanceof InputStream) {
            return ((InputStream)((Object)in)).read(ab, of, cb);
        }
        if (in instanceof ObjectInput) {
            return ((ObjectInput)in).read(ab, of, cb);
        }
        if (of < 0 || cb < 0 || of + cb > ab.length) {
            throw new IndexOutOfBoundsException("ab.length=" + ab.length + ", of=" + of + ", cb=" + cb);
        }
        int ofStart = of;
        int ofEnd = of + cb - 1;
        while (of <= ofEnd) {
            try {
                ab[of] = (byte)this.readUnsignedByte();
            }
            catch (EOFException e) {
                return of == ofStart ? -1 : of - ofStart;
            }
            ++of;
        }
        return cb;
    }

    @Override
    public long skip(long cb) throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStreaming) {
            return ((InputStreaming)((Object)in)).skip(cb);
        }
        if (in instanceof InputStream) {
            return ((InputStream)((Object)in)).skip(cb);
        }
        if (in instanceof ObjectInput) {
            return ((ObjectInput)in).skip(cb);
        }
        if (cb > Integer.MAX_VALUE) {
            cb = Integer.MAX_VALUE;
        }
        return in.skipBytes((int)cb);
    }

    @Override
    public int available() throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStreaming) {
            return ((InputStreaming)((Object)in)).available();
        }
        if (in instanceof InputStream) {
            return ((InputStream)((Object)in)).available();
        }
        if (in instanceof ObjectInput) {
            return ((ObjectInput)in).available();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStreaming) {
            ((InputStreaming)((Object)in)).close();
        } else if (in instanceof InputStream) {
            ((InputStream)((Object)in)).close();
        } else if (in instanceof ObjectInput) {
            ((ObjectInput)in).close();
        }
    }

    @Override
    public void mark(int cbReadLimit) {
        DataInput in = this.m_in;
        if (in instanceof InputStreaming) {
            ((InputStreaming)((Object)in)).mark(cbReadLimit);
        } else if (in instanceof InputStream) {
            ((InputStream)((Object)in)).mark(cbReadLimit);
        }
    }

    @Override
    public void reset() throws IOException {
        DataInput in = this.m_in;
        if (in instanceof InputStreaming) {
            ((InputStreaming)((Object)in)).reset();
        } else if (in instanceof InputStream) {
            ((InputStream)((Object)in)).reset();
        } else {
            throw new IOException("mark not supported");
        }
    }

    @Override
    public boolean markSupported() {
        DataInput in = this.m_in;
        if (in instanceof InputStreaming) {
            return ((InputStreaming)((Object)in)).markSupported();
        }
        if (in instanceof InputStream) {
            return ((InputStream)((Object)in)).markSupported();
        }
        return false;
    }

    @Override
    public void readFully(byte[] ab) throws IOException {
        this.m_in.readFully(ab);
    }

    @Override
    public void readFully(byte[] ab, int of, int cb) throws IOException {
        this.m_in.readFully(ab, of, cb);
    }

    @Override
    public int skipBytes(int cb) throws IOException {
        return this.m_in.skipBytes(cb);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.m_in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.m_in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.m_in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.m_in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.m_in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.m_in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.m_in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.m_in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.m_in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.m_in.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.m_in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.m_in.readUTF();
    }

    @Override
    public ReadBuffer getBuffer() {
        return this.m_rb;
    }

    @Override
    public String readSafeUTF() throws IOException {
        DataInput in = this.m_in;
        if (in instanceof ReadBuffer.BufferInput) {
            return ((ReadBuffer.BufferInput)in).readSafeUTF();
        }
        return ExternalizableHelper.readSafeUTF(in);
    }

    @Override
    public int readPackedInt() throws IOException {
        DataInput in = this.m_in;
        if (in instanceof ReadBuffer.BufferInput) {
            return ((ReadBuffer.BufferInput)in).readPackedInt();
        }
        return ExternalizableHelper.readInt(in);
    }

    @Override
    public long readPackedLong() throws IOException {
        DataInput in = this.m_in;
        if (in instanceof ReadBuffer.BufferInput) {
            return ((ReadBuffer.BufferInput)in).readPackedLong();
        }
        return ExternalizableHelper.readLong(in);
    }

    @Override
    public ReadBuffer readBuffer(int cb) throws IOException {
        DataInput in = this.m_in;
        if (in instanceof ReadBuffer.BufferInput) {
            return ((ReadBuffer.BufferInput)in).readBuffer(cb);
        }
        byte[] ab = new byte[cb];
        this.readFully(ab);
        return new ByteArrayReadBuffer(ab);
    }

    @Override
    public int getOffset() {
        DataInput in = this.m_in;
        if (in instanceof ReadBuffer.BufferInput) {
            return ((ReadBuffer.BufferInput)in).getOffset();
        }
        return 0;
    }

    @Override
    public void setOffset(int of) {
        DataInput in = this.m_in;
        if (!(in instanceof ReadBuffer.BufferInput)) {
            throw new UnsupportedOperationException();
        }
        ((ReadBuffer.BufferInput)in).setOffset(of);
    }

    public DataInput getDataInput() {
        return this.m_in;
    }
}

