/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.lh;

import com.tangosol.io.lh.JLHSelect;
import com.tangosol.io.lh.JLHSession;
import com.tangosol.io.lh.LHAlreadyLockedException;
import com.tangosol.io.lh.LHBuffer;
import com.tangosol.io.lh.LHException;
import com.tangosol.io.lh.LHFile;
import com.tangosol.io.lh.LHGroupLock;
import com.tangosol.io.lh.LHIOException;
import com.tangosol.io.lh.LHLock;
import com.tangosol.io.lh.LHNotActiveException;
import com.tangosol.io.lh.LHReadOnlyException;
import com.tangosol.io.lh.LHRecordNotFoundException;
import com.tangosol.io.lh.LHSelect;
import com.tangosol.io.lh.LHSubs;
import com.tangosol.io.lh.LHTable;
import java.io.IOException;
import java.util.Properties;

public class JLHFile
implements LHFile {
    private JLHSession m_ThisSession;
    private LHTable Table;
    private boolean m_bActive;
    private JLHFile m_SessionFileListNext;
    private JLHFile m_SessionFileListPrevious;
    private JLHFile TableQueueNext;
    private JLHFile TableQueuePrevious;
    private LHLock FileLocks;
    private LHLock RecordLocks;
    private LHGroupLock UserGroupLock;
    Properties m_selectOptions = null;

    static String ByteToString(byte[] bytes) {
        return new String(bytes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JLHFile(JLHSession Session2, LHTable Table, Properties selectOptions) {
        this.m_ThisSession = Session2;
        this.Table = Table;
        this.m_selectOptions = selectOptions;
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].JLHFile()", Table.Name());
        }
        Object object = this.m_ThisSession.m_syncSessionObjectList;
        synchronized (object) {
            if (this.m_ThisSession.m_SessionFileListTail == null) {
                this.m_ThisSession.m_SessionFileListHead = this;
            } else {
                this.m_ThisSession.m_SessionFileListTail.m_SessionFileListNext = this;
            }
            this.m_SessionFileListNext = null;
            this.m_SessionFileListPrevious = this.m_ThisSession.m_SessionFileListTail;
            this.m_ThisSession.m_SessionFileListTail = this;
        }
        object = Table.syncLHQueues;
        synchronized (object) {
            if (Table.LHFileQueueTail == null) {
                Table.LHFileQueueHead = this;
            } else {
                Table.LHFileQueueTail.TableQueueNext = this;
            }
            this.TableQueueNext = null;
            this.TableQueuePrevious = Table.LHFileQueueTail;
            Table.LHFileQueueTail = this;
        }
        this.m_bActive = true;
    }

    @Override
    public String getFileName() {
        return this.Table.Name();
    }

    @Override
    public int getGroupLockId() {
        return this.UserGroupLock.group;
    }

    @Override
    public void close() throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].close()", null);
        }
        this.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void finalize() {
        Object object;
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].finalize()", null);
        }
        if (!this.m_bActive) {
            return;
        }
        this.m_bActive = false;
        Object object2 = this.m_ThisSession.syncLocks;
        synchronized (object2) {
            object = this.Table.syncLocks;
            synchronized (object) {
                while (this.FileLocks != null) {
                    this.ReleaseFileLock(this.FileLocks);
                }
                while (this.RecordLocks != null) {
                    this.ReleaseRecordLock(this.RecordLocks);
                }
            }
        }
        try {
            this.Table.LHFileQueueHead.close();
            this.Table.LHSelectQueueHead.close();
        }
        catch (NullPointerException e) {
        }
        catch (LHException e) {
            // empty catch block
        }
        if (this.UserGroupLock != null) {
            try {
                this.unlockGroup(this.UserGroupLock.group);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!this.Table.ReadOnly) {
            boolean Flush = false;
            object = this.Table.syncAlpha;
            synchronized (object) {
                if (this.Table.NewAlpha != this.Table.Alpha) {
                    Flush = true;
                }
            }
            if (!Flush && this.Table.Group0HeaderSize == 26) {
                object = this.Table.syncRecordCount;
                synchronized (object) {
                    if (this.Table.NewRecordCount != this.Table.RecordCount) {
                        Flush = true;
                    }
                }
            }
            if (Flush) {
                try {
                    this.Table.InitializeFileUse();
                    LHSubs D = LHSubs.InitData(this.Table);
                    try {
                        D.LoadGroup0Header(true);
                        Flush = false;
                        Object object3 = this.Table.syncAlpha;
                        synchronized (object3) {
                            if (this.Table.NewAlpha != this.Table.Alpha) {
                                Flush = true;
                            }
                        }
                        if (!Flush && this.Table.Group0HeaderSize == 26) {
                            object3 = this.Table.syncRecordCount;
                            synchronized (object3) {
                                if (this.Table.NewRecordCount != this.Table.RecordCount) {
                                    Flush = true;
                                }
                            }
                        }
                        if (Flush) {
                            D.UnloadGroup0Header();
                        }
                    }
                    finally {
                        D.TermData();
                    }
                }
                catch (LHException lHException) {
                    // empty catch block
                }
            }
        }
        Object Flush = this.m_ThisSession.m_syncSessionObjectList;
        synchronized (Flush) {
            if (this.m_SessionFileListPrevious == null) {
                this.m_ThisSession.m_SessionFileListHead = this.m_SessionFileListNext;
            } else {
                this.m_SessionFileListPrevious.m_SessionFileListNext = this.m_SessionFileListNext;
            }
            if (this.m_SessionFileListNext == null) {
                this.m_ThisSession.m_SessionFileListTail = this.m_SessionFileListPrevious;
            } else {
                this.m_SessionFileListNext.m_SessionFileListPrevious = this.m_SessionFileListPrevious;
            }
        }
        Flush = this.Table.syncLHQueues;
        synchronized (Flush) {
            if (this.TableQueuePrevious == null) {
                this.Table.LHFileQueueHead = this.TableQueueNext;
            } else {
                this.TableQueuePrevious.TableQueueNext = this.TableQueueNext;
            }
            if (this.TableQueueNext == null) {
                this.Table.LHFileQueueTail = this.TableQueuePrevious;
            } else {
                this.TableQueueNext.TableQueuePrevious = this.TableQueuePrevious;
            }
            if (this.Table.LHFileQueueTail == null && this.Table.LHSelectQueueTail == null) {
                this.Table.CloseFiles();
            }
        }
        this.Table.LHFileQueueHead = null;
        this.Table.LHSelectQueueHead = null;
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int getRecordCount() throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].getRecordCount()", null);
        }
        this.Table.InitializeFileUse();
        return this.Table.RecordCount;
    }

    @Override
    public LHSelect select() throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].select()", null);
        }
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHFile");
        }
        return new JLHSelect(this.m_ThisSession, this.Table, this.m_selectOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readRecord(byte[] key) throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].readRecord()", "Key - <" + JLHFile.ByteToString(key) + ">");
        }
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHFile");
        }
        this.Table.InitializeFileUse();
        LHSubs D = LHSubs.InitData(this.Table);
        try {
            if (D.FindKeyId(key, false)) {
                byte[] byArray = D.ExtractRecord();
                return byArray;
            }
            if (this.m_ThisSession.m_iVerbose >= 2) {
                this.m_ThisSession.LogInfo(null, "**** KEY NOT FOUND ****");
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            D.TermData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] updateRecord(byte[] key, byte[] record, boolean returnOld) throws LHException {
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHFile");
        }
        if (this.Table.ReadOnly) {
            throw new LHReadOnlyException(this.Table.Name());
        }
        byte[] oldRecord = null;
        this.Table.InitializeFileUse();
        LHSubs D = LHSubs.InitData(this.Table);
        try {
            Object object;
            if (D.M == null) {
                D.M = new LHBuffer(D.F.buffer.length);
            }
            int oldrecleng = 0;
            if (D.FindKeyId(key, true)) {
                oldrecleng = D.len_reclength + D.reclength + 1;
                if (record != null && record.length == D.reclength - D.len_recidlength - D.recidlength) {
                    D.indexsave = 0;
                    int length = record.length;
                    if (returnOld) {
                        oldRecord = new byte[length];
                    }
                    int offset = 0;
                    boolean changed = false;
                    while (length > 0) {
                        int i;
                        if (D.F.index >= this.Table.FrameSize) {
                            if (changed) {
                                D.WriteFrame(D.F, this.Table.FrameSize);
                            }
                            D.GetNextOverflowFrame();
                            changed = false;
                        }
                        if (length < (i = this.Table.FrameSize - D.F.index)) {
                            i = length;
                        }
                        if (returnOld) {
                            System.arraycopy(D.F.buffer, D.F.index, oldRecord, offset, i);
                        }
                        System.arraycopy(record, offset, D.F.buffer, D.F.index, i);
                        changed = true;
                        D.F.index += i;
                        offset += i;
                        length -= i;
                    }
                    if (changed) {
                        D.WriteFrame(D.F, this.Table.FrameSize);
                    }
                    if (this.Table.Volume.m_FlushAllUpdates) {
                        D.FlushFile(false);
                        D.FlushFile(true);
                    }
                    byte[] byArray = oldRecord;
                    return byArray;
                }
                D.M.group = D.F.group;
                D.M.overflow = D.overflowsave;
                D.M.frame = D.framesave;
                if (D.F.overflow == D.overflowsave && D.F.frame == D.framesave) {
                    System.arraycopy(D.F.buffer, 0, D.M.buffer, 0, D.indexsave);
                } else {
                    D.ReadFrame(D.M, D.indexsave);
                }
                D.M.index = D.indexsave;
                D.indexsave = 0;
                if (returnOld) {
                    oldRecord = D.ExtractRecord();
                } else {
                    D.SkipRecord();
                }
                while (!D.CheckEndOfGroup()) {
                    D.GetRecordLengths(true);
                    D.CopyKeyId();
                    D.CopyRecord();
                }
            } else {
                LHBuffer save = D.M;
                D.M = D.F;
                D.F = save;
            }
            if (record != null) {
                D.PutRecordLengths(key.length, record.length);
                D.MoveToFile(key, 0, key.length);
                D.SkipCheck(record.length);
                D.MoveToFile(record, 0, record.length);
                LHBuffer cfr_ignored_0 = D.M;
                D.OutByte(255);
                D.SkipFinish();
                LHBuffer cfr_ignored_1 = D.M;
                D.OutByte(128);
                D.ReleaseOverflowFrames();
                D.SaveFreeList();
                if (oldrecleng == 0) {
                    object = this.Table.syncRecordCount;
                    synchronized (object) {
                        ++this.Table.NewRecordCount;
                    }
                    object = this.Table.syncVerified;
                    synchronized (object) {
                        if (D.M.group < this.Table.ModuloVerified) {
                            ++this.Table.RecordCountVerified;
                        }
                    }
                }
                D.ComputeDelta(D.grouplength, D.grouplength - oldrecleng + D.len_reclength + D.reclength + 1);
                D.UnlockGroupF();
                D.FlushGroup0();
                LHSubs.CheckForResize(this.Table);
            } else if (oldrecleng > 0) {
                LHBuffer cfr_ignored_2 = D.M;
                D.OutByte(128);
                D.ReleaseOverflowFrames();
                D.SaveFreeList();
                object = this.Table.syncRecordCount;
                synchronized (object) {
                    --this.Table.NewRecordCount;
                }
                object = this.Table.syncVerified;
                synchronized (object) {
                    if (D.M.group < this.Table.ModuloVerified) {
                        --this.Table.RecordCountVerified;
                    }
                }
                D.ComputeDelta(D.grouplength, D.grouplength - oldrecleng);
                D.UnlockGroupF();
                D.FlushGroup0();
                LHSubs.CheckForResize(this.Table);
            } else {
                throw new LHRecordNotFoundException(key);
            }
            if (this.Table.Volume.m_FlushAllUpdates) {
                D.FlushFile(false);
                D.FlushFile(true);
            }
            object = oldRecord;
            return object;
        }
        finally {
            D.TermData();
        }
    }

    @Override
    public void writeRecord(byte[] key, byte[] record) throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].writeRecord()", "Key - <" + JLHFile.ByteToString(key) + ">");
        }
        this.updateRecord(key, record, false);
    }

    @Override
    public void deleteRecord(byte[] key) throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].deleteRecord()", "Key - <" + JLHFile.ByteToString(key) + ">");
        }
        this.updateRecord(key, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws LHException {
        block15: {
            if (this.m_ThisSession.m_iVerbose >= 2) {
                this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].clear()", null);
            }
            if (!this.m_bActive) {
                throw new LHNotActiveException("LHFile");
            }
            if (this.Table.ReadOnly) {
                throw new LHReadOnlyException(this.Table.Name());
            }
            this.Table.InitializeFileUse();
            LHSubs D = LHSubs.InitData(this.Table);
            try {
                boolean bSizeLocked = true;
                Object object = this.Table.syncResize;
                synchronized (object) {
                    if (this.Table.SizeLock <= 1 && this.Table.SelectLocks == 0) {
                        D.InitAllFrames(true);
                        bSizeLocked = false;
                    } else {
                        ++this.Table.SelectLocks;
                    }
                }
                if (!bSizeLocked) break block15;
                D.InitAllFrames(false);
                object = this.Table.syncResize;
                synchronized (object) {
                    if (this.Table.SelectLocks > 0) {
                        --this.Table.SelectLocks;
                    }
                }
            }
            finally {
                D.TermData();
            }
        }
        this.Table.CloseFiles();
    }

    @Override
    public void flush() throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].flush()", null);
        }
        if (this.Table.OVUpdated) {
            this.Table.OVUpdated = false;
            try {
                this.Table.OV.flush();
            }
            catch (IOException ioe) {
                this.m_ThisSession.LogError("JLHFile[" + this.hashCode() + "].flush()", ioe.getMessage());
                throw new LHIOException(this.Table.Name(), true, "Flushing", ioe.getMessage());
            }
        }
        if (this.Table.LKUpdated) {
            this.Table.LKUpdated = false;
            try {
                this.Table.LK.flush();
            }
            catch (IOException ioe) {
                this.m_ThisSession.LogError("JLHFile[" + this.hashCode() + "].flush()", ioe.getMessage());
                throw new LHIOException(this.Table.Name(), false, "Flushing", ioe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockFile(boolean exclusive) throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].lockFile()", "exclusive - " + exclusive);
        }
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHFile");
        }
        Object object = this.m_ThisSession.syncLocks;
        synchronized (object) {
            Object object2 = this.Table.syncLocks;
            synchronized (object2) {
                LHLock FileLock2 = this.Table.FileLocks;
                while (FileLock2 != null) {
                    if (FileLock2.Session == this.m_ThisSession) {
                        throw new LHAlreadyLockedException(false);
                    }
                    if (exclusive || FileLock2.exclusive) {
                        throw new LHAlreadyLockedException(true);
                    }
                    FileLock2 = FileLock2.NextFile;
                }
                FileLock2 = new LHLock();
                FileLock2.Session = this.m_ThisSession;
                FileLock2.Table = this.Table;
                FileLock2.File = this;
                FileLock2.exclusive = exclusive;
                FileLock2.PrevTable = null;
                FileLock2.NextTable = this.Table.FileLocks;
                if (this.Table.FileLocks != null) {
                    this.Table.FileLocks.PrevTable = FileLock2;
                }
                this.Table.FileLocks = FileLock2;
                FileLock2.PrevSession = null;
                FileLock2.NextSession = this.m_ThisSession.FileLocks;
                if (this.m_ThisSession.FileLocks != null) {
                    this.m_ThisSession.FileLocks.PrevSession = FileLock2;
                }
                this.m_ThisSession.FileLocks = FileLock2;
                FileLock2.PrevFile = null;
                FileLock2.NextFile = this.FileLocks;
                if (this.FileLocks != null) {
                    this.FileLocks.PrevFile = FileLock2;
                }
                this.FileLocks = FileLock2;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockFile() throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].unlockFile()", null);
        }
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHFile");
        }
        Object object = this.m_ThisSession.syncLocks;
        synchronized (object) {
            Object object2 = this.Table.syncLocks;
            synchronized (object2) {
                LHLock FileLock2 = this.Table.FileLocks;
                while (FileLock2 != null) {
                    if (FileLock2.Session == this.m_ThisSession) {
                        this.ReleaseFileLock(FileLock2);
                        break;
                    }
                    FileLock2 = FileLock2.NextFile;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockGroup(int group, boolean exclusive) throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].lockGroup()", "exclusive - " + exclusive);
        }
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHFile");
        }
        Object object = this.m_ThisSession.syncLocks;
        synchronized (object) {
            Object object2 = this.Table.syncLocks;
            synchronized (object2) {
                if (this.UserGroupLock != null) {
                    return false;
                }
                this.Table.InitializeFileUse();
                LHSubs D = LHSubs.InitData(this.Table);
                boolean status = false;
                try {
                    this.UserGroupLock = new LHGroupLock();
                    D.LockGroup(group, exclusive, this.UserGroupLock);
                    status = true;
                }
                catch (LHException lhe) {
                    this.m_ThisSession.LogError("JLHFile[" + this.hashCode() + "].lockGroup()", lhe.getMessage());
                    status = false;
                }
                finally {
                    D.TermData();
                }
                return status;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockGroup(int group) throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].unlockGroup()", null);
        }
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHFile");
        }
        Object object = this.m_ThisSession.syncLocks;
        synchronized (object) {
            Object object2 = this.Table.syncLocks;
            synchronized (object2) {
                if (this.UserGroupLock != null && this.UserGroupLock.group == group) {
                    this.Table.InitializeFileUse();
                    LHSubs D = LHSubs.InitData(this.Table);
                    try {
                        D.UnlockGroup(this.UserGroupLock);
                        this.UserGroupLock = null;
                    }
                    finally {
                        D.TermData();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockRecord(byte[] key, boolean exclusive) throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].lockRecord()", "exclusive - " + exclusive);
        }
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHFile");
        }
        Object object = this.m_ThisSession.syncLocks;
        synchronized (object) {
            Object object2 = this.Table.syncLocks;
            synchronized (object2) {
                LHLock HeadLock;
                String strKey = new String(key, 0);
                LHLock RecordLock = HeadLock = (LHLock)this.Table.RecordLocks.get(strKey);
                while (RecordLock != null) {
                    if (RecordLock.Session == this.m_ThisSession) {
                        if (this.m_ThisSession.m_iVerbose >= 2) {
                            this.m_ThisSession.LogInfo(null, "**** LOCKED BY SELF ****");
                        }
                        throw new LHAlreadyLockedException(false);
                    }
                    if (exclusive || RecordLock.exclusive) {
                        if (this.m_ThisSession.m_iVerbose >= 2) {
                            this.m_ThisSession.LogInfo(null, "**** LOCKED BY OTHER ****");
                        }
                        throw new LHAlreadyLockedException(true);
                    }
                    RecordLock = RecordLock.NextFile;
                }
                RecordLock = new LHLock();
                RecordLock.Session = this.m_ThisSession;
                RecordLock.Table = this.Table;
                RecordLock.File = this;
                RecordLock.value = strKey;
                RecordLock.exclusive = exclusive;
                RecordLock.PrevTable = null;
                RecordLock.NextTable = HeadLock;
                if (HeadLock == null) {
                    this.Table.RecordLocks.put(strKey, RecordLock);
                } else {
                    HeadLock.PrevTable = RecordLock;
                }
                RecordLock.PrevSession = null;
                RecordLock.NextSession = this.m_ThisSession.RecordLocks;
                if (this.m_ThisSession.RecordLocks != null) {
                    this.m_ThisSession.RecordLocks.PrevSession = RecordLock;
                }
                this.m_ThisSession.RecordLocks = RecordLock;
                RecordLock.PrevFile = null;
                RecordLock.NextFile = this.RecordLocks;
                if (this.RecordLocks != null) {
                    this.RecordLocks.PrevFile = RecordLock;
                }
                this.RecordLocks = RecordLock;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockRecord(byte[] key) throws LHException {
        if (this.m_ThisSession.m_iVerbose >= 2) {
            this.m_ThisSession.LogInfo("JLHFile[" + this.hashCode() + "].unlockRecord()", null);
        }
        if (!this.m_bActive) {
            throw new LHNotActiveException("LHFile");
        }
        Object object = this.m_ThisSession.syncLocks;
        synchronized (object) {
            Object object2 = this.Table.syncLocks;
            synchronized (object2) {
                LHLock RecordLock = (LHLock)this.Table.RecordLocks.get(new String(key, 0));
                while (RecordLock != null) {
                    if (RecordLock.Session == this.m_ThisSession) {
                        this.ReleaseRecordLock(RecordLock);
                        break;
                    }
                    RecordLock = RecordLock.NextFile;
                }
            }
        }
    }

    void ReleaseFileLock(LHLock FileLock2) {
        if (FileLock2.PrevTable == null) {
            FileLock2.Table.FileLocks = FileLock2.NextTable;
        } else {
            FileLock2.PrevTable.NextTable = FileLock2.NextTable;
        }
        if (FileLock2.NextTable != null) {
            FileLock2.NextTable.PrevTable = FileLock2.PrevTable;
        }
        if (FileLock2.PrevSession == null) {
            FileLock2.Session.FileLocks = FileLock2.NextSession;
        } else {
            FileLock2.PrevSession.NextSession = FileLock2.NextSession;
        }
        if (FileLock2.NextSession != null) {
            FileLock2.NextSession.PrevSession = FileLock2.PrevSession;
        }
        if (FileLock2.PrevFile == null) {
            FileLock2.File.FileLocks = FileLock2.NextFile;
        } else {
            FileLock2.PrevFile.NextFile = FileLock2.NextFile;
        }
        if (FileLock2.NextFile != null) {
            FileLock2.NextFile.PrevFile = FileLock2.PrevFile;
        }
    }

    void ReleaseRecordLock(LHLock RecordLock) {
        if (RecordLock.PrevTable == null) {
            if (RecordLock.NextTable == null) {
                RecordLock.Table.RecordLocks.remove(RecordLock.value);
            }
        } else {
            RecordLock.PrevTable.NextTable = RecordLock.NextTable;
        }
        if (RecordLock.NextTable != null) {
            RecordLock.NextTable.PrevTable = RecordLock.PrevTable;
        }
        if (RecordLock.PrevSession == null) {
            RecordLock.Session.RecordLocks = RecordLock.NextSession;
        } else {
            RecordLock.PrevSession.NextSession = RecordLock.NextSession;
        }
        if (RecordLock.NextSession != null) {
            RecordLock.NextSession.PrevSession = RecordLock.PrevSession;
        }
        if (RecordLock.PrevFile == null) {
            RecordLock.File.RecordLocks = RecordLock.NextFile;
        } else {
            RecordLock.PrevFile.NextFile = RecordLock.NextFile;
        }
        if (RecordLock.NextFile != null) {
            RecordLock.NextFile.PrevFile = RecordLock.PrevFile;
        }
    }
}

