/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.lh;

import com.tangosol.io.lh.JLHSession;
import com.tangosol.io.lh.LHMaximumUsersException;
import com.tangosol.io.lh.LHServer;
import com.tangosol.io.lh.LHSession;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Properties;

public class JLHServer
implements LHServer {
    private static final String JLH_CLASS_NAME = "jLHServer";
    private static final int COM_START = 0;
    private static final int COM_STATUS = 1;
    private static final int COM_STOP = 2;
    private static final int COM_ABORT = 3;
    String m_HostName;
    static String m_ServerSerialNumber;
    private static boolean m_LogFileInitialized;
    private static String m_LogFileName;
    private static PrintWriter m_LogFile;
    public boolean m_DebugFlag = false;
    Object m_syncSessionList = new Object();
    JLHSession m_SessionListHead;
    JLHSession m_SessionListTail;

    private static String GetLocalHost() {
        try {
            InetAddress inet_addr = InetAddress.getLocalHost();
            return inet_addr.getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private static void usage() {
        System.out.println("\nUsage: jLHServer [options]");
        System.out.println("\nOptions:");
        System.out.println("\n    -start \t\tstart server");
        System.out.println("    -debug \t\trun server in debug mode");
        System.out.println("    -log <file name> \tdivert all server output to a log file");
    }

    public JLHServer(String[] argv) {
        int ToDo = 0;
        boolean ShutdownInSeconds = false;
        boolean forceShutdown = false;
        int port = 888;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equalsIgnoreCase("-port")) {
                port = Integer.parseInt(argv[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-debug")) {
                this.m_DebugFlag = true;
                continue;
            }
            if (arg.equals("-abort")) {
                ToDo = 3;
                ShutdownInSeconds = false;
                continue;
            }
            if (arg.equalsIgnoreCase("-start")) {
                this.m_DebugFlag = false;
                continue;
            }
            if (arg.equalsIgnoreCase("-log")) {
                if (i + 1 < argv.length) {
                    m_LogFileName = argv[++i];
                    m_LogFileInitialized = false;
                    continue;
                }
                System.out.println("Option -log requires a file name argument.");
                JLHServer.usage();
                return;
            }
            JLHServer.usage();
            return;
        }
    }

    public JLHServer() {
        this.m_HostName = JLHServer.GetLocalHost();
        m_ServerSerialNumber = "UNLIMITED????";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LogMessage(String CalledId, String Msg) {
        if (!m_LogFileInitialized) {
            try {
                FileOutputStream logf = new FileOutputStream(m_LogFileName, true);
                m_LogFile = new PrintWriter(logf, true);
            }
            catch (Exception e) {
                System.out.println("WARNING: Unable to open log file '" + m_LogFileName + "'.  Using standard error output.");
            }
            finally {
                m_LogFileInitialized = true;
            }
        }
        if (CalledId != null) {
            if (Msg != null) {
                if (m_LogFile == null) {
                    System.out.println(CalledId + ": " + Msg);
                } else {
                    m_LogFile.println(CalledId + ": " + Msg);
                }
            } else if (m_LogFile == null) {
                System.out.println(CalledId);
            } else {
                m_LogFile.println(CalledId);
            }
        } else if (Msg != null) {
            if (m_LogFile == null) {
                System.out.println(Msg);
            } else {
                m_LogFile.println(Msg);
            }
        }
    }

    @Override
    public synchronized LHSession NewSession(Properties propertiesOptions) throws LHMaximumUsersException {
        return new JLHSession(this, propertiesOptions);
    }

    @Override
    public synchronized void Shutdown(int delay, boolean force) {
        if (!force && this.GetActiveSessionsCount() > 0) {
            System.out.println("There are active sessions, can't shutdown...");
            return;
        }
        if (delay > 1) {
            JLHServer.LogMessage(null, "\njLHServer is shuting down in " + delay + " seconds.");
        } else {
            JLHServer.LogMessage(null, "\njLHServer is shuting down at " + new Date());
        }
        System.exit(0);
    }

    @Override
    public int GetActiveSessionsCount() {
        int Count2 = 0;
        JLHSession Session2 = this.m_SessionListHead;
        while (Session2 != null) {
            if (Session2.m_bActive) {
                ++Count2;
            }
            Session2 = Session2.m_SessionListNext;
        }
        return Count2;
    }

    protected synchronized void finalize() {
        try {
            while (this.m_SessionListHead != null) {
                this.m_SessionListHead.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (m_LogFile != null) {
            JLHServer.LogMessage(null, "jLHServer terminated at " + new Date());
            m_LogFile.close();
            m_LogFile = null;
        }
    }

    static {
        m_LogFileInitialized = true;
        m_LogFileName = null;
        m_LogFile = null;
    }
}

