/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.lh;

import com.tangosol.io.AbstractBinaryStore;
import com.tangosol.io.lh.JLHServer;
import com.tangosol.io.lh.LHException;
import com.tangosol.io.lh.LHFile;
import com.tangosol.io.lh.LHFileNotFoundException;
import com.tangosol.io.lh.LHRecordNotFoundException;
import com.tangosol.io.lh.LHSelect;
import com.tangosol.io.lh.LHSession;
import com.tangosol.util.Binary;
import com.tangosol.util.WrapperException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;

public class LHBinaryStore
extends AbstractBinaryStore {
    private LHFile m_lhfile;
    protected boolean m_fDeleteOnClose;
    private static LHSession s_session;
    private static volatile int s_cFiles;

    public LHBinaryStore() {
        this(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LHBinaryStore(File dir, String sName) {
        if (dir != null && !dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + dir);
        }
        try {
            Class<LHBinaryStore> clazz = LHBinaryStore.class;
            synchronized (LHBinaryStore.class) {
                LHSession session = s_session;
                if (session == null) {
                    s_session = session = new JLHServer().NewSession(null);
                }
                ++s_cFiles;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.createLHFile(dir, sName);
            }
        }
        catch (IOException e) {
            this.close();
            throw new WrapperException(e);
        }
    }

    protected synchronized LHFile getLHFile() {
        LHFile lhfile = this.m_lhfile;
        if (lhfile == null) {
            throw new IllegalStateException("LHBinaryStore has been closed");
        }
        return lhfile;
    }

    @Override
    public Binary load(Binary binKey) {
        try {
            byte[] ab = this.getLHFile().readRecord(binKey.toByteArray());
            return ab == null ? null : new Binary(ab);
        }
        catch (LHException e) {
            throw new WrapperException(e);
        }
    }

    @Override
    public void store(Binary binKey, Binary binValue) {
        try {
            this.getLHFile().writeRecord(binKey.toByteArray(), binValue.toByteArray());
        }
        catch (LHException e) {
            throw new WrapperException(e);
        }
    }

    @Override
    public void erase(Binary binKey) {
        try {
            this.getLHFile().deleteRecord(binKey.toByteArray());
        }
        catch (LHRecordNotFoundException e) {
        }
        catch (LHException e) {
            throw new WrapperException(e);
        }
    }

    @Override
    public synchronized void eraseAll() {
        try {
            File file = new File(this.getLHFile().getFileName());
            boolean fTemp = this.m_fDeleteOnClose;
            try {
                ++s_cFiles;
                this.delete();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.createLHFile(file.getParentFile(), fTemp ? null : file.getName());
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    @Override
    public Iterator keys() {
        try {
            final LHSelect cursor = this.getLHFile().select();
            return new Iterator(){
                private Binary m_binNext = this.readNext();

                @Override
                public boolean hasNext() {
                    return this.m_binNext != null;
                }

                public Object next() {
                    Binary binKey = this.m_binNext;
                    if (binKey == null) {
                        throw new NoSuchElementException();
                    }
                    this.m_binNext = this.readNext();
                    return binKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private Binary readNext() {
                    byte[] abKey = null;
                    try {
                        abKey = cursor.readNext();
                    }
                    catch (LHException lHException) {
                        // empty catch block
                    }
                    if (abKey == null) {
                        this.invalidate();
                        return null;
                    }
                    return new Binary(abKey);
                }

                private void invalidate() {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                protected void finalize() {
                    this.invalidate();
                }
            };
        }
        catch (LHException e) {
            throw new WrapperException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLHFile(File dir, String sName) throws IOException {
        LHSession session = s_session;
        File fileTemp = null;
        Properties propCreateOptions = null;
        Properties propSelectOptions = null;
        try {
            LHFile lhfile;
            File file;
            if (dir == null || sName == null) {
                file = fileTemp = File.createTempFile("lh0", "~", dir);
                propCreateOptions = new Properties();
                propCreateOptions.setProperty("Temporary", "true");
                this.m_fDeleteOnClose = true;
            } else {
                file = new File(dir, sName);
                this.m_fDeleteOnClose = false;
            }
            try {
                do {
                    lhfile = session.openFile(file.getPath(), propSelectOptions);
                    if (fileTemp == null) continue;
                    try {
                        lhfile.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    fileTemp.delete();
                    file = fileTemp = File.createTempFile("lh0", "~", dir);
                } while (fileTemp != null);
            }
            catch (LHFileNotFoundException e) {
                session.createFile(file.getPath(), propCreateOptions);
                lhfile = session.openFile(file.getPath(), propSelectOptions);
            }
            this.m_lhfile = lhfile;
        }
        finally {
            if (fileTemp != null) {
                fileTemp.delete();
            }
        }
    }

    public synchronized void delete() {
        if (s_session == null || this.m_lhfile == null) {
            throw new IllegalStateException("Already closed");
        }
        this.m_fDeleteOnClose = true;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void close() {
        LHSession session = s_session;
        LHFile lhfile = this.m_lhfile;
        if (session == null || lhfile == null) return;
        try {
            lhfile.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.m_fDeleteOnClose) {
            try {
                session.deleteFile(lhfile.getFileName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_lhfile = null;
        Class<LHBinaryStore> clazz = LHBinaryStore.class;
        synchronized (LHBinaryStore.class) {
            if (--s_cFiles != 0) return;
            LHBinaryStore.closeSession();
            // ** MonitorExit[var3_5] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void closeSession() {
        try {
            s_session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_session = null;
        s_cFiles = 0;
    }

    public String toString() {
        LHFile lhfile = this.m_lhfile;
        return "LHBinaryStore: " + (lhfile == null ? "[closed]" : lhfile.getFileName());
    }

    protected void finalize() {
        this.close();
    }
}

