/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.Evolvable;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.util.Base;
import com.tangosol.util.LongArray;
import com.tangosol.util.SimpleLongArray;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SimplePofContext
implements PofContext {
    protected Map m_mapTypeId;
    protected LongArray m_laClass;
    protected LongArray m_laSerializer;
    protected boolean m_fReferenceEnabled;

    @Override
    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        PofBufferWriter writer = new PofBufferWriter(out, (PofContext)this);
        if (this.isReferenceEnabled() && !(o instanceof Evolvable)) {
            writer.enableReference();
        }
        try {
            writer.writeObject(-1, o);
        }
        catch (RuntimeException e) {
            IOException ioex = new IOException(e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        PofBufferReader reader = new PofBufferReader(in, this);
        try {
            return reader.readObject(-1);
        }
        catch (RuntimeException e) {
            IOException ioex = new IOException(e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public PofSerializer getPofSerializer(int nTypeId) {
        PofSerializer serializer;
        this.validateTypeId(nTypeId);
        LongArray laSerializer = this.m_laSerializer;
        PofSerializer pofSerializer = serializer = laSerializer == null ? null : (PofSerializer)laSerializer.get(nTypeId);
        if (serializer == null) {
            throw new IllegalArgumentException("unknown user type: " + nTypeId);
        }
        return serializer;
    }

    @Override
    public int getUserTypeIdentifier(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        return this.getUserTypeIdentifier(o.getClass());
    }

    @Override
    public int getUserTypeIdentifier(Class clz) {
        Integer ITypeId;
        if (clz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        Map mapTypeId = this.m_mapTypeId;
        Integer n = ITypeId = mapTypeId == null ? null : (Integer)mapTypeId.get(clz);
        if (ITypeId == null) {
            throw new IllegalArgumentException("unknown user type: " + clz);
        }
        return ITypeId;
    }

    @Override
    public int getUserTypeIdentifier(String sClass) {
        if (sClass == null) {
            throw new IllegalArgumentException("Class name cannot be null");
        }
        try {
            return this.getUserTypeIdentifier(Class.forName(sClass));
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public String getClassName(int nTypeId) {
        return this.getClass(nTypeId).getName();
    }

    @Override
    public Class getClass(int nTypeId) {
        Class clz;
        this.validateTypeId(nTypeId);
        LongArray laClass = this.m_laClass;
        Class clazz = clz = laClass == null ? null : (Class)laClass.get(nTypeId);
        if (clz == null) {
            throw new IllegalArgumentException("unknown user type: " + nTypeId);
        }
        return clz;
    }

    @Override
    public boolean isUserType(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        return this.isUserType(o.getClass());
    }

    @Override
    public boolean isUserType(Class clz) {
        if (clz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        Map mapTypeId = this.m_mapTypeId;
        return mapTypeId != null && mapTypeId.get(clz) != null;
    }

    @Override
    public boolean isUserType(String sClass) {
        if (sClass == null) {
            throw new IllegalArgumentException("Class name cannot be null");
        }
        try {
            return this.isUserType(Class.forName(sClass));
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public void registerUserType(int nTypeId, Class clz, PofSerializer serializer) {
        this.validateTypeId(nTypeId);
        if (clz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("PofSerializer cannot be null");
        }
        HashMap<Class, Integer> mapTypeId = this.m_mapTypeId;
        LongArray laClass = this.m_laClass;
        LongArray laSerializer = this.m_laSerializer;
        if (mapTypeId == null) {
            this.m_mapTypeId = mapTypeId = new HashMap<Class, Integer>();
        }
        mapTypeId.put(clz, Base.makeInteger(nTypeId));
        if (laClass == null) {
            this.m_laClass = laClass = new SimpleLongArray();
        }
        laClass.set(nTypeId, clz);
        if (laSerializer == null) {
            this.m_laSerializer = laSerializer = new SimpleLongArray();
        }
        laSerializer.set(nTypeId, serializer);
    }

    public void unregisterUserType(int nTypeId) {
        Class clz = this.getClass(nTypeId);
        Map mapTypeId = this.m_mapTypeId;
        LongArray laClass = this.m_laClass;
        LongArray laSerializer = this.m_laSerializer;
        if (mapTypeId != null) {
            mapTypeId.remove(clz);
            if (mapTypeId.isEmpty()) {
                this.m_mapTypeId = null;
                mapTypeId = null;
            }
        }
        if (laClass != null) {
            laClass.remove(nTypeId);
            if (laClass.isEmpty()) {
                this.m_laClass = null;
                laClass = null;
            }
        }
        if (laSerializer != null) {
            laSerializer.remove(nTypeId);
            if (laSerializer.isEmpty()) {
                this.m_laSerializer = null;
                laSerializer = null;
            }
        }
    }

    protected void validateTypeId(int nTypeId) {
        if (nTypeId < 0) {
            throw new IllegalArgumentException("negative user type identifier: " + nTypeId);
        }
    }

    public boolean isReferenceEnabled() {
        return this.m_fReferenceEnabled;
    }

    public void setReferenceEnabled(boolean fEnabled) {
        this.m_fReferenceEnabled = fEnabled;
    }
}

