/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect;

import com.tangosol.io.ReadBuffer;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.reflect.AbstractPofValue;
import com.tangosol.io.pof.reflect.PofValue;
import com.tangosol.io.pof.reflect.PofValueParser;
import com.tangosol.util.SparseArray;
import java.io.IOException;
import java.util.Iterator;

public abstract class ComplexPofValue
extends AbstractPofValue {
    private SparseArray m_aChildren = new SparseArray();
    private int m_ofChildren;
    private int m_nElementType = -65;

    public ComplexPofValue(PofValue valueParent, ReadBuffer bufValue, PofContext ctx, int of, int nType, int ofChildren) {
        super(valueParent, bufValue, ctx, of, nType);
        this.m_ofChildren = ofChildren;
    }

    @Override
    public PofValue getChild(int nIndex) {
        PofValue valueChild = (PofValue)this.m_aChildren.get(nIndex);
        if (valueChild == null) {
            valueChild = this.findChild(nIndex);
            this.m_aChildren.set(nIndex, valueChild);
        }
        return valueChild;
    }

    public Iterator getChildrenIterator() {
        return this.m_aChildren.iterator();
    }

    protected int getUniformElementType() {
        return this.m_nElementType;
    }

    protected void setUniformElementType(int nElementType) {
        this.m_nElementType = nElementType;
    }

    protected PofValue findChild(int nIndex) {
        int ofStart = this.m_ofChildren;
        int iStart = this.getLastChildIndex(nIndex);
        if (iStart >= 0) {
            AbstractPofValue lastChild = (AbstractPofValue)this.m_aChildren.get(iStart);
            ofStart = lastChild.getOffset() - this.getOffset() + lastChild.getSize();
            ++iStart;
        } else {
            iStart = 0;
        }
        return this.findChildInternal(nIndex, ofStart, iStart);
    }

    protected int getLastChildIndex(int nIndex) {
        SparseArray aChildren = this.m_aChildren;
        int nLast = (int)aChildren.getLastIndex();
        if (nIndex < nLast) {
            for (nLast = nIndex; nLast >= 0 && !aChildren.exists(nLast); --nLast) {
            }
        }
        return nLast;
    }

    protected boolean isUniformCollection() {
        return this.m_nElementType != -65;
    }

    protected void skipChild(ReadBuffer.BufferInput in) throws IOException {
        if (this.isUniformCollection()) {
            PofHelper.skipUniformValue(in, this.m_nElementType);
        } else {
            PofHelper.skipValue(in);
        }
    }

    protected PofValue extractChild(ReadBuffer buf, int of, int cb) {
        return this.isUniformCollection() ? PofValueParser.parseUniformValue(this, this.m_nElementType, buf.getReadBuffer(of, cb), this.getPofContext(), this.getOffset() + of) : PofValueParser.parseValue(this, buf.getReadBuffer(of, cb), this.getPofContext(), this.getOffset() + of);
    }

    protected abstract PofValue findChildInternal(int var1, int var2, int var3);
}

