/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect;

import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.RawDayTimeInterval;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.io.pof.RawTimeInterval;
import com.tangosol.io.pof.RawYearMonthInterval;
import com.tangosol.util.Binary;
import com.tangosol.util.SparseArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;

public class PofReflectionHelper {
    public static Class getClass(int nType, PofContext ctx) {
        if (nType >= 0) {
            return ctx.getClass(nType);
        }
        switch (nType) {
            case -1: {
                return Short.class;
            }
            case -64: 
            case -63: 
            case -62: 
            case -61: 
            case -60: 
            case -59: 
            case -58: 
            case -57: 
            case -56: 
            case -55: 
            case -54: 
            case -53: 
            case -52: 
            case -51: 
            case -50: 
            case -49: 
            case -48: 
            case -47: 
            case -46: 
            case -45: 
            case -44: 
            case -43: 
            case -42: 
            case -41: 
            case -2: {
                return Integer.class;
            }
            case -3: {
                return Long.class;
            }
            case -4: {
                return BigInteger.class;
            }
            case -5: {
                return Float.class;
            }
            case -6: {
                return Double.class;
            }
            case -7: {
                return RawQuad.class;
            }
            case -38: {
                return Double.class;
            }
            case -39: {
                return Double.class;
            }
            case -40: {
                return Double.class;
            }
            case -8: {
                return BigDecimal.class;
            }
            case -9: {
                return BigDecimal.class;
            }
            case -10: {
                return BigDecimal.class;
            }
            case -34: 
            case -33: 
            case -11: {
                return Boolean.class;
            }
            case -12: {
                return Byte.class;
            }
            case -13: {
                return Binary.class;
            }
            case -14: {
                return Character.class;
            }
            case -35: 
            case -15: {
                return String.class;
            }
            case -16: {
                return Date.class;
            }
            case -18: {
                return Time.class;
            }
            case -20: {
                return Timestamp.class;
            }
            case -17: {
                return RawYearMonthInterval.class;
            }
            case -19: {
                return RawTimeInterval.class;
            }
            case -21: {
                return RawDayTimeInterval.class;
            }
            case -36: 
            case -23: 
            case -22: {
                return Collection.class;
            }
            case -30: 
            case -29: 
            case -28: {
                return Map.class;
            }
            case -26: {
                return SparseArray.class;
            }
            case -24: {
                return Object[].class;
            }
            case -37: 
            case -27: 
            case -25: {
                return null;
            }
            case -32: 
            case -31: {
                throw new IllegalArgumentException(nType + " has no " + "mapping to a class");
            }
        }
        throw new IllegalArgumentException(nType + " is an " + "invalid type");
    }

    public static Object ensureType(Object o, int nType, PofContext ctx) {
        Class clz = PofReflectionHelper.getClass(nType, ctx);
        if (clz == null) {
            throw new IllegalArgumentException("Unknown or ambiguous type: " + nType);
        }
        if (!clz.isAssignableFrom(o.getClass())) {
            throw new ClassCastException(o.getClass().getName() + " is not assignable to " + clz.getName());
        }
        return o;
    }
}

