/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect;

import com.tangosol.io.ReadBuffer;
import com.tangosol.io.pof.PofConstants;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.reflect.AbstractPofValue;
import com.tangosol.io.pof.reflect.PofArray;
import com.tangosol.io.pof.reflect.PofCollection;
import com.tangosol.io.pof.reflect.PofSparseArray;
import com.tangosol.io.pof.reflect.PofUniformArray;
import com.tangosol.io.pof.reflect.PofUniformCollection;
import com.tangosol.io.pof.reflect.PofUniformSparseArray;
import com.tangosol.io.pof.reflect.PofUserType;
import com.tangosol.io.pof.reflect.PofValue;
import com.tangosol.io.pof.reflect.SimplePofValue;
import com.tangosol.util.ExternalizableHelper;
import java.io.EOFException;
import java.io.IOException;

public abstract class PofValueParser
extends ExternalizableHelper
implements PofConstants {
    public static PofValue parse(ReadBuffer buf, PofContext ctx) {
        int cb;
        int of;
        ReadBuffer.BufferInput in = buf.getBufferInput();
        ReadBuffer bufDeco = null;
        long nDecoMask = 0L;
        try {
            int nType = in.readUnsignedByte();
            switch (nType) {
                case 13: {
                    PofValueParser.readInt(in);
                    in.readUnsignedByte();
                    of = in.getOffset();
                    cb = buf.length() - of;
                    break;
                }
                case 18: 
                case 19: {
                    long l = nDecoMask = nType == 18 ? (long)in.readByte() : in.readPackedLong();
                    if ((nDecoMask & 1L) == 0L) {
                        throw new EOFException("Decorated binary is missing a value");
                    }
                    cb = PofValueParser.readInt(in);
                    of = in.getOffset();
                    int ofDeco = of + cb;
                    bufDeco = buf.getReadBuffer(ofDeco, buf.length() - ofDeco);
                    buf = buf.getReadBuffer(of, cb);
                }
                case 21: {
                    of = 1;
                    cb = buf.length() - 1;
                    break;
                }
                default: {
                    of = 0;
                    cb = buf.length();
                    break;
                }
            }
        }
        catch (IOException e) {
            throw PofValueParser.ensureRuntimeException(e);
        }
        AbstractPofValue valueRoot = (AbstractPofValue)PofValueParser.parseValue(null, buf.getReadBuffer(of, cb), ctx, of);
        valueRoot.setOriginalBuffer(buf);
        valueRoot.setDecorations(nDecoMask, bufDeco);
        return valueRoot;
    }

    protected static PofValue parseValue(PofValue valueParent, ReadBuffer bufValue, PofContext ctx, int of) {
        ReadBuffer.BufferInput in = bufValue.getBufferInput();
        try {
            int nType = in.readPackedInt();
            return PofValueParser.instantiatePofValue(valueParent, nType, bufValue, ctx, of, in);
        }
        catch (IOException e) {
            throw PofValueParser.ensureRuntimeException(e);
        }
    }

    protected static PofValue parseUniformValue(PofValue valueParent, int nType, ReadBuffer bufValue, PofContext ctx, int of) {
        ReadBuffer.BufferInput in = bufValue.getBufferInput();
        AbstractPofValue value = (AbstractPofValue)PofValueParser.instantiatePofValue(valueParent, nType, bufValue, ctx, of, in);
        value.setUniformEncoded();
        return value;
    }

    protected static PofValue instantiatePofValue(PofValue valueParent, int nType, ReadBuffer bufValue, PofContext ctx, int of, ReadBuffer.BufferInput in) {
        try {
            switch (nType) {
                case -24: {
                    int cSize = in.readPackedInt();
                    int ofChildren = in.getOffset();
                    return new PofArray(valueParent, bufValue, ctx, of, nType, ofChildren, cSize);
                }
                case -25: {
                    int nElementType = in.readPackedInt();
                    int cSize = in.readPackedInt();
                    int ofChildren = in.getOffset();
                    return new PofUniformArray(valueParent, bufValue, ctx, of, nType, ofChildren, cSize, nElementType);
                }
                case -22: {
                    int cSize = in.readPackedInt();
                    int ofChildren = in.getOffset();
                    return new PofCollection(valueParent, bufValue, ctx, of, nType, ofChildren, cSize);
                }
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cSize = in.readPackedInt();
                    int ofChildren = in.getOffset();
                    return new PofUniformCollection(valueParent, bufValue, ctx, of, nType, ofChildren, cSize, nElementType);
                }
                case -26: {
                    in.readPackedInt();
                    int ofChildren = in.getOffset();
                    return new PofSparseArray(valueParent, bufValue, ctx, of, nType, ofChildren);
                }
                case -27: {
                    int nElementType = in.readPackedInt();
                    in.readPackedInt();
                    int ofChildren = in.getOffset();
                    return new PofUniformSparseArray(valueParent, bufValue, ctx, of, nType, ofChildren, nElementType);
                }
            }
            if (nType >= 0) {
                int nVersionId = in.readPackedInt();
                int ofChildren = in.getOffset();
                return new PofUserType(valueParent, bufValue, ctx, of, nType, ofChildren, nVersionId);
            }
            return new SimplePofValue(valueParent, bufValue, ctx, of, nType);
        }
        catch (IOException e) {
            throw PofValueParser.ensureRuntimeException(e);
        }
    }
}

