/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect.internal;

import com.tangosol.io.pof.reflect.Codec;
import com.tangosol.io.pof.reflect.internal.InvocationStrategy;
import com.tangosol.io.pof.reflect.internal.TypeMetadata;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.HashHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ClassMetadata<T>
implements TypeMetadata<T> {
    private Class<T> m_clz;
    private TypeMetadata.TypeKey m_key;
    private Set<TypeMetadata.AttributeMetadata<T>> m_setAttr = new TreeSet<TypeMetadata.AttributeMetadata<T>>();
    private Map<String, TypeMetadata.AttributeMetadata> m_mapAttrByName = new HashMap<String, TypeMetadata.AttributeMetadata>();

    @Override
    public TypeMetadata.TypeKey getKey() {
        return this.m_key;
    }

    @Override
    public T newInstance() {
        try {
            return this.m_clz == null ? null : (T)this.m_clz.newInstance();
        }
        catch (InstantiationException e) {
            throw Base.ensureRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public Iterator<TypeMetadata.AttributeMetadata<T>> getAttributes() {
        return this.m_setAttr.iterator();
    }

    @Override
    public TypeMetadata.AttributeMetadata<T> getAttribute(String sName) {
        return this.m_mapAttrByName.get(sName);
    }

    void setClass(Class<T> clz) {
        this.m_clz = clz;
    }

    void setKey(TypeMetadata.TypeKey key) {
        this.m_key = key;
    }

    void setAttributes(Collection<TypeMetadata.AttributeMetadata<T>> colAttr) {
        Set<TypeMetadata.AttributeMetadata<T>> setAttrs = this.m_setAttr;
        Map<String, TypeMetadata.AttributeMetadata> mapAttrByName = this.m_mapAttrByName;
        setAttrs.clear();
        setAttrs.addAll(colAttr);
        mapAttrByName.clear();
        for (TypeMetadata.AttributeMetadata<T> attribute : colAttr) {
            mapAttrByName.put(attribute.getName(), attribute);
        }
    }

    boolean addAttribute(TypeMetadata.AttributeMetadata attribute) {
        boolean fAdded = this.m_setAttr.add(attribute);
        if (fAdded) {
            this.m_mapAttrByName.put(attribute.getName(), attribute);
        }
        return fAdded;
    }

    public int hashCode() {
        TypeMetadata.TypeKey key = this.m_key;
        int hash = HashHelper.hash(key.getTypeId(), 31);
        hash = HashHelper.hash(key.getVersionId(), hash);
        hash = HashHelper.hash(this.m_setAttr, hash);
        return hash;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof TypeMetadata)) {
            return false;
        }
        TypeMetadata that = (TypeMetadata)oThat;
        if (!Base.equals(this.getKey(), that.getKey())) {
            return false;
        }
        Iterator<TypeMetadata.AttributeMetadata<T>> iterThis = this.m_setAttr.iterator();
        Iterator iterThat = that.getAttributes();
        while (iterThis.hasNext() || iterThat.hasNext()) {
            TypeMetadata.AttributeMetadata attrThat;
            TypeMetadata.AttributeMetadata<T> attrThis = iterThis.hasNext() ? iterThis.next() : null;
            if (Base.equals(attrThis, attrThat = iterThat.hasNext() ? iterThat.next() : null)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("%s (key=%s, attributes=%s)", ClassHelper.getSimpleName(this.getClass()), this.m_key, this.m_setAttr);
    }

    public class ClassAttribute
    implements TypeMetadata.AttributeMetadata<T>,
    Comparable<ClassAttribute> {
        private String m_sName;
        private String m_sFieldName;
        private int m_nVersionId;
        private int m_nIndex;
        private Codec m_codec;
        private InvocationStrategy<T, Object> m_invocationStrategy;

        @Override
        public String getName() {
            return this.m_sName;
        }

        @Override
        public int getVersionId() {
            return this.m_nVersionId;
        }

        @Override
        public int getIndex() {
            return this.m_nIndex;
        }

        @Override
        public Codec getCodec() {
            return this.m_codec;
        }

        @Override
        public Object get(T pofType) {
            this.assertState();
            return this.m_invocationStrategy.get(pofType);
        }

        @Override
        public void set(T pofType, Object value) {
            this.assertState();
            this.m_invocationStrategy.set(pofType, value);
        }

        @Override
        public int compareTo(ClassAttribute o) {
            int n = this.m_nVersionId - o.getVersionId();
            if (n == 0 && (n = this.m_nIndex - o.getIndex()) == 0) {
                String sThis = this.m_sName == null ? "" : this.m_sName;
                String sThat = o.getName() == null ? "" : o.getName();
                n = sThis.compareTo(sThat);
            }
            return n;
        }

        public int hashCode() {
            int hash = HashHelper.hash(this.m_nVersionId, 31);
            hash = HashHelper.hash(this.m_nIndex, hash);
            hash = HashHelper.hash(this.m_sName, hash);
            return hash;
        }

        public boolean equals(Object oThat) {
            if (this == oThat) {
                return true;
            }
            if (!(oThat instanceof TypeMetadata.AttributeMetadata)) {
                return false;
            }
            TypeMetadata.AttributeMetadata that = (TypeMetadata.AttributeMetadata)oThat;
            return this.m_nVersionId == that.getVersionId() && this.m_nIndex == that.getIndex() && Base.equals(this.m_sName, that.getName());
        }

        public String toString() {
            return String.format("%s (name=%s, version=%d, index=%d)", ClassHelper.getSimpleName(this.getClass()), this.m_sName, this.m_nVersionId, this.m_nIndex);
        }

        void setName(String sName) {
            this.m_sName = sName;
        }

        void setVersionId(int nVersionId) {
            this.m_nVersionId = nVersionId;
        }

        void setIndex(int nIndex) {
            this.m_nIndex = nIndex;
        }

        void setCodec(Codec codec) {
            this.m_codec = codec;
        }

        void setInvocationStrategy(InvocationStrategy<T, Object> invocationStrategy) {
            this.m_invocationStrategy = invocationStrategy;
        }

        protected void assertState() {
            if (this.m_invocationStrategy == null) {
                throw new IllegalStateException("ClassMetadata attribute requires an invocation strategy");
            }
        }
    }

    class ClassKey
    implements TypeMetadata.TypeKey {
        private int m_nTypeId;
        private int m_nVersionId;
        private int m_nHash;

        ClassKey() {
        }

        @Override
        public int getTypeId() {
            return this.m_nTypeId;
        }

        @Override
        public int getVersionId() {
            return this.m_nVersionId;
        }

        @Override
        public int getHash() {
            return this.m_nHash;
        }

        void setTypeId(int nTypeId) {
            this.m_nTypeId = nTypeId;
        }

        void setVersion(int nVersionId) {
            this.m_nVersionId = nVersionId;
        }

        void setHash(int nHash) {
            this.m_nHash = nHash;
        }

        public int hashCode() {
            int hash = HashHelper.hash(this.m_nTypeId, 31);
            hash = HashHelper.hash(this.m_nVersionId, hash);
            hash = HashHelper.hash(this.m_nHash, hash);
            return hash;
        }

        public boolean equals(Object oThat) {
            if (this == oThat) {
                return true;
            }
            if (!(oThat instanceof TypeMetadata.TypeKey)) {
                return false;
            }
            TypeMetadata.TypeKey that = (TypeMetadata.TypeKey)oThat;
            return this.m_nVersionId == that.getVersionId() && this.m_nTypeId == that.getTypeId() && this.m_nHash == that.getHash();
        }

        public String toString() {
            return String.format("%s (typeId=%d, versionId=%d, hash=%d)", ClassHelper.getSimpleName(this.getClass()), this.m_nTypeId, this.m_nVersionId, this.m_nHash);
        }
    }
}

