/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.Action;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.ProxyService;
import com.tangosol.net.Service;
import com.tangosol.util.Base;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SynchronousListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ConfigurableQuorumPolicy
extends Base
implements ActionPolicy {
    protected ConfigurableQuorumPolicy() {
    }

    public abstract String getStatusDescription();

    public static PartitionedCacheQuorumPolicy instantiatePartitionedCachePolicy(MembershipQuorumPolicy.QuorumRule[] aRule) {
        return new PartitionedCacheQuorumPolicy(aRule);
    }

    public static ProxyQuorumPolicy instantiateProxyPolicy(MembershipQuorumPolicy.QuorumRule[] aRule) {
        return new ProxyQuorumPolicy(aRule);
    }

    public static ClusterQuorumPolicy instantiateClusterPolicy(Map<String, Integer> mapQuorum) {
        return new ClusterQuorumPolicy(mapQuorum);
    }

    public static class ClusterQuorumPolicy
    extends ConfigurableQuorumPolicy
    implements ActionPolicy {
        public static final String ROLE_ALL = "*role-any*";
        protected Service m_service;
        protected Map m_mapQuorumByRole;

        protected ClusterQuorumPolicy(Map<String, Integer> mapQuorum) {
            this.setClusterQuorumMap(mapQuorum);
        }

        protected Map getClusterQuorumMap() {
            return this.m_mapQuorumByRole;
        }

        protected void setClusterQuorumMap(Map mapQuorumByRole) {
            this.m_mapQuorumByRole = mapQuorumByRole;
        }

        public Service getService() {
            return this.m_service;
        }

        public void setService(Service service) {
            this.m_service = service;
        }

        @Override
        public String getStatusDescription() {
            Map mapQuorum = this.getClusterQuorumMap();
            StringBuilder sb = new StringBuilder();
            sb.append("thresholds: {");
            Iterator iter = mapQuorum.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String sRole = (String)entry.getKey();
                Integer IQuorum = (Integer)entry.getValue();
                sb.append(ClusterQuorumPolicy.equals(sRole, ROLE_ALL) ? "*" : "\"" + sRole + "\"");
                sb.append("=").append(IQuorum);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }

        protected Set ensureSet(Set set) {
            return set == null ? NullImplementation.getSet() : set;
        }

        protected Map groupMembersByRole(Set setMembers) {
            HashMap<String, Set> mapByRole = new HashMap<String, Set>();
            mapByRole.put(ROLE_ALL, setMembers);
            for (Member member : setMembers) {
                String sRole = member.getRoleName();
                HashSet<Member> setRoleMember = (HashSet<Member>)mapByRole.get(sRole);
                if (setRoleMember == null) {
                    setRoleMember = new HashSet<Member>();
                    mapByRole.put(sRole, setRoleMember);
                }
                setRoleMember.add(member);
            }
            return mapByRole;
        }

        protected boolean checkRoleQuorum(String sRole, Set setMembers, Set setTimedOut, Set setHealthy, Set setAnnouncing) {
            int cQuorum;
            Integer IQuorum = (Integer)this.getClusterQuorumMap().get(sRole);
            int n = cQuorum = IQuorum == null ? 0 : IQuorum;
            if (setTimedOut.contains(this.getService().getCluster().getLocalMember())) {
                return cQuorum == 0;
            }
            return setHealthy.size() + setAnnouncing.size() >= cQuorum;
        }

        @Override
        public void init(Service service) {
            this.setService(service);
        }

        @Override
        public boolean isAllowed(Service service, Action action) {
            if (action instanceof Cluster.MemberTimeoutAction) {
                Cluster.MemberTimeoutAction timeoutAction = (Cluster.MemberTimeoutAction)action;
                Set setMembers = service.getInfo().getServiceMembers();
                Set setTimedOut = timeoutAction.getTimedOutMemberSet();
                Set setHealthy = timeoutAction.getResponsiveMemberSet();
                Set setAnnouncing = timeoutAction.getAnnouncingMemberSet();
                Map mapMembersByRole = this.groupMembersByRole(setMembers);
                Map mapTimedOutByRole = this.groupMembersByRole(setTimedOut);
                Map mapHealthyByRole = this.groupMembersByRole(setHealthy);
                Map mapAnnouncingByRole = this.groupMembersByRole(setAnnouncing);
                for (String sRole : this.getClusterQuorumMap().keySet()) {
                    if (this.checkRoleQuorum(sRole, this.ensureSet((Set)mapMembersByRole.get(sRole)), this.ensureSet((Set)mapTimedOutByRole.get(sRole)), this.ensureSet((Set)mapHealthyByRole.get(sRole)), this.ensureSet((Set)mapAnnouncingByRole.get(sRole)))) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class ProxyQuorumPolicy
    extends MembershipQuorumPolicy {
        public static final int MASK_CONNECT = 1;

        protected ProxyQuorumPolicy(MembershipQuorumPolicy.QuorumRule[] aRule) {
            this.configure(aRule);
        }

        @Override
        public String getStatusDescription() {
            int nMask = this.getCurrentRule().getRuleMask();
            StringBuilder sbStatus = new StringBuilder();
            String sSeparator = "";
            sbStatus.append("allowed-actions=");
            if ((nMask & 1) != 0) {
                sbStatus.append(sSeparator).append("connect");
                sSeparator = ",";
            }
            return sbStatus.toString();
        }

        @Override
        public boolean isAllowed(Service service, Action action) {
            MembershipQuorumPolicy.QuorumRule ruleCurrent = this.getCurrentRule();
            if (ruleCurrent == MembershipQuorumPolicy.QuorumRule.ALL_ALLOWED) {
                return true;
            }
            if (action == ProxyService.ProxyAction.CONNECT) {
                return ruleCurrent.contains(1);
            }
            return true;
        }
    }

    public static class PartitionedCacheQuorumPolicy
    extends MembershipQuorumPolicy {
        public static final int MASK_DISTRIBUTION = 1;
        public static final int MASK_RESTORE = 2;
        public static final int MASK_READ = 4;
        public static final int MASK_WRITE = 8;

        public PartitionedCacheQuorumPolicy(MembershipQuorumPolicy.QuorumRule[] aRule) {
            this.configure(aRule);
        }

        @Override
        public String getStatusDescription() {
            int nMask = this.getCurrentRule().getRuleMask();
            StringBuilder sbStatus = new StringBuilder();
            String sSeparator = "";
            sbStatus.append("allowed-actions=");
            if ((nMask & 1) != 0) {
                sbStatus.append(sSeparator).append("distribution");
                sSeparator = ",";
            }
            if ((nMask & 2) != 0) {
                sbStatus.append(sSeparator).append("restore");
                sSeparator = ",";
            }
            if ((nMask & 4) != 0) {
                sbStatus.append(sSeparator).append("cache-read");
                sSeparator = ",";
            }
            if ((nMask & 8) != 0) {
                sbStatus.append(sSeparator).append("cache-write");
                sSeparator = ",";
            }
            return sbStatus.toString();
        }

        @Override
        public int getPolicyPopulation() {
            Set setOwners = ((PartitionedService)this.getService()).getOwnershipEnabledMembers();
            setOwners.removeAll(this.getLeavingMembers());
            return setOwners.size();
        }

        @Override
        public boolean isAllowed(Service service, Action action) {
            MembershipQuorumPolicy.QuorumRule ruleCurrent = this.getCurrentRule();
            if (ruleCurrent == MembershipQuorumPolicy.QuorumRule.ALL_ALLOWED) {
                return true;
            }
            if (action == CacheService.CacheAction.READ) {
                return ruleCurrent.contains(4);
            }
            if (action == CacheService.CacheAction.WRITE) {
                return ruleCurrent.contains(8);
            }
            if (action == PartitionedService.PartitionedAction.DISTRIBUTE) {
                return ruleCurrent.contains(1);
            }
            if (action == PartitionedService.PartitionedAction.RESTORE) {
                return ruleCurrent.contains(2);
            }
            return true;
        }
    }

    public static class WrapperQuorumPolicy
    extends ConfigurableQuorumPolicy {
        protected ActionPolicy m_policy;

        public WrapperQuorumPolicy(ActionPolicy policy) {
            this.m_policy = policy;
        }

        public ActionPolicy getPolicy() {
            return this.m_policy;
        }

        @Override
        public String getStatusDescription() {
            return ((Object)this.getPolicy()).toString();
        }

        @Override
        public void init(Service service) {
            this.getPolicy().init(service);
        }

        @Override
        public boolean isAllowed(Service service, Action action) {
            return this.getPolicy().isAllowed(service, action);
        }

        @Override
        public String toString() {
            return ((Object)this.getPolicy()).toString();
        }
    }

    public static abstract class MembershipQuorumPolicy
    extends ConfigurableQuorumPolicy {
        protected Set m_setLeaving = new HashSet();
        protected Service m_service;
        protected QuorumRule m_ruleCurrent;
        protected QuorumRule[] m_aRules;

        protected MembershipQuorumPolicy() {
        }

        public Service getService() {
            return this.m_service;
        }

        protected void setService(Service service) {
            this.m_service = service;
        }

        protected QuorumRule getCurrentRule() {
            return this.m_ruleCurrent;
        }

        protected void setCurrentRule(QuorumRule ruleCurrent) {
            this.m_ruleCurrent = ruleCurrent;
        }

        protected void setQuorumRules(QuorumRule[] aRule) {
            this.m_aRules = aRule;
        }

        protected QuorumRule[] getQuorumRules() {
            return this.m_aRules;
        }

        protected Set getLeavingMembers() {
            return this.m_setLeaving;
        }

        protected int getPolicyPopulation() {
            Set setMembers = this.getService().getInfo().getServiceMembers();
            setMembers.removeAll(this.getLeavingMembers());
            return setMembers.size();
        }

        protected QuorumRule[] sortByThreshold(QuorumRule[] aRule) {
            int cRule = aRule.length;
            for (int i = cRule - 1; i > 1; --i) {
                for (int j = 0; j < i; ++j) {
                    QuorumRule ruleCurrent = aRule[j];
                    QuorumRule ruleNext = aRule[j + 1];
                    if (ruleCurrent.getThreshold() <= ruleNext.getThreshold()) continue;
                    aRule[j] = ruleNext;
                    aRule[j + 1] = ruleCurrent;
                }
            }
            return aRule;
        }

        protected void configure(QuorumRule[] aRule) {
            int cRule = aRule.length;
            if (cRule <= 0) {
                this.setQuorumRules(new QuorumRule[]{QuorumRule.ALL_ALLOWED});
                return;
            }
            aRule = this.sortByThreshold(aRule);
            QuorumRule[] aRuleNew = new QuorumRule[cRule + 2];
            int iRuleNew = 0;
            QuorumRule rulePrevious = QuorumRule.NONE_ALLOWED;
            aRuleNew[iRuleNew++] = rulePrevious;
            for (int i = 0; i < cRule; ++i) {
                QuorumRule ruleNext = aRule[i];
                aRuleNew[iRuleNew++] = rulePrevious = ruleNext.union(rulePrevious);
            }
            aRuleNew[iRuleNew] = QuorumRule.ALL_ALLOWED;
            this.setQuorumRules(aRuleNew);
        }

        protected void updateCurrentRule() {
            QuorumRule ruleNew = null;
            int nSize = this.getPolicyPopulation();
            for (QuorumRule ruleCurrent : this.getQuorumRules()) {
                if (nSize < ruleCurrent.getThreshold()) break;
                ruleNew = ruleCurrent;
            }
            if (ruleNew != this.getCurrentRule()) {
                this.setCurrentRule(ruleNew);
            }
        }

        @Override
        public void init(Service service) {
            this.setService(service);
            service.addMemberListener(this.instantiateMemberListener());
            this.updateCurrentRule();
        }

        @Override
        public String toString() {
            return "{" + this.getClass().getName() + " " + this.getStatusDescription() + "}";
        }

        protected MemberListener instantiateMemberListener() {
            return new QuorumListener();
        }

        public static class QuorumRule {
            private int m_nThreshold;
            private int m_nRuleMask;
            protected static final QuorumRule NONE_ALLOWED = new QuorumRule(0, 0);
            protected static final QuorumRule ALL_ALLOWED = new QuorumRule(-1, -1);

            public QuorumRule(int nRuleMask, int nThreshold) {
                this.setRuleMask(nRuleMask);
                this.setThreshold(nThreshold);
            }

            public String toString() {
                return "QuorumRule {threshold=" + this.getThreshold() + ", rule mask=" + this.getRuleMask() + "}";
            }

            protected boolean contains(int nMask) {
                return (this.getRuleMask() & nMask) != 0;
            }

            protected QuorumRule union(QuorumRule rule) {
                return new QuorumRule(this.getRuleMask() | rule.getRuleMask(), Math.max(this.getThreshold(), rule.getThreshold()));
            }

            protected int getRuleMask() {
                return this.m_nRuleMask;
            }

            protected void setRuleMask(int nRuleMask) {
                this.m_nRuleMask = nRuleMask;
            }

            protected int getThreshold() {
                return this.m_nThreshold;
            }

            protected void setThreshold(int nThreshold) {
                this.m_nThreshold = nThreshold;
            }
        }

        protected class QuorumListener
        implements MemberListener,
        SynchronousListener {
            protected QuorumListener() {
            }

            @Override
            public void memberJoined(MemberEvent evt) {
                MembershipQuorumPolicy.this.updateCurrentRule();
            }

            @Override
            public void memberLeaving(MemberEvent evt) {
                MembershipQuorumPolicy.this.getLeavingMembers().add(evt.getMember());
                MembershipQuorumPolicy.this.updateCurrentRule();
            }

            @Override
            public void memberLeft(MemberEvent evt) {
                MembershipQuorumPolicy.this.getLeavingMembers().remove(evt.getMember());
                MembershipQuorumPolicy.this.updateCurrentRule();
            }
        }
    }
}

