/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.Service;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class DefaultCacheServer
extends Base {
    public static final long DEFAULT_WAIT_MILLIS = 5000L;
    private static DefaultCacheServer s_instance = null;
    private final Object m_lock = new Object();
    private final DefaultConfigurableCacheFactory m_factory;
    protected volatile boolean m_fShutdown;
    protected Thread m_threadShutdown = DefaultCacheServer.makeThread(null, new ShutdownProcess(), null);

    public DefaultCacheServer(DefaultConfigurableCacheFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory can not be null");
        }
        this.m_factory = factory;
    }

    public void startAndMonitor(long cWaitMillis) {
        this.setUp();
        this.intialStartServices();
        this.monitorServices(cWaitMillis);
    }

    public List<Service> startServices() {
        DefaultConfigurableCacheFactory factory = this.m_factory;
        LinkedList<Service> list = new LinkedList<Service>();
        XmlElement xmlConfig = factory.getConfig();
        for (Object o : xmlConfig.getSafeElement("caching-schemes").getElementList()) {
            XmlElement xmlScheme = (XmlElement)o;
            if (!xmlScheme.getSafeElement("autostart").getBoolean()) continue;
            try {
                Service service = factory.ensureService(xmlScheme);
                if (list.contains(service)) continue;
                list.add(service);
            }
            catch (RuntimeException e) {
                this.handleEnsureServiceException(e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownServer() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_fShutdown = true;
            this.m_lock.notifyAll();
        }
        CacheFactory.shutdown();
    }

    public static void shutdown() {
        DefaultCacheServer.getInstance().shutdownServer();
    }

    public static void startDaemon() {
        Thread thread = DefaultCacheServer.makeThread(null, new Runnable(){

            @Override
            public void run() {
                DefaultCacheServer dcs = DefaultCacheServer.ensureInstance(DefaultCacheServer.getDefaultConfigurableCacheFactory());
                Runtime runtime = Runtime.getRuntime();
                while (!dcs.m_fShutdown) {
                    try {
                        dcs.startAndMonitor(5000L);
                    }
                    catch (Exception e) {
                        CacheFactory.log("Failed to start services: " + e, 1);
                        runtime.removeShutdownHook(dcs.m_threadShutdown);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e2) {}
                    }
                }
            }
        }, "DefaultCacheServer");
        thread.setDaemon(true);
        thread.start();
    }

    public static void main(String[] asArg) {
        if (asArg.length > 0) {
            CacheFactory.getCacheFactoryBuilder().setCacheConfiguration(null, XmlHelper.loadFileOrResource(asArg[0], "cache configuration", null));
        }
        long cWaitMillis = 5000L;
        try {
            cWaitMillis = 1000L * (long)Math.max(0, Integer.parseInt(asArg[1]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultCacheServer.ensureInstance(DefaultCacheServer.getDefaultConfigurableCacheFactory()).startAndMonitor(cWaitMillis);
    }

    public static List start() {
        return DefaultCacheServer.start(DefaultCacheServer.getDefaultConfigurableCacheFactory());
    }

    public static List start(ConfigurableCacheFactory factory) {
        if (!(factory instanceof DefaultConfigurableCacheFactory)) {
            throw new UnsupportedOperationException("Unable to use " + factory.getClass());
        }
        return DefaultCacheServer.ensureInstance((DefaultConfigurableCacheFactory)factory).startServices();
    }

    protected void setUp() {
        Runtime.getRuntime().addShutdownHook(this.m_threadShutdown);
    }

    protected void intialStartServices() {
        this.startServices();
        CacheFactory.log(this.getServiceBanner(CacheFactory.getCluster()) + '\n' + "Started DefaultCacheServer...\n", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void monitorServices(long cWaitMillis) {
        Object object = this.m_lock;
        synchronized (object) {
            while (true) {
                try {
                    this.m_lock.wait(cWaitMillis);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.m_fShutdown) break;
                try {
                    this.startServices();
                }
                catch (RuntimeException e) {
                    CacheFactory.log("Failed to restart services: " + e, 1);
                }
            }
        }
    }

    protected void handleEnsureServiceException(RuntimeException e) {
        throw e;
    }

    protected String getServiceBanner(Cluster cluster) {
        try {
            cluster = (Cluster)ClassHelper.invoke(cluster, "getCluster", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\nServices\n  (\n  ");
        if (cluster != null) {
            Enumeration e = cluster.getServiceNames();
            while (e.hasMoreElements()) {
                Service service = cluster.getService((String)e.nextElement());
                if (service == null) continue;
                sb.append(service).append("\n  ");
            }
        }
        sb.append(")\n");
        return sb.toString();
    }

    private static DefaultConfigurableCacheFactory getDefaultConfigurableCacheFactory() {
        return (DefaultConfigurableCacheFactory)CacheFactory.getConfigurableCacheFactory(DefaultCacheServer.getContextClassLoader());
    }

    private static synchronized DefaultCacheServer ensureInstance(DefaultConfigurableCacheFactory factory) {
        DefaultCacheServer instance = s_instance;
        if (instance == null) {
            s_instance = instance = new DefaultCacheServer(factory);
        } else if (factory != instance.m_factory) {
            throw new IllegalArgumentException("The DefaultCacheServer has already been started with a different factory object");
        }
        return instance;
    }

    private static synchronized DefaultCacheServer getInstance() {
        DefaultCacheServer instance = s_instance;
        if (instance == null) {
            throw new IllegalStateException("The DefaultCacheServer has not been started");
        }
        return instance;
    }

    protected class ShutdownProcess
    implements Runnable {
        protected ShutdownProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DefaultCacheServer.this.m_lock;
            synchronized (object) {
                DefaultCacheServer.this.m_fShutdown = true;
                DefaultCacheServer.this.m_lock.notifyAll();
            }
        }
    }
}

