/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.AbstractBundler;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.SafeHashSet;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractBinaryEntryBundler
extends AbstractBundler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(BinaryEntry binEntry) {
        AtomicInteger counter = this.m_countThreads;
        int cThreads = counter.incrementAndGet();
        try {
            boolean fBurst;
            Bundle bundle;
            if (cThreads < this.getThreadThreshold()) {
                this.bundle(Collections.singleton(binEntry));
                return;
            }
            while (true) {
                Bundle bundle2 = bundle = (Bundle)this.getOpenBundle();
                synchronized (bundle2) {
                    if (bundle.isOpen()) {
                        boolean fFirst = bundle.add(binEntry);
                        fBurst = bundle.waitForResults(fFirst);
                        break;
                    }
                }
            }
            bundle.process(fBurst, binEntry);
        }
        finally {
            counter.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAll(Set set) {
        AtomicInteger counter = this.m_countThreads;
        int cThreads = counter.incrementAndGet();
        try {
            boolean fBurst;
            Bundle bundle;
            if (cThreads < this.getThreadThreshold()) {
                this.bundle(set);
                return;
            }
            while (true) {
                Bundle bundle2 = bundle = (Bundle)this.getOpenBundle();
                synchronized (bundle2) {
                    if (bundle.isOpen()) {
                        boolean fFirst = bundle.addAll(set);
                        fBurst = bundle.waitForResults(fFirst);
                        break;
                    }
                }
            }
            bundle.processAll(fBurst, set);
        }
        finally {
            counter.decrementAndGet();
        }
    }

    protected abstract void bundle(Set var1);

    protected abstract void unbundle(BinaryEntry var1);

    @Override
    protected AbstractBundler.Bundle instantiateBundle() {
        return new Bundle();
    }

    protected class Bundle
    extends AbstractBundler.Bundle {
        private Set m_setEntries;

        protected Bundle() {
            super(AbstractBinaryEntryBundler.this);
            this.m_setEntries = new SafeHashSet();
        }

        protected boolean add(BinaryEntry binEntry) {
            Set set = this.m_setEntries;
            boolean fFirst = set.isEmpty();
            set.add(binEntry);
            return fFirst;
        }

        protected boolean addAll(Set setEntries) {
            Set set = this.m_setEntries;
            boolean fFirst = set.isEmpty();
            set.addAll(setEntries);
            return fFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(boolean fBurst, BinaryEntry binEntry) {
            try {
                if (!this.ensureResults(fBurst)) {
                    AbstractBinaryEntryBundler.this.bundle(Collections.singleton(binEntry));
                }
            }
            finally {
                this.releaseThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processAll(boolean fBurst, Set setEntries) {
            try {
                if (!this.ensureResults(fBurst)) {
                    AbstractBinaryEntryBundler.this.bundle(setEntries);
                }
            }
            finally {
                this.releaseThread();
            }
        }

        @Override
        protected int getBundleSize() {
            return Math.max(super.getBundleSize(), this.m_setEntries.size());
        }

        @Override
        protected void ensureResults() {
            AbstractBinaryEntryBundler.this.bundle(this.m_setEntries);
        }

        @Override
        protected synchronized boolean releaseThread() {
            boolean fRelease = super.releaseThread();
            if (fRelease) {
                this.m_setEntries.clear();
            }
            return fRelease;
        }
    }
}

