/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.AbstractBundler;
import com.tangosol.util.SafeHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractKeyBundler
extends AbstractBundler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object process(Object oKey) {
        AtomicInteger counter = this.m_countThreads;
        int cThreads = counter.incrementAndGet();
        try {
            boolean fBurst;
            Object object;
            Bundle bundle;
            if (cThreads < this.getThreadThreshold()) {
                Object object2 = this.unbundle(oKey);
                return object2;
            }
            while (true) {
                bundle = (Bundle)this.getOpenBundle();
                object = bundle;
                synchronized (object) {
                    if (bundle.isOpen()) {
                        boolean fFirst = bundle.add(oKey);
                        fBurst = bundle.waitForResults(fFirst);
                        break;
                    }
                }
            }
            object = bundle.process(fBurst, oKey);
            return object;
        }
        finally {
            counter.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map processAll(Collection colKeys) {
        AtomicInteger counter = this.m_countThreads;
        int cThreads = counter.incrementAndGet();
        try {
            boolean fBurst;
            Object object;
            Bundle bundle;
            if (cThreads < this.getThreadThreshold()) {
                Map map = this.bundle(colKeys);
                return map;
            }
            while (true) {
                bundle = (Bundle)this.getOpenBundle();
                object = bundle;
                synchronized (object) {
                    if (bundle.isOpen()) {
                        boolean fFirst = bundle.addAll(colKeys);
                        fBurst = bundle.waitForResults(fFirst);
                        break;
                    }
                }
            }
            object = bundle.processAll(fBurst, colKeys);
            return object;
        }
        finally {
            counter.decrementAndGet();
        }
    }

    protected abstract Map bundle(Collection var1);

    protected abstract Object unbundle(Object var1);

    @Override
    protected AbstractBundler.Bundle instantiateBundle() {
        return new Bundle();
    }

    protected class Bundle
    extends AbstractBundler.Bundle {
        private Set m_setKeys = new SafeHashSet();
        private Map m_mapResults;

        protected Bundle() {
        }

        protected boolean add(Object oKey) {
            Set setKeys = this.m_setKeys;
            boolean fFirst = setKeys.isEmpty();
            setKeys.add(oKey);
            return fFirst;
        }

        protected boolean addAll(Collection colKeys) {
            Set setKeys = this.m_setKeys;
            boolean fFirst = setKeys.isEmpty();
            setKeys.addAll(colKeys);
            return fFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object process(boolean fBurst, Object oKey) {
            try {
                Object object = this.ensureResults(fBurst) ? this.m_mapResults.get(oKey) : AbstractKeyBundler.this.unbundle(oKey);
                return object;
            }
            finally {
                this.releaseThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map processAll(boolean fBurst, Collection colKeys) {
            try {
                if (this.ensureResults(fBurst)) {
                    Map mapResults = this.m_mapResults;
                    HashMap map = new HashMap(colKeys.size());
                    for (Object oKey : colKeys) {
                        Object oVal = mapResults.get(oKey);
                        if (oVal == null) continue;
                        map.put(oKey, oVal);
                    }
                    HashMap hashMap = map;
                    return hashMap;
                }
                Map map = AbstractKeyBundler.this.bundle(colKeys);
                return map;
            }
            finally {
                this.releaseThread();
            }
        }

        @Override
        protected int getBundleSize() {
            return Math.max(super.getBundleSize(), this.m_setKeys.size());
        }

        @Override
        protected void ensureResults() {
            this.m_mapResults = AbstractKeyBundler.this.bundle(this.m_setKeys);
        }

        @Override
        protected synchronized boolean releaseThread() {
            boolean fRelease = super.releaseThread();
            if (fRelease) {
                this.m_setKeys.clear();
                this.m_mapResults = null;
            }
            return fRelease;
        }
    }
}

