/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.BinaryStore;
import com.tangosol.net.cache.AbstractCacheStore;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.IterableCacheLoader;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterEnumerator;
import com.tangosol.util.ExternalizableHelper;
import java.util.Iterator;

public class BinaryStoreCacheStore
extends AbstractCacheStore
implements CacheStore,
IterableCacheLoader {
    private BinaryStore m_store;
    private ClassLoader m_loader;
    private boolean m_fBinaryOnly;

    public BinaryStoreCacheStore(BinaryStore store) {
        this.setBinaryStore(store);
    }

    public BinaryStoreCacheStore(BinaryStore store, ClassLoader loader) {
        this.setClassLoader(loader);
        this.setBinaryStore(store);
    }

    public BinaryStoreCacheStore(BinaryStore store, boolean fBinaryOnly) {
        this.m_fBinaryOnly = fBinaryOnly;
        this.setBinaryStore(store);
    }

    @Override
    public Object load(Object oKey) {
        Binary bin = this.getBinaryStore().load(this.toBinary(oKey));
        return bin == null ? null : this.fromBinary(bin);
    }

    @Override
    public void store(Object oKey, Object oValue) {
        this.getBinaryStore().store(this.toBinary(oKey), this.toBinary(oValue));
    }

    @Override
    public void erase(Object oKey) {
        this.getBinaryStore().erase(this.toBinary(oKey));
    }

    @Override
    public Iterator keys() {
        Iterator iter = this.getBinaryStore().keys();
        Converter conv = new Converter(){

            @Override
            public Object convert(Object o) {
                return BinaryStoreCacheStore.this.fromBinary((Binary)o);
            }
        };
        return new ConverterEnumerator(iter, conv);
    }

    protected Binary toBinary(Object o) {
        return this.isBinaryOnly() ? (Binary)o : ExternalizableHelper.toBinary(o);
    }

    protected Object fromBinary(Binary bin) {
        return this.isBinaryOnly() ? bin : ExternalizableHelper.fromBinary(bin, this.getClassLoader());
    }

    public BinaryStore getBinaryStore() {
        return this.m_store;
    }

    protected void setBinaryStore(BinaryStore store) {
        this.m_store = store;
    }

    public ClassLoader getClassLoader() {
        return this.m_loader;
    }

    protected void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public boolean isBinaryOnly() {
        return this.m_fBinaryOnly;
    }
}

