/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.license.CoherenceApplicationEdition;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardian;
import com.tangosol.net.cache.AbstractBinaryEntryBundler;
import com.tangosol.net.cache.AbstractBundler;
import com.tangosol.net.cache.AbstractCacheStore;
import com.tangosol.net.cache.AbstractEntryBundler;
import com.tangosol.net.cache.AbstractKeyBundler;
import com.tangosol.net.cache.BackingMapBinaryEntry;
import com.tangosol.net.cache.BinaryEntryStore;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Daemon;
import com.tangosol.util.EntrySetMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InflatableList;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ReadWriteBackingMap
extends AbstractMap
implements CacheMap {
    protected static final Binary NO_VALUE = new Binary();
    protected static final Binary BIN_STORE_PENDING = ExternalizableHelper.toBinary(Boolean.FALSE);
    protected static final float GUARD_RECOVERY = 0.9f;
    public static final long MIN_REQUEUE_DELAY = Long.parseLong(System.getProperty("tangosol.coherence.rwbm.requeue.delay", "60000"));
    private BackingMapManagerContext m_ctxService;
    private boolean m_fActive = true;
    private ObservableMap m_mapInternal;
    private Map m_mapMisses;
    private ConcurrentMap m_mapControl;
    private MapListener m_listenerInternal;
    private Map m_mapSyntheticEvents;
    private StoreWrapper m_store;
    private boolean m_fReadOnly;
    private ReadQueue m_queueRead;
    private ReadThread m_daemonRead;
    private WriteQueue m_queueWrite;
    private WriteThread m_daemonWrite;
    protected MapListenerSupport m_listenerSupport;
    private EntrySet m_entryset;
    private KeySet m_keyset;
    private ValuesCollection m_values;
    private long m_cWriteBehindMillis;
    private long m_cStoreTimeoutMillis;
    private volatile double m_dflRefreshAheadFactor;
    private volatile boolean m_fRethrowExceptions;
    private volatile double m_dflWriteBatchFactor;
    private volatile int m_cWriteRequeueThreshold;
    private int m_cWriteMaxBatchSize = 128;

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheLoader loader) {
        this.init(ctxService, mapInternal, mapMisses, loader, null, true, 0, 0.0);
    }

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheLoader loader, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        this.init(ctxService, mapInternal, mapMisses, loader, null, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor);
    }

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, BinaryEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        this.init(ctxService, mapInternal, mapMisses, null, storeBinary, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor);
    }

    private void init(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheLoader loader, BinaryEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        this.m_ctxService = ctxService;
        this.configureInternalCache(mapInternal);
        if (loader != null || storeBinary != null) {
            this.m_mapMisses = mapMisses;
            if (loader == null) {
                this.configureCacheStore(this.instantiateCacheStoreWrapper(storeBinary), fReadOnly);
            } else if (loader instanceof CacheStore) {
                this.configureCacheStore(this.instantiateCacheStoreWrapper((CacheStore)loader), fReadOnly);
            } else {
                this.configureCacheStore(this.instantiateCacheStoreWrapper(this.instantiateCacheLoaderCacheStore(loader)), true);
            }
            this.configureWriteThread(cWriteBehindSeconds);
            this.configureReadThread(dflRefreshAheadFactor);
        }
    }

    public BackingMapManagerContext getContext() {
        return this.m_ctxService;
    }

    public CacheService getCacheService() {
        return this.getContext().getCacheService();
    }

    public boolean isRethrowExceptions() {
        return this.m_fRethrowExceptions;
    }

    public void setRethrowExceptions(boolean fRethrow) {
        this.m_fRethrowExceptions = fRethrow;
    }

    public double getRefreshAheadFactor() {
        return this.m_dflRefreshAheadFactor;
    }

    public void setRefreshAheadFactor(double dflRefreshAheadFactor) {
        if (this.isRefreshAhead()) {
            if (dflRefreshAheadFactor >= 0.0 && dflRefreshAheadFactor <= 1.0) {
                this.m_dflRefreshAheadFactor = dflRefreshAheadFactor;
            } else {
                throw new IllegalArgumentException("Invalid refresh-ahead factor: " + dflRefreshAheadFactor);
            }
        }
    }

    public boolean isReadOnly() {
        return this.m_fReadOnly;
    }

    public boolean isRefreshAhead() {
        return this.getCacheStore() != null && this.getReadQueue() != null;
    }

    public int getWriteMaxBatchSize() {
        return this.m_cWriteMaxBatchSize;
    }

    public void setWriteMaxBatchSize(int cWriteMaxBatchSize) {
        if (cWriteMaxBatchSize <= 0) {
            throw new IllegalArgumentException("Invalid batch size: " + cWriteMaxBatchSize);
        }
        this.m_cWriteMaxBatchSize = cWriteMaxBatchSize;
    }

    public double getWriteBatchFactor() {
        return this.m_dflWriteBatchFactor;
    }

    public void setWriteBatchFactor(double dflWriteBatchFactor) {
        if (this.isWriteBehind()) {
            if (dflWriteBatchFactor >= 0.0 && dflWriteBatchFactor <= 1.0) {
                this.m_dflWriteBatchFactor = dflWriteBatchFactor;
            } else {
                throw new IllegalArgumentException("Invalid write-batch factor: " + dflWriteBatchFactor);
            }
        }
    }

    public boolean isWriteBehind() {
        return !this.isReadOnly() && this.getCacheStore() != null && this.getWriteQueue() != null;
    }

    public int getWriteBehindSeconds() {
        long cMillis = this.getWriteBehindMillis();
        return cMillis == 0L ? 0 : Math.max(1, (int)(cMillis / 1000L));
    }

    public void setWriteBehindSeconds(int cSecs) {
        this.setWriteBehindMillis(1000L * (long)cSecs);
    }

    public long getWriteBehindMillis() {
        return this.m_cWriteBehindMillis;
    }

    public void setWriteBehindMillis(long cMillis) {
        if (this.isWriteBehind()) {
            if (cMillis > 0L) {
                int cExpiryMillis;
                ConfigurableCacheMap cache = this.getInternalConfigurableCache();
                if (cache != null && (cExpiryMillis = cache.getExpiryDelay()) > 0 && (long)cExpiryMillis < cMillis) {
                    StringBuffer sb = new StringBuffer().append("ReadWriteBackingMap internal cache expiry of ").append(cExpiryMillis).append(" milliseconds is less than the write-delay of ").append(cMillis).append(" milliseconds; ");
                    cMillis = cExpiryMillis;
                    sb.append("decreasing the write-delay to ").append(cMillis).append(" milliseconds.");
                    Base.log(sb.toString());
                }
                this.m_cWriteBehindMillis = cMillis;
                this.getWriteQueue().setDelayMillis(cMillis);
            } else {
                throw new IllegalArgumentException("Invalid write-behind delay: " + cMillis);
            }
        }
    }

    public int getWriteRequeueThreshold() {
        return this.m_cWriteRequeueThreshold;
    }

    public void setWriteRequeueThreshold(int cThreshold) {
        if (this.isWriteBehind()) {
            if (cThreshold >= 0) {
                this.m_cWriteRequeueThreshold = cThreshold;
            } else {
                throw new IllegalArgumentException("Invalid write requeue threshold: " + cThreshold);
            }
        }
    }

    public boolean isWriteThrough() {
        return !this.isReadOnly() && this.getCacheStore() != null && this.getWriteQueue() == null;
    }

    public long getCacheStoreTimeoutMillis() {
        return this.m_cStoreTimeoutMillis;
    }

    public void setCacheStoreTimeoutMillis(long cStoreTimeoutMillis) {
        this.m_cStoreTimeoutMillis = cStoreTimeoutMillis;
        CacheService service = this.getContext().getCacheService();
        if (service instanceof Guardian) {
            ReadThread daemonRead = this.getReadThread();
            WriteThread daemonWrite = this.getWriteThread();
            if (daemonRead != null) {
                daemonRead.setGuardPolicy((Guardian)((Object)service), cStoreTimeoutMillis, 0.9f);
                daemonRead.m_fRefreshContext = true;
            }
            if (daemonWrite != null) {
                daemonWrite.setGuardPolicy((Guardian)((Object)service), cStoreTimeoutMillis, 0.9f);
                daemonWrite.m_fRefreshContext = true;
            }
        }
    }

    @Override
    public void clear() {
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.getInternalCache().containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.getInternalCache().containsValue(oValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object oKey) {
        ConcurrentMap mapControl = this.getControlMap();
        Map mapMisses = this.getMissesCache();
        mapControl.lock(oKey, -1L);
        try {
            StoreWrapper store;
            if (mapMisses != null && mapMisses.containsKey(oKey)) {
                Object var4_4 = null;
                return var4_4;
            }
            Object oValue = this.getFromInternalCache(oKey);
            if (oValue == null && this.getContext().isKeyOwned(oKey) && (store = this.getCacheStore()) != null) {
                oValue = store.load(oKey);
                this.putToInternalCache(oKey, oValue);
            }
            Object object = oValue;
            return object;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.putInternal(oKey, oValue, 0L);
    }

    public Object remove(Object oKey) {
        return this.removeInternal(oKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeInternal(Object oKey, boolean fBlind) {
        ConcurrentMap mapControl = this.getControlMap();
        Map mapMisses = this.getMissesCache();
        mapControl.lock(oKey, -1L);
        try {
            if (mapMisses != null) {
                mapMisses.remove(oKey);
            }
            this.cancelOutstandingReads(oKey);
            Object oValue = this.getCachedOrPending(oKey);
            StoreWrapper store = this.getCacheStore();
            if (store != null) {
                boolean fOwned = this.getContext().isKeyOwned(oKey);
                if (!fBlind && oValue == null && fOwned && (oValue = store.load(oKey)) == null) {
                    Object var8_9 = null;
                    return var8_9;
                }
                if (!this.isReadOnly()) {
                    this.removeFromWriteQueue(oKey);
                    if (fOwned) {
                        store.erase(this.instantiateEntry(oKey, null, oValue));
                    }
                }
            }
            this.getInternalCache().remove(oKey);
            Object object = oValue;
            return object;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    @Override
    public int size() {
        return this.getInternalCache().size();
    }

    public Set entrySet() {
        EntrySet set = this.m_entryset;
        if (set == null) {
            this.m_entryset = set = this.instantiateEntrySet();
        }
        return set;
    }

    public Set keySet() {
        KeySet set = this.m_keyset;
        if (set == null) {
            this.m_keyset = set = this.instantiateKeySet();
        }
        return set;
    }

    public Collection values() {
        ValuesCollection values = this.m_values;
        if (values == null) {
            this.m_values = values = this.instantiateValuesCollection();
        }
        return values;
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.putInternal(oKey, oValue, cMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getAll(Collection colKeys) {
        ConcurrentMap mapControl = this.getControlMap();
        BackingMapManagerContext ctx = this.getContext();
        if (!(colKeys instanceof SortedSet)) {
            colKeys = new TreeSet(colKeys);
        }
        try {
            Map mapMisses = this.getMissesCache();
            HashMap mapResult = new HashMap();
            HashSet setLoad = new HashSet();
            for (Object oKey : colKeys) {
                if (!ctx.isKeyOwned(oKey)) {
                    throw new IllegalStateException("Key is not owned: " + oKey);
                }
                mapControl.lock(oKey, -1L);
                if (mapMisses != null && mapMisses.containsKey(oKey)) continue;
                Object oValue = this.getFromInternalCache(oKey);
                if (oValue == null) {
                    setLoad.add(oKey);
                    continue;
                }
                mapResult.put(oKey, oValue);
            }
            if (setLoad.isEmpty()) {
                HashMap i$ = mapResult;
                return i$;
            }
            StoreWrapper store = this.getCacheStore();
            if (store != null) {
                Map mapLoaded = store.loadAll(setLoad);
                for (Object oKey : setLoad) {
                    this.putToInternalCache(oKey, mapLoaded.get(oKey));
                }
                mapResult.putAll(mapLoaded);
            }
            HashMap hashMap = mapResult;
            return hashMap;
        }
        finally {
            for (Object oKey : colKeys) {
                mapControl.unlock(oKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putToInternalCache(Object oKey, Object oVal) {
        if (oVal == null) {
            Map mapMisses = this.getMissesCache();
            if (mapMisses != null) {
                mapMisses.put(oKey, oKey);
            }
        } else {
            Map mapSynthetic = this.getSyntheticEventsMap();
            mapSynthetic.put(oKey, oKey);
            try {
                this.getInternalCache().put(oKey, oVal);
            }
            finally {
                mapSynthetic.remove(oKey);
            }
        }
    }

    protected void cancelOutstandingReads(Object oKey) {
        if (this.isRefreshAhead() && !this.isReadOnly()) {
            ConcurrentMap mapControl = this.getControlMap();
            this.getReadQueue().remove(oKey);
            ReadLatch latch = (ReadLatch)mapControl.get(oKey);
            if (latch != null) {
                latch.cancel();
                mapControl.remove(oKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getFromInternalCache(Object oKey) {
        ReadLatch latch;
        if (!this.isRefreshAhead()) return this.getCachedOrPending(oKey);
        ConfigurableCacheMap cache = this.getInternalConfigurableCache();
        ConfigurableCacheMap.Entry entry = cache.getCacheEntry(oKey);
        ConcurrentMap mapControl = this.getControlMap();
        if (entry == null) {
            if (!this.getContext().isKeyOwned(oKey)) {
                return null;
            }
            ReadLatch latch2 = (ReadLatch)mapControl.get(oKey);
            if (latch2 == null) {
                this.getReadQueue().remove(oKey);
                return this.getCachedOrPending(oKey);
            }
            try {
                ReadLatch readLatch = latch2;
                synchronized (readLatch) {
                    while (!latch2.isComplete()) {
                        latch2.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                mapControl.remove(oKey);
            }
            Object oVal = latch2.getValue();
            this.putToInternalCache(oKey, oVal);
            return oVal;
        }
        long lExpiryMillis = entry.getExpiryMillis();
        if (lExpiryMillis == 0L) return entry.getValue();
        long lInterval = (long)((double)cache.getExpiryDelay() * this.getRefreshAheadFactor());
        if (Base.getSafeTimeMillis() < lExpiryMillis - lInterval || (latch = (ReadLatch)mapControl.get(oKey)) != null) return entry.getValue();
        this.getReadQueue().add(oKey);
        return entry.getValue();
    }

    protected Object getCachedOrPending(Object oKey) {
        WriteQueue queue;
        Object oValue = this.getInternalCache().get(oKey);
        if (oValue == null && (queue = this.getWriteQueue()) != null) {
            oValue = queue.checkPending(oKey);
        }
        return oValue;
    }

    protected Object putInternal(Object oKey, Object oValue, long cMillis) {
        ConcurrentMap mapControl = this.getControlMap();
        Map mapMisses = this.getMissesCache();
        ObservableMap mapInternal = this.getInternalCache();
        mapControl.lock(oKey, -1L);
        try {
            if (mapMisses != null) {
                mapMisses.remove(oKey);
            }
            this.cancelOutstandingReads(oKey);
            BackingMapManagerContext ctx = this.getContext();
            StoreWrapper store = this.getCacheStore();
            WriteQueue queue = this.getWriteQueue();
            if (store != null && !this.isReadOnly()) {
                boolean fOwned = ctx.isKeyOwned(oKey);
                if (queue == null) {
                    if (fOwned) {
                        Entry entry = this.instantiateEntry(oKey, oValue, mapInternal.get(oKey));
                        store.store(entry, false);
                        if (entry.isChanged()) {
                            if (entry.isRemoved()) {
                                cMillis = 1L;
                            } else {
                                oValue = entry.getChangedBinaryValue();
                                cMillis = this.extractExpiry(entry);
                            }
                        }
                    }
                } else if (fOwned) {
                    oValue = ExternalizableHelper.decorate((Binary)oValue, 2, BIN_STORE_PENDING);
                } else if (ExternalizableHelper.getDecoration((Binary)oValue, 2) == null) {
                    queue = null;
                }
            }
            if (queue != null) {
                queue.add(this.instantiateEntry(oKey, oValue, mapInternal.get(oKey)), 0L);
            }
            if (mapInternal instanceof CacheMap) {
                Object object = ((CacheMap)mapInternal).put(oKey, oValue, cMillis);
                return object;
            }
            if (cMillis <= 0L) {
                Object object = mapInternal.put(oKey, oValue);
                return object;
            }
            throw new UnsupportedOperationException("Class \"" + mapInternal.getClass().getName() + "\" does not implement CacheMap interface");
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    protected boolean waitFor(Object o, long cMillis) {
        try {
            o.wait(cMillis);
        }
        catch (InterruptedException e) {
            if (this.isActive()) {
                throw Base.ensureRuntimeException(e);
            }
            return false;
        }
        return true;
    }

    protected void heartbeat() {
        long cMillis = this.getCacheStoreTimeoutMillis();
        if (cMillis == 0L) {
            GuardSupport.heartbeat();
        } else {
            GuardSupport.heartbeat(cMillis);
        }
    }

    protected long extractExpiry(Entry entry) {
        Binary binValue = entry.getBinaryValue();
        Binary bin = ExternalizableHelper.getDecoration(binValue, 1);
        if (bin != null) {
            try {
                long ldtExpiry = bin.getBufferInput().readLong();
                long ldtNow = Base.getSafeTimeMillis();
                return Math.max(ldtExpiry - ldtNow, 1L);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return entry.getExpiryDelay();
    }

    protected EntrySet instantiateEntrySet() {
        return new EntrySet();
    }

    protected KeySet instantiateKeySet() {
        return new KeySet();
    }

    protected ValuesCollection instantiateValuesCollection() {
        return new ValuesCollection();
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, oKey, fLite);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, filter, fLite);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Map && this.getInternalCache().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getInternalCache().hashCode();
    }

    @Override
    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + '{' + this.getInternalCache() + '}';
    }

    public ObservableMap getInternalCache() {
        return this.m_mapInternal;
    }

    protected ConfigurableCacheMap getInternalConfigurableCache() {
        ObservableMap mapInternal = this.m_mapInternal;
        return mapInternal instanceof ConfigurableCacheMap ? (ConfigurableCacheMap)mapInternal : null;
    }

    protected void configureInternalCache(ObservableMap mapInternal) {
        this.m_mapInternal = mapInternal;
        this.m_mapControl = this.instantiateControlMap();
        this.m_listenerInternal = this.instantiateInternalListener();
        mapInternal.addMapListener(this.getInternalListener());
    }

    public Map getMissesCache() {
        return this.m_mapMisses;
    }

    public ConcurrentMap getControlMap() {
        return this.m_mapControl;
    }

    protected ConcurrentMap instantiateControlMap() {
        return new SegmentedConcurrentMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getSyntheticEventsMap() {
        Map map = this.m_mapSyntheticEvents;
        if (map == null) {
            ReadWriteBackingMap readWriteBackingMap = this;
            synchronized (readWriteBackingMap) {
                map = this.m_mapSyntheticEvents;
                if (map == null) {
                    map = this.m_mapSyntheticEvents = new SafeHashMap();
                }
            }
        }
        return map;
    }

    protected MapListener getInternalListener() {
        return this.m_listenerInternal;
    }

    protected MapListener instantiateInternalListener() {
        return new InternalMapListener();
    }

    public void release() {
        if (this.isActive()) {
            try {
                this.getInternalCache().removeMapListener(this.getInternalListener());
            }
            catch (Exception e) {
                Base.err("An exception occurred while removing an internal listener during release:");
                Base.err(e);
            }
            if (this.isRefreshAhead()) {
                this.terminateReadThread();
            }
            if (this.isWriteBehind()) {
                this.terminateWriteThread();
            }
            this.m_store = null;
            this.m_fActive = false;
        }
    }

    public boolean isActive() {
        return this.m_fActive;
    }

    protected ReadLatch instantiateReadLatch(Object oKey) {
        return new ReadLatch(oKey);
    }

    public ReadQueue getReadQueue() {
        return this.m_queueRead;
    }

    protected ReadQueue instantiateReadQueue() {
        return new ReadQueue();
    }

    public WriteQueue getWriteQueue() {
        return this.m_queueWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        WriteQueue queue = this.getWriteQueue();
        StoreWrapper store = this.getCacheStore();
        if (queue != null && store != null && !this.isReadOnly()) {
            WriteThread writeThread = this.m_daemonWrite;
            synchronized (writeThread) {
                if (queue == this.getWriteQueue()) {
                    this.flush(queue, store);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(WriteQueue queue, StoreWrapper store) {
        Base.azzert(queue != null && store != null);
        ConcurrentMap mapControl = this.getControlMap();
        BackingMapManagerContext ctx = this.getContext();
        boolean fBatch = mapControl.lock(ConcurrentMap.LOCK_ALL, 10L);
        LinkedHashSet<Entry> setBatch = fBatch ? new LinkedHashSet<Entry>() : null;
        try {
            Entry entry = queue.removeImmediate();
            while (entry != null && this.isActive()) {
                Binary binKey = entry.getBinaryKey();
                Binary binValue = entry.getBinaryValue();
                if (binValue != NO_VALUE && ctx.isKeyOwned(binKey)) {
                    if (fBatch) {
                        setBatch.add(entry);
                    } else {
                        mapControl.lock(binKey, -1L);
                        try {
                            store.store(entry, true);
                        }
                        catch (WrapperException e) {
                            Base.err(e);
                        }
                        finally {
                            mapControl.unlock(binKey);
                        }
                    }
                }
                entry = queue.removeImmediate();
            }
            if (fBatch) {
                try {
                    store.storeAll(setBatch);
                }
                catch (WrapperException e) {
                    Base.err(e);
                }
            }
        }
        finally {
            if (fBatch) {
                mapControl.unlock(ConcurrentMap.LOCK_ALL);
            }
        }
    }

    protected Entry removeFromWriteQueue(Object binKey) {
        WriteQueue queue = this.getWriteQueue();
        if (queue == null) {
            return null;
        }
        if (this.getWriteRequeueThreshold() == 0) {
            return queue.remove(binKey);
        }
        return queue.add(this.instantiateEntry(binKey, NO_VALUE, NO_VALUE), 0L);
    }

    protected Entry instantiateEntry(Object oKey, Object oValue, Object oValueOrig) {
        return new Entry((Binary)oKey, (Binary)oValue, (Binary)oValueOrig, this.getContext());
    }

    protected WriteQueue instantiateWriteQueue() {
        return new WriteQueue();
    }

    protected ReadThread getReadThread() {
        return this.m_daemonRead;
    }

    protected void configureReadThread(double dflRefreshAheadFactor) {
        Base.azzert(dflRefreshAheadFactor >= 0.0 && dflRefreshAheadFactor <= 1.0, "Invalid refresh-ahead factor: " + dflRefreshAheadFactor);
        ConfigurableCacheMap cache = this.getInternalConfigurableCache();
        if (dflRefreshAheadFactor > 0.0 && cache != null) {
            int cWriteDelay;
            int cExpiry;
            int cReadDelay;
            int cExpiryMillis = cache.getExpiryDelay();
            if (cExpiryMillis == 0) {
                dflRefreshAheadFactor = 0.0;
            } else if (this.isWriteBehind() && (cReadDelay = (int)((double)(cExpiry = cExpiryMillis / 1000) * (1.0 - dflRefreshAheadFactor))) < (cWriteDelay = this.getWriteBehindSeconds())) {
                cReadDelay = (cExpiry + cWriteDelay) / 2;
                StringBuffer sb = new StringBuffer().append("ReadWriteBackingMap refresh-ahead factor of ").append(dflRefreshAheadFactor).append(" is too aggressive for the write-delay of ").append(cWriteDelay).append(" seconds; ");
                double d = dflRefreshAheadFactor = cExpiry == 0 ? 0.0 : 1.0 - (double)cReadDelay / (double)cExpiry;
                if (dflRefreshAheadFactor > 0.0) {
                    sb.append("reducing the factor to ").append(dflRefreshAheadFactor).append('.');
                } else {
                    sb.append("disabling refresh-ahead.");
                }
                Base.log(sb.toString());
            }
            if (dflRefreshAheadFactor > 0.0) {
                this.m_dflRefreshAheadFactor = dflRefreshAheadFactor;
                this.m_queueRead = this.instantiateReadQueue();
                this.m_daemonRead = this.instantiateReadThread();
                this.m_daemonRead.start();
            }
        }
    }

    protected ReadThread instantiateReadThread() {
        return new ReadThread();
    }

    protected void terminateReadThread() {
        if (this.isActive()) {
            ReadThread daemon = this.m_daemonRead;
            ReadQueue queue = this.m_queueRead;
            this.m_daemonRead = null;
            this.m_queueRead = null;
            if (daemon != null) {
                daemon.stop();
            }
            if (queue != null) {
                queue.clear();
            }
        }
    }

    protected WriteThread getWriteThread() {
        return this.m_daemonWrite;
    }

    protected void configureWriteThread(int cWriteBehindSeconds) {
        if (cWriteBehindSeconds > 0 && !this.isReadOnly()) {
            this.m_queueWrite = this.instantiateWriteQueue();
            this.m_daemonWrite = this.instantiateWriteThread();
            this.m_daemonWrite.start();
            this.setWriteBehindSeconds(cWriteBehindSeconds);
        }
    }

    protected WriteThread instantiateWriteThread() {
        return new WriteThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateWriteThread() {
        if (this.isActive()) {
            StoreWrapper store = this.getCacheStore();
            WriteQueue queue = this.getWriteQueue();
            if (store != null && queue != null) {
                try {
                    WriteThread daemon;
                    WriteThread writeThread = daemon = this.m_daemonWrite;
                    synchronized (writeThread) {
                        this.m_daemonWrite = null;
                        this.m_queueWrite = null;
                        this.flush(queue, store);
                        if (daemon != null) {
                            daemon.stop();
                        }
                    }
                }
                catch (Exception e) {
                    Base.err("An exception occurred while flushing the write-behind queue while terminating the write-behind thread:");
                    Base.err(e);
                    Base.err("(The write-behind thread is exiting.)");
                }
            }
        }
    }

    public StoreWrapper getCacheStore() {
        return this.m_store;
    }

    protected void configureCacheStore(StoreWrapper store, boolean fReadOnly) {
        Base.azzert(store != null && this.m_store == null);
        this.m_fReadOnly = fReadOnly;
        this.m_store = store;
    }

    protected StoreWrapper instantiateCacheStoreWrapper(CacheStore store) {
        return new CacheStoreWrapper(store);
    }

    protected StoreWrapper instantiateCacheStoreWrapper(BinaryEntryStore store) {
        return new BinaryEntryStoreWrapper(store);
    }

    protected CacheStore instantiateCacheLoaderCacheStore(CacheLoader loader) {
        return new CacheLoaderCacheStore(loader);
    }

    public static class EvictingBackupMap
    extends AbstractKeyBasedMap {
        private Map m_map = new SafeHashMap();

        @Override
        public Object get(Object oKey) {
            return this.m_map.get(oKey);
        }

        @Override
        public Object put(Object oKey, Object oValue) {
            Binary binDeco = ExternalizableHelper.getDecoration((Binary)oValue, 2);
            return EvictingBackupMap.equals(binDeco, BIN_STORE_PENDING) ? this.m_map.put(oKey, oValue) : this.m_map.remove(oKey);
        }

        @Override
        public Object remove(Object oKey) {
            return this.m_map.remove(oKey);
        }

        @Override
        protected Iterator iterateKeys() {
            return this.m_map.keySet().iterator();
        }
    }

    public static class CacheLoaderCacheStore
    extends AbstractCacheStore {
        private CacheLoader m_loader;

        public CacheLoaderCacheStore(CacheLoader loader) {
            CacheLoaderCacheStore.azzert(loader != null);
            this.m_loader = loader;
        }

        @Override
        public Object load(Object oKey) {
            return this.getCacheLoader().load(oKey);
        }

        @Override
        public Map loadAll(Collection colKeys) {
            return this.getCacheLoader().loadAll(colKeys);
        }

        protected CacheLoader getCacheLoader() {
            return this.m_loader;
        }
    }

    public class BinaryEntryStoreWrapper
    extends StoreWrapper {
        private BinaryEntryStore m_storeBinary;

        public BinaryEntryStoreWrapper(BinaryEntryStore store) {
            BinaryEntryStoreWrapper.azzert(store != null);
            this.m_storeBinary = store;
        }

        @Override
        public AbstractBundler instantiateLoadBundler() {
            return new AbstractBinaryEntryBundler(){

                @Override
                protected void bundle(Set setEntries) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().loadAll(setEntries);
                }

                @Override
                protected void unbundle(BinaryEntry binEntry) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().load(binEntry);
                }
            };
        }

        @Override
        public AbstractBundler instantiateStoreBundler() {
            return new AbstractBinaryEntryBundler(){

                @Override
                protected void bundle(Set setEntries) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().storeAll(setEntries);
                }

                @Override
                protected void unbundle(BinaryEntry binEntry) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().store(binEntry);
                }
            };
        }

        @Override
        public AbstractBundler instantiateEraseBundler() {
            return new AbstractBinaryEntryBundler(){

                @Override
                protected void bundle(Set setEntries) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().eraseAll(setEntries);
                }

                @Override
                protected void unbundle(BinaryEntry binEntry) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().erase(binEntry);
                }
            };
        }

        @Override
        protected Object loadInternal(Object binKey) {
            Entry binEntry = ReadWriteBackingMap.this.instantiateEntry(binKey, null, null);
            try {
                AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_loadBundler;
                if (bundler == null) {
                    this.getBinaryEntryStore().load(binEntry);
                } else {
                    bundler.process(binEntry);
                }
                return binEntry.getBinaryValue();
            }
            catch (RuntimeException e) {
                ++this.m_cLoadFailures;
                this.onLoadFailure(binKey, e);
                return null;
            }
        }

        @Override
        protected Map loadAllInternal(Set setBinKey) {
            HashSet<Entry> setEntry = new HashSet<Entry>(setBinKey.size());
            Iterator iter = setBinKey.iterator();
            while (iter.hasNext()) {
                setEntry.add(ReadWriteBackingMap.this.instantiateEntry(iter.next(), null, null));
            }
            try {
                AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_loadBundler;
                if (bundler == null) {
                    this.getBinaryEntryStore().loadAll(setEntry);
                } else {
                    bundler.processAll(setEntry);
                }
                HashMap<Binary, Binary> mapResult = new HashMap<Binary, Binary>();
                for (BinaryEntry binaryEntry : setEntry) {
                    mapResult.put(binaryEntry.getBinaryKey(), binaryEntry.getBinaryValue());
                }
                return mapResult;
            }
            catch (RuntimeException e) {
                ++this.m_cLoadFailures;
                this.onLoadAllFailure(setBinKey, e);
                return Collections.EMPTY_MAP;
            }
        }

        @Override
        protected void storeInternal(Entry binEntry) {
            BinaryEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            binEntry.startTracking();
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_storeBundler;
            if (bundler == null) {
                this.getBinaryEntryStore().store(binEntry);
            } else {
                bundler.process(binEntry);
            }
        }

        @Override
        protected void storeAllInternal(Set setBinEntries) {
            BinaryEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            Iterator iter = setBinEntries.iterator();
            while (iter.hasNext()) {
                ((Entry)iter.next()).startTracking();
            }
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_storeBundler;
            if (bundler == null) {
                this.getBinaryEntryStore().storeAll(setBinEntries);
            } else {
                bundler.processAll(setBinEntries);
            }
        }

        @Override
        protected void eraseInternal(Entry binEntry) {
            BinaryEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_eraseBundler;
            if (bundler == null) {
                this.getBinaryEntryStore().erase(binEntry);
            } else {
                bundler.process(binEntry);
            }
        }

        @Override
        protected void eraseAllInternal(Set setBinEntries) {
            BinaryEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_eraseBundler;
            if (bundler == null) {
                this.getBinaryEntryStore().eraseAll(setBinEntries);
            } else {
                bundler.processAll(setBinEntries);
            }
        }

        @Override
        public Object getStore() {
            return this.getBinaryEntryStore();
        }

        public BinaryEntryStore getBinaryEntryStore() {
            return this.m_storeBinary;
        }

        public String toString() {
            return "BinaryEntryStoreWrapper(" + this.m_storeBinary.getClass().getName() + ')';
        }
    }

    public class CacheStoreWrapper
    extends StoreWrapper {
        private CacheStore m_store;

        public CacheStoreWrapper(CacheStore store) {
            CacheStoreWrapper.azzert(store != null);
            this.m_store = store;
        }

        @Override
        public AbstractBundler instantiateLoadBundler() {
            return new AbstractKeyBundler(){

                @Override
                protected Map bundle(Collection colKeys) {
                    return CacheStoreWrapper.this.getCacheStore().loadAll(colKeys);
                }

                @Override
                protected Object unbundle(Object oKey) {
                    return CacheStoreWrapper.this.getCacheStore().load(oKey);
                }
            };
        }

        @Override
        public AbstractBundler instantiateStoreBundler() {
            return new AbstractEntryBundler(){

                @Override
                protected void bundle(Map map) {
                    CacheStoreWrapper.this.getCacheStore().storeAll(map);
                }
            };
        }

        @Override
        public AbstractBundler instantiateEraseBundler() {
            return new AbstractKeyBundler(){

                @Override
                protected Map bundle(Collection colKeys) {
                    CacheStoreWrapper.this.getCacheStore().eraseAll(colKeys);
                    return null;
                }

                @Override
                protected Object unbundle(Object oKey) {
                    CacheStoreWrapper.this.getCacheStore().erase(oKey);
                    return null;
                }
            };
        }

        @Override
        protected Object loadInternal(Object binKey) {
            BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
            binKey = ctx.getKeyFromInternalConverter().convert(binKey);
            try {
                AbstractKeyBundler bundler = (AbstractKeyBundler)this.m_loadBundler;
                Object oValueReal = bundler == null ? this.getCacheStore().load(binKey) : bundler.process(binKey);
                return oValueReal == null ? null : ctx.getValueToInternalConverter().convert(oValueReal);
            }
            catch (RuntimeException e) {
                ++this.m_cLoadFailures;
                this.onLoadFailure(binKey, e);
                return null;
            }
        }

        @Override
        protected Map loadAllInternal(Set setBinKey) {
            BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
            ConverterCollections.ConverterCollection colKeysReal = ConverterCollections.getCollection(setBinKey, ctx.getKeyFromInternalConverter(), ctx.getKeyToInternalConverter());
            try {
                AbstractKeyBundler bundler = (AbstractKeyBundler)this.m_loadBundler;
                Map map = bundler == null ? this.getCacheStore().loadAll(colKeysReal) : bundler.processAll(colKeysReal);
                return ConverterCollections.getMap(map, ctx.getKeyToInternalConverter(), ctx.getKeyFromInternalConverter(), ctx.getValueToInternalConverter(), ctx.getValueFromInternalConverter());
            }
            catch (RuntimeException e) {
                ++this.m_cLoadFailures;
                this.onLoadAllFailure(colKeysReal, e);
                return Collections.EMPTY_MAP;
            }
        }

        @Override
        protected void storeInternal(Entry binEntry) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            Object oKey = binEntry.getKey();
            Object oValue = binEntry.getValue();
            AbstractEntryBundler bundler = (AbstractEntryBundler)this.m_storeBundler;
            if (bundler == null) {
                this.getCacheStore().store(oKey, oValue);
            } else {
                bundler.process(oKey, oValue);
            }
        }

        @Override
        protected void storeAllInternal(Set setBinEntries) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            EntrySetMap mapEntries = new EntrySetMap(setBinEntries);
            AbstractEntryBundler bundler = (AbstractEntryBundler)this.m_storeBundler;
            if (bundler == null) {
                this.getCacheStore().storeAll(mapEntries);
            } else {
                bundler.processAll(mapEntries);
            }
        }

        @Override
        protected void eraseInternal(Entry binEntry) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            Object oKey = binEntry.getKey();
            AbstractKeyBundler bundler = (AbstractKeyBundler)this.m_eraseBundler;
            if (bundler == null) {
                this.getCacheStore().erase(oKey);
            } else {
                bundler.process(oKey);
            }
        }

        @Override
        protected void eraseAllInternal(Set setBinEntries) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            Set colKeys = new EntrySetMap(setBinEntries).keySet();
            AbstractKeyBundler bundler = (AbstractKeyBundler)this.m_eraseBundler;
            if (bundler == null) {
                this.getCacheStore().eraseAll(colKeys);
            } else {
                bundler.processAll(colKeys);
            }
        }

        @Override
        public Object getStore() {
            return this.getCacheStore();
        }

        public CacheStore getCacheStore() {
            return this.m_store;
        }

        public String toString() {
            return "CacheStoreWrapper(" + this.m_store.getClass().getName() + ')';
        }
    }

    public abstract class StoreWrapper
    extends Base {
        protected volatile long m_cLoadOps;
        protected volatile long m_cLoadFailures;
        protected volatile long m_cLoadMillis;
        protected volatile long m_cStoreOps;
        protected volatile long m_cStoreEntries;
        protected volatile long m_cStoreFailures;
        protected volatile long m_cStoreMillis;
        protected volatile long m_cEraseOps;
        protected volatile long m_cEraseFailures;
        protected volatile long m_cEraseMillis;
        protected boolean m_fStoreSupported = true;
        protected boolean m_fStoreAllSupported = true;
        protected boolean m_fEraseSupported = true;
        protected boolean m_fEraseAllSupported = true;
        protected AbstractBundler m_loadBundler;
        protected AbstractBundler m_storeBundler;
        protected AbstractBundler m_eraseBundler;

        public synchronized AbstractBundler ensureLoadBundler(int cBundleThreshold) {
            if (cBundleThreshold > 0) {
                AbstractBundler bundler = this.m_loadBundler;
                if (bundler == null) {
                    this.m_loadBundler = bundler = this.instantiateLoadBundler();
                }
                bundler.setSizeThreshold(cBundleThreshold);
                return bundler;
            }
            this.m_loadBundler = null;
            return null;
        }

        public synchronized AbstractBundler ensureStoreBundler(int cBundleThreshold) {
            if (cBundleThreshold > 0) {
                AbstractBundler bundler = this.m_storeBundler;
                if (bundler == null) {
                    this.m_storeBundler = bundler = this.instantiateStoreBundler();
                }
                bundler.setSizeThreshold(cBundleThreshold);
                return bundler;
            }
            this.m_storeBundler = null;
            return null;
        }

        public synchronized AbstractBundler ensureEraseBundler(int cBundleThreshold) {
            if (cBundleThreshold > 0) {
                AbstractBundler bundler = this.m_eraseBundler;
                if (bundler == null) {
                    this.m_eraseBundler = bundler = this.instantiateEraseBundler();
                }
                bundler.setSizeThreshold(cBundleThreshold);
                return bundler;
            }
            this.m_eraseBundler = null;
            return null;
        }

        public long getLoadOps() {
            return this.m_cLoadOps;
        }

        public long getLoadFailures() {
            return this.m_cLoadFailures;
        }

        public long getLoadMillis() {
            return this.m_cLoadMillis;
        }

        public long getStoreOps() {
            return this.m_cStoreOps;
        }

        public long getStoreFailures() {
            return this.m_cStoreFailures;
        }

        public long getStoreMillis() {
            return this.m_cStoreMillis;
        }

        public long getEraseOps() {
            return this.m_cEraseOps;
        }

        public long getEraseFailures() {
            return this.m_cEraseFailures;
        }

        public long getEraseMillis() {
            return this.m_cEraseMillis;
        }

        public long getAverageBatchSize() {
            long cOps = this.m_cStoreOps;
            return cOps > 0L ? this.m_cStoreEntries / cOps : 0L;
        }

        public long getAverageLoadMillis() {
            long cOps = this.m_cLoadOps;
            return cOps > 0L ? this.m_cLoadMillis / cOps : 0L;
        }

        public long getAverageStoreMillis() {
            long cOps = this.m_cStoreOps;
            return cOps > 0L ? this.m_cStoreMillis / cOps : 0L;
        }

        public long getAverageEraseMillis() {
            long cOps = this.m_cEraseOps;
            return cOps > 0L ? this.m_cEraseMillis / cOps : 0L;
        }

        public void resetStatistics() {
            this.m_cLoadOps = 0L;
            this.m_cLoadFailures = 0L;
            this.m_cLoadMillis = 0L;
            this.m_cStoreOps = 0L;
            this.m_cStoreEntries = 0L;
            this.m_cStoreFailures = 0L;
            this.m_cStoreMillis = 0L;
            this.m_cEraseOps = 0L;
            this.m_cEraseFailures = 0L;
            this.m_cEraseMillis = 0L;
        }

        public AbstractBundler getLoadBundler() {
            return this.m_loadBundler;
        }

        public AbstractBundler getStoreBundler() {
            return this.m_storeBundler;
        }

        public AbstractBundler getEraseBundler() {
            return this.m_eraseBundler;
        }

        public boolean isStoreSupported() {
            return this.m_fStoreSupported;
        }

        public void setStoreSupported(boolean fSupported) {
            this.m_fStoreSupported = fSupported;
        }

        public boolean isStoreAllSupported() {
            return this.m_fStoreAllSupported;
        }

        public void setStoreAllSupported(boolean fSupported) {
            this.m_fStoreAllSupported = fSupported;
        }

        public boolean isEraseSupported() {
            return this.m_fEraseSupported;
        }

        public void setEraseSupported(boolean fSupported) {
            this.m_fEraseSupported = fSupported;
        }

        public boolean isEraseAllSupported() {
            return this.m_fEraseAllSupported;
        }

        public void setEraseAllSupported(boolean fSupported) {
            this.m_fEraseAllSupported = fSupported;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object load(Object binKey) {
            ReadWriteBackingMap.this.heartbeat();
            long lStart = StoreWrapper.getSafeTimeMillis();
            try {
                Object object = this.loadInternal(binKey);
                return object;
            }
            finally {
                ++this.m_cLoadOps;
                long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cLoadMillis += lElapsed;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map loadAll(Set setBinKey) {
            ReadWriteBackingMap.this.heartbeat();
            long lStart = StoreWrapper.getSafeTimeMillis();
            try {
                Map map = this.loadAllInternal(setBinKey);
                return map;
            }
            finally {
                ++this.m_cLoadOps;
                long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cLoadMillis += lElapsed;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void store(Entry binEntry, boolean fAllowChange) {
            boolean fAsynch;
            ReadWriteBackingMap.this.heartbeat();
            long lStart = StoreWrapper.getSafeTimeMillis();
            boolean fSuccess = true;
            try {
                this.storeInternal(binEntry);
            }
            catch (RuntimeException e) {
                fSuccess = false;
                ++this.m_cStoreFailures;
                this.onStoreFailure(binEntry, e);
            }
            finally {
                ++this.m_cStoreOps;
                ++this.m_cStoreEntries;
                long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cStoreMillis += lElapsed;
                }
                binEntry.stopTracking();
            }
            boolean bl = fAsynch = ReadWriteBackingMap.this.getWriteQueue() != null;
            if (fAllowChange && (binEntry.isChanged() || fAsynch && fSuccess)) {
                this.replace(binEntry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void storeAll(Set setBinEntries) {
            int cEntries = setBinEntries.size();
            if (cEntries == 0) {
                return;
            }
            ReadWriteBackingMap.this.heartbeat();
            boolean fAsynch = ReadWriteBackingMap.this.getWriteQueue() != null;
            HashSet setAll = setBinEntries;
            if (fAsynch) {
                setAll = new HashSet(setBinEntries);
            }
            long lStart = StoreWrapper.getSafeTimeMillis();
            boolean fSuccess = true;
            try {
                this.storeAllInternal(setBinEntries);
            }
            catch (RuntimeException e) {
                fSuccess = false;
                ++this.m_cStoreFailures;
                this.onStoreAllFailure(setBinEntries, e);
            }
            finally {
                ++this.m_cStoreOps;
                this.m_cStoreEntries += (long)cEntries;
                long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cStoreMillis += lElapsed;
                }
            }
            for (Entry entry : setAll) {
                entry.stopTracking();
                if (!entry.isChanged() && (!fAsynch || !fSuccess && setBinEntries.contains(entry))) continue;
                this.replace(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void erase(Entry binEntry) {
            ReadWriteBackingMap.this.heartbeat();
            long lStart = StoreWrapper.getSafeTimeMillis();
            try {
                this.eraseInternal(binEntry);
            }
            catch (RuntimeException e) {
                ++this.m_cEraseFailures;
                this.onEraseFailure(binEntry.getKey(), e);
            }
            finally {
                ++this.m_cEraseOps;
                long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cEraseMillis += lElapsed;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void eraseAll(Set setBinEntries) {
            ReadWriteBackingMap.this.heartbeat();
            long lStart = StoreWrapper.getSafeTimeMillis();
            try {
                this.eraseAllInternal(setBinEntries);
            }
            catch (RuntimeException e) {
                ++this.m_cEraseFailures;
                this.onEraseAllFailure(setBinEntries, e);
            }
            finally {
                ++this.m_cEraseOps;
                long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cEraseMillis += lElapsed;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void replace(Entry entry) {
            boolean fSync;
            ObservableMap mapInternal = ReadWriteBackingMap.this.getInternalCache();
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            Binary binKey = entry.getBinaryKey();
            boolean bl = fSync = ReadWriteBackingMap.this.getWriteQueue() == null;
            if (fSync || mapControl.lock(binKey, 50L)) {
                try {
                    Object binValue = entry.getBinaryValue();
                    if (Base.equals(binValue, mapInternal.get(binKey))) {
                        binValue = entry.isChanged() ? (entry.isRemoved() ? null : entry.getChangedBinaryValue()) : ExternalizableHelper.undecorate((Binary)binValue, 2);
                        if (binValue == null) {
                            mapInternal.remove(binKey);
                        } else if (mapInternal instanceof CacheMap) {
                            ((CacheMap)mapInternal).put(binKey, binValue, ReadWriteBackingMap.this.extractExpiry(entry));
                        } else {
                            mapInternal.put(binKey, binValue);
                        }
                    }
                }
                catch (RuntimeException e) {
                }
                finally {
                    if (!fSync) {
                        mapControl.unlock(binKey);
                    }
                }
            }
        }

        protected void onLoadFailure(Object oKeyReal, Exception e) {
            if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                throw StoreWrapper.ensureRuntimeException(e, "Failed to load key=\"" + oKeyReal + "\"");
            }
            StoreWrapper.err("Failed to load key=\"" + oKeyReal + "\":");
            StoreWrapper.err(e);
        }

        protected void onLoadAllFailure(Collection colKeys, Exception e) {
            if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                throw StoreWrapper.ensureRuntimeException(e, "Failed to load keys=\"" + colKeys + "\"");
            }
            StoreWrapper.err("Failed to load keys=\"" + colKeys + "\":");
            StoreWrapper.err(e);
        }

        protected void onStoreFailure(Entry entry, Exception e) {
            WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
            WriteThread writeThread = ReadWriteBackingMap.this.getWriteThread();
            int cThreshold = ReadWriteBackingMap.this.getWriteRequeueThreshold();
            if (e instanceof UnsupportedOperationException) {
                if (this.isStoreSupported()) {
                    this.setStoreSupported(false);
                    this.reportUnsupported("store");
                }
                cThreshold = Integer.MAX_VALUE;
            }
            String sMsg = "Failed to store key=\"" + entry.getKey() + "\"";
            if (queue == null || Thread.currentThread() != writeThread.getThread()) {
                if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                    throw StoreWrapper.ensureRuntimeException(e, sMsg);
                }
                StoreWrapper.err(sMsg);
                StoreWrapper.err(e);
            } else {
                StoreWrapper.err(sMsg);
                StoreWrapper.err(e);
                if (cThreshold != 0) {
                    this.requeue(queue, cThreshold, entry);
                }
            }
        }

        protected void onStoreAllFailure(Set setBinEntries, Exception e) {
            WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
            WriteThread writeThread = ReadWriteBackingMap.this.getWriteThread();
            int cThreshold = ReadWriteBackingMap.this.getWriteRequeueThreshold();
            if (e instanceof UnsupportedOperationException) {
                if (this.isStoreAllSupported()) {
                    this.setStoreAllSupported(false);
                    this.reportUnsupported("storeAll");
                }
                cThreshold = Integer.MAX_VALUE;
            }
            String sMsg = this.formatKeys(setBinEntries, "Failed to store");
            if (queue == null || Thread.currentThread() != writeThread.getThread()) {
                if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                    throw StoreWrapper.ensureRuntimeException(e, sMsg);
                }
                StoreWrapper.err(sMsg);
                StoreWrapper.err(e);
            } else {
                StoreWrapper.err(sMsg);
                StoreWrapper.err(e);
                if (cThreshold != 0) {
                    for (Entry entry : setBinEntries) {
                        this.requeue(queue, cThreshold, entry);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean requeue(WriteQueue queue, int cThreshold, Entry entry) {
            WriteQueue writeQueue = queue;
            synchronized (writeQueue) {
                BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
                Binary binKey = entry.getBinaryKey();
                if (!queue.containsKey(binKey) && ctx.isKeyOwned(binKey)) {
                    long ldtDelay = this.calculateRequeueDelay(queue);
                    queue.add(entry, ldtDelay);
                }
            }
            return true;
        }

        protected long calculateRequeueDelay(WriteQueue queue) {
            return Math.max(ReadWriteBackingMap.this.getWriteBehindMillis() * 2L, MIN_REQUEUE_DELAY);
        }

        protected void onEraseFailure(Object oKeyReal, Exception e) {
            if (e instanceof UnsupportedOperationException) {
                if (this.isEraseSupported()) {
                    this.setEraseSupported(false);
                    this.reportUnsupported("erase");
                }
            } else {
                String sMsg = "Failed to erase key=\"" + oKeyReal + "\"";
                if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                    throw StoreWrapper.ensureRuntimeException(e, sMsg);
                }
                StoreWrapper.err(sMsg);
                StoreWrapper.err(e);
            }
        }

        protected void onEraseAllFailure(Set setBinEntries, Exception e) {
            if (e instanceof UnsupportedOperationException) {
                if (this.isEraseAllSupported()) {
                    this.setEraseAllSupported(false);
                    this.reportUnsupported("eraseAll");
                }
            } else {
                String sMsg = this.formatKeys(setBinEntries, "Failed to erase");
                if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                    throw StoreWrapper.ensureRuntimeException(e, sMsg);
                }
                StoreWrapper.err(sMsg);
                StoreWrapper.err(e);
            }
        }

        protected void reportUnsupported(String sOp) {
            StoreWrapper.log("The cache store \"" + this.getStore() + "\" does not support the" + sOp + " operation.");
        }

        protected String formatKeys(Set setBinEntries, String sHeader) {
            StringBuilder sb = new StringBuilder();
            sb.append(sHeader).append(" keys=\"");
            Iterator iterEntries = setBinEntries.iterator();
            while (iterEntries.hasNext()) {
                sb.append(((Entry)iterEntries.next()).getKey()).append(", ");
            }
            sb.append('\"');
            return sb.toString();
        }

        public abstract Object getStore();

        protected abstract AbstractBundler instantiateLoadBundler();

        protected abstract AbstractBundler instantiateStoreBundler();

        protected abstract AbstractBundler instantiateEraseBundler();

        protected abstract Object loadInternal(Object var1);

        protected abstract Map loadAllInternal(Set var1);

        protected abstract void storeInternal(Entry var1);

        protected abstract void storeAllInternal(Set var1);

        protected abstract void eraseInternal(Entry var1);

        protected abstract void eraseAllInternal(Set var1);
    }

    public class WriteThread
    extends Daemon {
        protected volatile boolean m_fRefreshContext;

        public WriteThread() {
            super("WriteBehindThread:" + ReadWriteBackingMap.this.getCacheStore() + (ReadWriteBackingMap.this.getCacheService() == null ? "" : ":" + ReadWriteBackingMap.this.getCacheService().getInfo().getServiceName()), 5, false);
            this.m_fRefreshContext = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (ReadWriteBackingMap.this.isActive() && !this.isStopping()) {
                    WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
                    StoreWrapper store = ReadWriteBackingMap.this.getCacheStore();
                    long cWait = this.getMaxWaitMillis(1000L);
                    if (this.m_fRefreshContext) {
                        GuardSupport.setThreadContext(this.getContext());
                        this.m_fRefreshContext = false;
                    }
                    if (queue == null || store == null) continue;
                    try {
                        this.heartbeat();
                        Entry entry = queue.remove(cWait);
                        if (entry == null) continue;
                        if (store.isStoreAllSupported()) {
                            Entry entryFirst = null;
                            LinkedHashSet<Entry> setEntries = null;
                            int cEntries = 0;
                            int cMaxEntries = ReadWriteBackingMap.this.getWriteMaxBatchSize();
                            while (entry != null) {
                                if (entry.getBinaryValue() != NO_VALUE) {
                                    switch (cEntries) {
                                        case 0: {
                                            entryFirst = entry;
                                            break;
                                        }
                                        case 1: {
                                            setEntries = new LinkedHashSet<Entry>();
                                            setEntries.add(entryFirst);
                                        }
                                        default: {
                                            setEntries.add(entry);
                                        }
                                    }
                                    if (++cEntries >= cMaxEntries) break;
                                }
                                entry = queue.removeNoWait();
                            }
                            switch (cEntries) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    store.store(entryFirst, true);
                                    break;
                                }
                                default: {
                                    store.storeAll(setEntries);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (entry.getBinaryValue() == NO_VALUE) continue;
                        store.store(entry, true);
                    }
                    catch (Throwable e) {
                        WriteThread.err("An exception occurred on the write-behind thread");
                        WriteThread.err(e);
                        WriteThread.err("(The exception will be ignored. The write-behind thread will continue.)");
                        Thread.interrupted();
                    }
                    finally {
                        queue.clearPending();
                    }
                }
            }
            finally {
                ReadWriteBackingMap.this.terminateWriteThread();
            }
        }

        @Override
        public void terminate() {
            WriteThread.err("The write-behind thread timed out.  This could be indicative of an extremely slow-running or hung CacheStore call, or deadlock.");
            GuardSupport.logStackTraces();
            this.setGuardPolicy((Guardian)((Object)ReadWriteBackingMap.this.getContext().getCacheService()), ReadWriteBackingMap.this.getCacheStoreTimeoutMillis(), 0.9f);
        }

        @Override
        protected void setGuardPolicy(Guardian guardian, long cTimeoutMillis, float flPctRecover) {
            super.setGuardPolicy(guardian, cTimeoutMillis, flPctRecover);
        }
    }

    public class ReadThread
    extends Daemon {
        protected volatile boolean m_fRefreshContext;

        public ReadThread() {
            super("ReadThread:" + ReadWriteBackingMap.this.getCacheStore() + (ReadWriteBackingMap.this.getCacheService() == null ? "" : ":" + ReadWriteBackingMap.this.getCacheService().getInfo().getServiceName()), 5, false);
            this.m_fRefreshContext = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            ReadQueue queue = ReadWriteBackingMap.this.getReadQueue();
            long cWaitMillis = this.getMaxWaitMillis(1000L);
            try {
                while (ReadWriteBackingMap.this.isActive() && !this.isStopping()) {
                    StoreWrapper store;
                    if (this.m_fRefreshContext) {
                        GuardSupport.setThreadContext(this.getContext());
                        this.m_fRefreshContext = false;
                    }
                    if ((store = ReadWriteBackingMap.this.getCacheStore()) == null) continue;
                    this.heartbeat();
                    ReadLatch latch = queue.select(cWaitMillis);
                    if (latch == null) continue;
                    Object oKey = latch.getKey();
                    Object oValue = null;
                    Throwable exception = null;
                    try {
                        if (ReadWriteBackingMap.this.getContext().isKeyOwned(oKey)) {
                            oValue = store.load(oKey);
                        }
                    }
                    catch (Throwable e) {
                        exception = e;
                    }
                    if (mapControl.lock(oKey, 0L)) {
                        try {
                            if (exception != null || latch.isCanceled() || !ReadWriteBackingMap.this.getContext().isKeyOwned(oKey)) continue;
                            ReadWriteBackingMap.this.putToInternalCache(oKey, oValue);
                            continue;
                        }
                        finally {
                            mapControl.remove(oKey);
                            mapControl.unlock(oKey);
                            continue;
                        }
                    }
                    if (exception == null) {
                        latch.complete(oValue);
                        continue;
                    }
                    latch.cancel(exception);
                }
            }
            finally {
                ReadWriteBackingMap.this.terminateReadThread();
            }
        }

        @Override
        public void terminate() {
            ReadThread.err("The refresh-ahead thread timed out.  This could be indicative of an extremely slow-running or hung CacheStore call, or deadlock.");
            GuardSupport.logStackTraces();
            this.setGuardPolicy((Guardian)((Object)ReadWriteBackingMap.this.getContext().getCacheService()), ReadWriteBackingMap.this.getCacheStoreTimeoutMillis(), 0.9f);
        }

        @Override
        protected void setGuardPolicy(Guardian guardian, long cTimeoutMillis, float flPctRecover) {
            super.setGuardPolicy(guardian, cTimeoutMillis, flPctRecover);
        }
    }

    public class WriteQueue
    extends CoherenceApplicationEdition {
        private Map m_mapQueued = new SafeHashMap();
        private LongArray m_arrQueue = new SparseArray();
        private Map m_mapPending = new HashMap();
        private long m_cDelayMillis = 60000L;

        protected WriteQueue() {
        }

        public int getDelaySeconds() {
            long cMillis = this.getDelayMillis();
            return cMillis == 0L ? 0 : Math.max(1, (int)(cMillis / 1000L));
        }

        public void setDelaySeconds(int cSeconds) {
            this.setDelayMillis(1000L * (long)cSeconds);
        }

        public long getDelayMillis() {
            return this.m_cDelayMillis;
        }

        public synchronized void setDelayMillis(long cMillis) {
            this.m_cDelayMillis = Math.max(1L, cMillis);
            this.notify();
        }

        protected synchronized Entry add(Entry entryNew, long cDelay) {
            Binary binKey;
            Map map = this.getEntryMap();
            Entry entry = (Entry)map.get(binKey = entryNew.getBinaryKey());
            if (entry == null) {
                List listKeys;
                long ldtLast;
                LongArray arrayRipe = this.getRipeArray();
                boolean fWasEmpty = arrayRipe.isEmpty();
                long ldtRipe = WriteQueue.getSafeTimeMillis() + Math.max(this.getDelayMillis(), cDelay);
                if (!fWasEmpty && (ldtLast = arrayRipe.getLastIndex()) > ldtRipe) {
                    int cThreshold = ReadWriteBackingMap.this.getWriteRequeueThreshold();
                    int cSize = this.size();
                    if (cThreshold > 0 && cSize % cThreshold == 0) {
                        WriteQueue.log("Due to requeuing after store failures, the queue size reached " + cSize + " entries and runs behind the schedule by " + (ldtLast - ldtRipe) + " ms.");
                    }
                    ldtRipe = ldtLast;
                }
                if (arrayRipe.exists(ldtRipe)) {
                    listKeys = (List)arrayRipe.get(ldtRipe);
                } else {
                    listKeys = new InflatableList();
                    arrayRipe.set(ldtRipe, listKeys);
                }
                entryNew.setRipeMillis(ldtRipe);
                map.put(binKey, entryNew);
                listKeys.add(binKey);
                if (fWasEmpty) {
                    this.notify();
                }
                return entryNew;
            }
            Binary binValueNew = entryNew.getBinaryValue();
            Binary binValueOrig = entry.getOriginalBinaryValue();
            if (binValueNew == NO_VALUE || binValueOrig == NO_VALUE) {
                map.put(binKey, entryNew);
                return binValueOrig == NO_VALUE ? null : entry;
            }
            entry.updateBinaryValue(binValueNew);
            return entry;
        }

        protected synchronized Entry remove(Object binKey) {
            long lIndex;
            LongArray arrayRipe;
            List listKeys;
            Entry entry = (Entry)this.getEntryMap().remove(binKey);
            if (entry != null && (listKeys = (List)(arrayRipe = this.getRipeArray()).get(lIndex = entry.getRipeMillis())) != null) {
                listKeys.remove(binKey);
                if (listKeys.isEmpty()) {
                    arrayRipe.remove(lIndex);
                }
            }
            return entry;
        }

        protected synchronized Entry removeImmediate() {
            long lIndex;
            List listKeys;
            if (!ReadWriteBackingMap.this.isActive()) {
                return null;
            }
            LongArray arrayRipe = this.getRipeArray();
            if (!arrayRipe.isEmpty() && (listKeys = (List)arrayRipe.get(lIndex = arrayRipe.getFirstIndex())).size() > 0) {
                Object oKey = listKeys.remove(0);
                if (listKeys.isEmpty()) {
                    arrayRipe.remove(lIndex);
                }
                return (Entry)this.getEntryMap().remove(oKey);
            }
            return null;
        }

        public Entry remove() {
            return this.remove(-1L);
        }

        public synchronized Entry remove(long cMillis) {
            LongArray arrayRipe = this.getRipeArray();
            while (ReadWriteBackingMap.this.isActive()) {
                long cWait;
                long ldtNow = WriteQueue.getSafeTimeMillis();
                long lIndex = arrayRipe.getFirstIndex();
                if (lIndex > 0L && lIndex <= ldtNow) {
                    List listKeys = (List)arrayRipe.get(lIndex);
                    if (listKeys.size() > 0) {
                        Object oKey = listKeys.remove(0);
                        Entry entry = (Entry)this.getEntryMap().remove(oKey);
                        if (listKeys.size() == 0) {
                            arrayRipe.remove(lIndex);
                        }
                        this.getPendingMap().put(oKey, entry.getBinaryValue());
                        return entry;
                    }
                    arrayRipe.remove(lIndex);
                    continue;
                }
                if (cMillis == 0L) {
                    return null;
                }
                long l = cWait = cMillis <= 0L || cMillis > 1000L ? 1000L : cMillis;
                if (lIndex > ldtNow) {
                    cWait = Math.min(cWait, lIndex - ldtNow);
                }
                ReadWriteBackingMap.this.waitFor(this, cWait);
                if (cMillis <= 0L) continue;
                cMillis = Math.max(0L, cMillis - cWait);
            }
            return null;
        }

        public synchronized Entry removeNoWait() {
            List listKeys;
            long lIndex;
            LongArray arrayRipe;
            if (ReadWriteBackingMap.this.isActive() && !(arrayRipe = this.getRipeArray()).isEmpty() && (lIndex = arrayRipe.getFirstIndex()) <= WriteQueue.getSafeTimeMillis() + (long)(ReadWriteBackingMap.this.getWriteBatchFactor() * (double)ReadWriteBackingMap.this.getWriteBehindSeconds() * 1000.0) && (listKeys = (List)arrayRipe.get(lIndex)).size() > 0) {
                Object binKey = listKeys.remove(0);
                Entry entry = (Entry)this.getEntryMap().remove(binKey);
                if (listKeys.isEmpty()) {
                    arrayRipe.remove(lIndex);
                }
                this.getPendingMap().put(binKey, entry.getBinaryValue());
                return entry;
            }
            return null;
        }

        public int size() {
            return this.getEntryMap().size();
        }

        public boolean isEmpty() {
            return this.getEntryMap().isEmpty();
        }

        public boolean containsKey(Object binKey) {
            return this.getEntryMap().containsKey(binKey);
        }

        public synchronized Object checkPending(Object binKey) {
            Entry entry = (Entry)this.getEntryMap().get(binKey);
            Binary binValue = entry == null ? this.getPendingMap().get(binKey) : entry.getBinaryValue();
            return binValue == NO_VALUE ? null : binValue;
        }

        public synchronized void clearPending() {
            this.getPendingMap().clear();
        }

        protected Map getEntryMap() {
            return this.m_mapQueued;
        }

        protected LongArray getRipeArray() {
            return this.m_arrQueue;
        }

        protected Map getPendingMap() {
            return this.m_mapPending;
        }
    }

    public class Entry
    extends BackingMapBinaryEntry {
        private long m_ldtRipeMillis;
        private boolean m_fTrackChanges;
        private Binary m_binChangedValue;

        public Entry(Binary binKey, Binary binValue, Binary binValueOrig, BackingMapManagerContext ctx) {
            super(binKey, binValue, binValueOrig, ctx);
        }

        @Override
        public Object setValue(Object oValue) {
            if (this.m_fTrackChanges) {
                this.m_binChangedValue = (Binary)this.getContext().getValueToInternalConverter().convert(oValue);
                return null;
            }
            return super.setValue(oValue);
        }

        @Override
        public void updateBinaryValue(Binary binValue) {
            if (this.m_fTrackChanges) {
                this.m_binChangedValue = binValue == null ? NO_VALUE : binValue;
            } else {
                super.updateBinaryValue(binValue);
            }
        }

        @Override
        public ObservableMap getBackingMap() {
            return ReadWriteBackingMap.this;
        }

        @Override
        public void expire(long cMillis) {
            if (this.m_fTrackChanges && cMillis != this.getExpiryDelay()) {
                this.m_binChangedValue = this.getBinaryValue();
            }
            super.expire(cMillis);
        }

        public long getRipeMillis() {
            return this.m_ldtRipeMillis;
        }

        protected void setRipeMillis(long ldtMillis) {
            this.m_ldtRipeMillis = ldtMillis;
        }

        public boolean isChanged() {
            return this.m_binChangedValue != null;
        }

        public boolean isRemoved() {
            return this.m_binChangedValue == NO_VALUE;
        }

        public Binary getChangedBinaryValue() {
            return this.m_binChangedValue;
        }

        protected void startTracking() {
            this.m_fTrackChanges = true;
        }

        protected void stopTracking() {
            this.m_fTrackChanges = false;
        }
    }

    public class ReadQueue
    extends CoherenceApplicationEdition {
        private List m_listQueued = new RecyclingLinkedList();
        private Map m_mapQueued = new HashMap();

        protected ReadQueue() {
        }

        public synchronized boolean add(Object oKey) {
            Map map = this.getKeyMap();
            if (map.get(oKey) == null) {
                map.put(oKey, oKey);
                List list = this.getKeyList();
                boolean fWasEmpty = list.isEmpty();
                list.add(oKey);
                if (fWasEmpty) {
                    this.notify();
                }
                return true;
            }
            return false;
        }

        public Object peek() {
            return this.peek(-1L);
        }

        public synchronized Object peek(long cMillis) {
            List list = this.getKeyList();
            while (ReadWriteBackingMap.this.isActive()) {
                if (!list.isEmpty()) {
                    return list.get(0);
                }
                if (cMillis == 0L) {
                    return null;
                }
                long cWait = cMillis < 0L || cMillis > 1000L ? 1000L : cMillis;
                ReadWriteBackingMap.this.waitFor(this, cWait);
                if (cMillis <= 0L) continue;
                cMillis = Math.max(0L, cMillis - cWait);
            }
            return null;
        }

        public synchronized boolean remove(Object oKey) {
            if (this.getKeyMap().remove(oKey) != null) {
                this.getKeyList().remove(oKey);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ReadLatch select(long cWaitMillis) {
            Object oKey;
            List listKeys = this.getKeyList();
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            if (cWaitMillis == -1L) {
                oKey = this.peek(-1L);
            } else {
                long ldtStart = System.currentTimeMillis();
                oKey = this.peek(cWaitMillis);
                cWaitMillis -= Math.max(0L, System.currentTimeMillis() - ldtStart);
            }
            if (oKey == null) {
                return null;
            }
            do {
                long cWaitLatch = 0L;
                int index = 0;
                while (oKey != null) {
                    boolean fRemoved = false;
                    if (mapControl.lock(oKey, cWaitLatch)) {
                        try {
                            if (this.remove(oKey)) {
                                ReadLatch latch = ReadWriteBackingMap.this.instantiateReadLatch(oKey);
                                mapControl.put(oKey, latch);
                                ReadLatch readLatch = latch;
                                return readLatch;
                            }
                            fRemoved = true;
                        }
                        finally {
                            mapControl.unlock(oKey);
                        }
                    }
                    if ((cWaitMillis -= cWaitLatch) < 0L) break;
                    try {
                        oKey = listKeys.get(fRemoved ? index : ++index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        break;
                    }
                }
                cWaitLatch += 10L;
            } while (cWaitMillis != 0L);
            return null;
        }

        public synchronized void clear() {
            this.getKeyMap().clear();
            this.getKeyList().clear();
        }

        @Override
        public String toString() {
            return "ReadQueue: " + this.getKeyList();
        }

        protected List getKeyList() {
            return this.m_listQueued;
        }

        protected Map getKeyMap() {
            return this.m_mapQueued;
        }
    }

    protected static class ReadLatch {
        private Object m_oKey;
        private Object m_oValue;
        private boolean m_fComplete;
        private boolean m_fCanceled;
        private Throwable m_throwable;

        protected ReadLatch(Object oKey) {
            this.m_oKey = oKey;
        }

        public synchronized void cancel() {
            this.cancel(null);
        }

        public synchronized void cancel(Throwable t) {
            if (!this.m_fCanceled && !this.m_fComplete) {
                this.m_oValue = null;
                this.m_throwable = t;
                this.m_fCanceled = true;
                this.m_fComplete = true;
                this.notifyAll();
            }
        }

        public synchronized void complete(Object oValue) {
            if (!this.m_fCanceled && !this.m_fComplete) {
                this.m_oValue = oValue;
                this.m_fComplete = true;
                this.notifyAll();
            }
        }

        public boolean isComplete() {
            return this.m_fComplete;
        }

        public boolean isCanceled() {
            return this.m_fCanceled;
        }

        public Object getKey() {
            return this.m_oKey;
        }

        public synchronized Object getValue() {
            Throwable throwable = this.m_throwable;
            if (throwable != null && this.m_fCanceled) {
                throw new WrapperException(throwable);
            }
            return this.m_oValue;
        }
    }

    protected class InternalMapListener
    extends Base
    implements MapListener {
        private Map m_mapIgnore = new SafeHashMap();

        protected InternalMapListener() {
        }

        @Override
        public void entryInserted(MapEvent evt) {
            MapListenerSupport support = ReadWriteBackingMap.this.m_listenerSupport;
            if (support != null && !this.getIgnoreMap().containsKey(evt.getKey())) {
                this.dispatch(evt);
            }
        }

        @Override
        public void entryUpdated(MapEvent evt) {
            MapListenerSupport support = ReadWriteBackingMap.this.m_listenerSupport;
            if (support != null && !this.getIgnoreMap().containsKey(evt.getKey())) {
                this.dispatch(evt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entryDeleted(MapEvent evt) {
            Object oKey;
            Map mapIgnore = this.getIgnoreMap();
            if (mapIgnore.containsKey(oKey = evt.getKey())) {
                return;
            }
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            if (mapControl.lock(oKey, 500L)) {
                try {
                    if (ReadWriteBackingMap.this.getContext().isKeyOwned(oKey)) {
                        this.processDeletedEntry(oKey, evt.getOldValue());
                    }
                    this.dispatch(evt);
                }
                finally {
                    mapControl.unlock(oKey);
                }
            }
            mapIgnore.put(oKey, Thread.currentThread());
            try {
                Object oValueOld = evt.getOldValue();
                Object oValue = ReadWriteBackingMap.this.getInternalCache().put(oKey, oValueOld);
                if (oValue != null && !InternalMapListener.equals(oValue, oValueOld)) {
                    String sCulprit = ReadWriteBackingMap.this.getCacheStore() == null ? "backing map" : "cache store";
                    InternalMapListener.err("Due to an exceptionally long " + sCulprit + " operation an eviction event cannot be processed" + " in order. Canceling the eviction: " + evt);
                }
            }
            finally {
                mapIgnore.remove(oKey);
            }
        }

        protected void processDeletedEntry(Object oKey, Object oValueOld) {
            Entry entry;
            StoreWrapper store = ReadWriteBackingMap.this.getCacheStore();
            if (store != null && !ReadWriteBackingMap.this.isReadOnly() && (entry = ReadWriteBackingMap.this.removeFromWriteQueue(oKey)) != null && entry.getBinaryValue() != NO_VALUE) {
                try {
                    store.store(entry, false);
                }
                catch (WrapperException e) {
                    InternalMapListener.log(e);
                }
            }
        }

        protected void dispatch(final MapEvent evt) {
            MapListenerSupport support = ReadWriteBackingMap.this.m_listenerSupport;
            if (support != null) {
                Object oKey = evt.getKey();
                boolean fSynthetic = evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic() || ReadWriteBackingMap.this.getSyntheticEventsMap().containsKey(oKey);
                CacheEvent evtNew = new CacheEvent(ReadWriteBackingMap.this, evt.getId(), oKey, null, null, fSynthetic){

                    @Override
                    public Object getOldValue() {
                        return evt.getOldValue();
                    }

                    @Override
                    public Object getNewValue() {
                        return evt.getNewValue();
                    }
                };
                support.fireEvent(evtNew, true);
            }
        }

        protected Map getIgnoreMap() {
            return this.m_mapIgnore;
        }
    }

    protected class ValuesCollection
    extends AbstractCollection {
        protected ValuesCollection() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator m_iter;
                {
                    this.m_iter = ReadWriteBackingMap.this.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    return ReadWriteBackingMap.this.get(this.m_iter.next());
                }

                @Override
                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        @Override
        public int size() {
            return ReadWriteBackingMap.this.size();
        }

        @Override
        public void clear() {
            ReadWriteBackingMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return ReadWriteBackingMap.this.getInternalCache().values().toArray();
        }

        @Override
        public Object[] toArray(Object[] ao) {
            return ReadWriteBackingMap.this.getInternalCache().values().toArray(ao);
        }
    }

    protected class KeySet
    extends AbstractSet {
        protected KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator m_iter;
                private Object m_oKeyPrev;
                {
                    this.m_iter = ReadWriteBackingMap.this.getInternalCache().keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    Object oKey = this.m_iter.next();
                    this.m_oKeyPrev = oKey;
                    return oKey;
                }

                @Override
                public void remove() {
                    if (this.m_oKeyPrev == null) {
                        throw new IllegalStateException();
                    }
                    ReadWriteBackingMap.this.removeInternal(this.m_oKeyPrev, true);
                    this.m_oKeyPrev = null;
                }
            };
        }

        @Override
        public int size() {
            return ReadWriteBackingMap.this.size();
        }

        @Override
        public boolean contains(Object oKey) {
            return ReadWriteBackingMap.this.containsKey(oKey);
        }

        @Override
        public boolean remove(Object o) {
            ReadWriteBackingMap map = ReadWriteBackingMap.this;
            boolean fExists = map.containsKey(o);
            map.removeInternal(o, true);
            return fExists;
        }

        @Override
        public void clear() {
            ReadWriteBackingMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return ReadWriteBackingMap.this.getInternalCache().keySet().toArray();
        }

        @Override
        public Object[] toArray(Object[] ao) {
            return ReadWriteBackingMap.this.getInternalCache().keySet().toArray(ao);
        }
    }

    protected class EntrySet
    extends AbstractSet {
        protected EntrySet() {
        }

        @Override
        public Iterator iterator() {
            if (ReadWriteBackingMap.this.isEmpty()) {
                return NullImplementation.getIterator();
            }
            return new SimpleEnumerator(ReadWriteBackingMap.this.getInternalCache().keySet().toArray()){
                private Map.Entry m_entryPrev;

                @Override
                public Object next() {
                    this.m_entryPrev = EntrySet.this.instantiateEntry(super.next());
                    return this.m_entryPrev;
                }

                @Override
                public void remove() {
                    if (this.m_entryPrev == null) {
                        throw new IllegalStateException();
                    }
                    ReadWriteBackingMap.this.removeInternal(this.m_entryPrev.getKey(), true);
                    this.m_entryPrev = null;
                }
            };
        }

        @Override
        public int size() {
            return ReadWriteBackingMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                ReadWriteBackingMap map = ReadWriteBackingMap.this;
                Map.Entry entry = (Map.Entry)o;
                Object oKey = entry.getKey();
                return map.containsKey(oKey) && Base.equals(entry.getValue(), map.get(oKey)) && map.containsKey(oKey);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            ReadWriteBackingMap map = ReadWriteBackingMap.this;
            Object oKey = ((Map.Entry)o).getKey();
            boolean fExists = map.containsKey(oKey);
            map.removeInternal(oKey, true);
            return fExists;
        }

        @Override
        public void clear() {
            ReadWriteBackingMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            Object[] aoKey = ReadWriteBackingMap.this.getInternalCache().keySet().toArray();
            int cKeys = aoKey.length;
            if (ao == null) {
                ao = new Object[cKeys];
            } else if (ao.length < cKeys) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cKeys);
            } else if (ao.length > cKeys) {
                ao[cKeys] = null;
            }
            for (int i = 0; i < cKeys; ++i) {
                ao[i] = this.instantiateEntry(aoKey[i]);
            }
            return ao;
        }

        protected Map.Entry instantiateEntry(Object oKey) {
            return new SimpleMapEntry(oKey){

                @Override
                public Object getValue() {
                    return ReadWriteBackingMap.this.get(this.getKey());
                }

                @Override
                public Object setValue(Object oValue) {
                    return ReadWriteBackingMap.this.put(this.getKey(), oValue);
                }
            };
        }
    }
}

