/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.BinaryStore;
import com.tangosol.net.cache.AbstractSerializationCache;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.OldCache;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.AbstractKeySetBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SerializationCache
extends AbstractSerializationCache
implements CacheMap,
ConfigurableCacheMap {
    protected long m_cMaxUnits;
    protected long m_cCurUnits;
    private int m_cDefaultTTLMillis;
    private long m_cTouches;
    private LongArray m_arrayLRU;
    private LongArray m_arrayExpiry;
    protected ConfigurableCacheMap.UnitCalculator m_calculator;
    protected int m_nUnitFactor = 1;

    public SerializationCache(BinaryStore store, int cMax) {
        this(store, cMax, null);
    }

    public SerializationCache(BinaryStore store, int cMax, ClassLoader loader) {
        super(store, loader);
        this.setHighUnits(cMax);
    }

    public SerializationCache(BinaryStore store, int cMax, boolean fBinaryMap) {
        super(store, fBinaryMap);
        this.setHighUnits(cMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() {
        try {
            super.clear();
        }
        finally {
            this.getLruArray().clear();
            this.getExpiryArray().clear();
            this.m_cCurUnits = 0L;
        }
    }

    @Override
    public boolean containsKey(Object oKey) {
        this.checkExpiry();
        boolean fContains = super.containsKey(oKey);
        if (fContains) {
            this.touch(oKey);
        }
        return fContains;
    }

    @Override
    public boolean containsValue(Object oValue) {
        this.checkExpiry();
        return super.containsValue(oValue);
    }

    @Override
    public Object get(Object oKey) {
        this.checkExpiry();
        this.touch(oKey);
        return super.get(oKey);
    }

    @Override
    public boolean isEmpty() {
        this.checkExpiry();
        return super.isEmpty();
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        this.checkExpiry();
        Object oOrig = super.put(oKey, oValue);
        this.checkSize();
        return oOrig;
    }

    @Override
    public void putAll(Map map) {
        this.checkExpiry();
        super.putAll(map);
        this.checkSize();
    }

    @Override
    public Object remove(Object oKey) {
        this.checkExpiry();
        return super.remove(oKey);
    }

    @Override
    public int size() {
        this.checkExpiry();
        return super.size();
    }

    @Override
    protected boolean removeBlind(Object oKey) {
        this.checkExpiry();
        return super.removeBlind(oKey);
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        if (cMillis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("TTL value (" + cMillis + ") is out of range (0.." + Integer.MAX_VALUE + ")");
        }
        Object oOrig = this.put(oKey, oValue);
        if (cMillis != 0L && cMillis != (long)this.getExpiryDelay()) {
            this.registerKey(oKey, null, null, (int)cMillis);
        }
        return oOrig;
    }

    @Override
    public int getUnits() {
        if (this.m_calculator == null) {
            return super.size();
        }
        return OldCache.toExternalUnits(this.m_cCurUnits, this.getUnitFactor());
    }

    @Override
    public int getHighUnits() {
        return OldCache.toExternalUnits(this.m_cMaxUnits, this.getUnitFactor());
    }

    @Override
    public void setHighUnits(int cMax) {
        long cUnits = OldCache.toInternalUnits(cMax, this.getUnitFactor());
        boolean fShrink = cUnits < this.m_cMaxUnits;
        this.m_cMaxUnits = cUnits;
        if (fShrink) {
            this.checkSize();
        }
    }

    @Override
    public int getLowUnits() {
        return this.getHighUnits();
    }

    @Override
    public void setLowUnits(int cUnits) {
    }

    @Override
    public int getUnitFactor() {
        return this.m_nUnitFactor;
    }

    @Override
    public void setUnitFactor(int nFactor) {
        if (nFactor == this.m_nUnitFactor) {
            return;
        }
        if (nFactor < 1) {
            throw new IllegalArgumentException("unit factor must be >= 1");
        }
        if (this.m_nUnitFactor > 1) {
            throw new IllegalStateException("unit factor cannot be altered after it has been set");
        }
        if (this.m_cCurUnits > 0L) {
            throw new IllegalStateException("unit factor cannot be set after the cache has been populated");
        }
        this.m_nUnitFactor = nFactor;
        if (this.m_cMaxUnits != Long.MAX_VALUE) {
            this.m_cMaxUnits *= (long)nFactor;
        }
    }

    @Override
    public ConfigurableCacheMap.EvictionPolicy getEvictionPolicy() {
        return InternalEvictionPolicy.INSTANCE;
    }

    @Override
    public void setEvictionPolicy(ConfigurableCacheMap.EvictionPolicy policy) {
        if (policy != null && policy != InternalEvictionPolicy.INSTANCE) {
            throw new IllegalArgumentException("unsupported eviction policy");
        }
    }

    @Override
    public void evict(Object oKey) {
        if (this.getKeyMap().containsKey(oKey)) {
            if (this.hasListeners()) {
                this.dispatchPendingEvent(oKey, 3, null, true);
            }
            this.getBinaryStore().erase(this.toBinary(oKey));
            this.unregisterKey(oKey);
        }
    }

    @Override
    public void evictAll(Collection colKeys) {
        for (Object oKey : colKeys) {
            this.evict(oKey);
        }
    }

    @Override
    public void evict() {
        this.checkExpiry();
    }

    @Override
    public int getExpiryDelay() {
        return this.m_cDefaultTTLMillis;
    }

    @Override
    public synchronized void setExpiryDelay(int cMillis) {
        if (cMillis != this.m_cDefaultTTLMillis) {
            if (cMillis < 0) {
                cMillis = 0;
            }
            this.m_cDefaultTTLMillis = cMillis;
        }
    }

    @Override
    public int getFlushDelay() {
        return 0;
    }

    @Override
    public void setFlushDelay(int cMillis) {
    }

    @Override
    public ConfigurableCacheMap.Entry getCacheEntry(Object oKey) {
        return super.containsKey(oKey) ? (ConfigurableCacheMap.Entry)((EntrySet)this.entrySet()).instantiateEntry(oKey, null) : null;
    }

    @Override
    public ConfigurableCacheMap.UnitCalculator getUnitCalculator() {
        ConfigurableCacheMap.UnitCalculator calculator = this.m_calculator;
        return calculator == null ? OldCache.InternalUnitCalculator.INSTANCE : calculator;
    }

    @Override
    public synchronized void setUnitCalculator(ConfigurableCacheMap.UnitCalculator calculator) {
        if (calculator == OldCache.InternalUnitCalculator.INSTANCE) {
            calculator = null;
        }
        if (calculator != this.m_calculator) {
            if (calculator == null) {
                this.m_cCurUnits = this.size();
            } else {
                Map mapAttr = this.getKeyMap();
                Object[] aoKey = mapAttr.keySet().toArray();
                int cTotal = 0;
                BinaryStore store = this.getBinaryStore();
                for (Object oKey : aoKey) {
                    EntryAttributes attr = (EntryAttributes)mapAttr.get(oKey);
                    Binary binKey = this.toBinary(oKey);
                    Binary binValue = store.load(binKey);
                    int cUnits = calculator.calculateUnits(binKey, binValue);
                    mapAttr.put(oKey, this.instantiateEntryAttributes(attr, attr.getExpiryTime(), attr.getTouchCount(), cUnits));
                    cTotal += cUnits;
                }
                this.m_cCurUnits = cTotal;
            }
            this.m_calculator = calculator;
        }
    }

    public void flush() {
        this.checkExpiry();
    }

    @Override
    public String toString() {
        return "SerializationCache {" + this.getDescription() + "}";
    }

    @Override
    protected synchronized void setBinaryStore(BinaryStore store) {
        BinaryStore storeOrig = this.getBinaryStore();
        if (store != storeOrig) {
            this.getLruArray().clear();
            this.getExpiryArray().clear();
            this.m_cCurUnits = 0L;
            super.setBinaryStore(store);
        }
    }

    public int getMaximumSize() {
        if (this.m_calculator != null) {
            throw new IllegalStateException("attempt to get MaximumSize not supported when using a UnitCalculator; get HighUnits instead");
        }
        return this.getHighUnits();
    }

    public synchronized void setMaximumSize(int cMax) {
        if (this.m_calculator != null) {
            throw new IllegalStateException("attempt to set MaximumSize not supported when using a UnitCalculator; set HighUnits instead");
        }
        this.setHighUnits(cMax);
    }

    protected long getTouchCounter() {
        long c;
        this.m_cTouches = c = this.m_cTouches + 1L;
        return c;
    }

    protected LongArray getLruArray() {
        LongArray array = this.m_arrayLRU;
        if (array == null) {
            this.m_arrayLRU = array = new SparseArray();
        }
        return array;
    }

    protected LongArray getExpiryArray() {
        LongArray array = this.m_arrayExpiry;
        if (array == null) {
            this.m_arrayExpiry = array = new SparseArray();
        }
        return array;
    }

    @Override
    protected String getDescription() {
        return super.getDescription() + ", Units=" + this.getUnits() + ", HighUnits=" + this.getHighUnits() + ", UnitFactor=" + this.getUnitFactor() + ", EvictionPolicy=" + this.getEvictionPolicy().getName() + ", UnitCalculator=" + this.getUnitCalculator().getName() + ", ExpiryDelay=" + this.getExpiryDelay();
    }

    @Override
    protected void registerKey(Object oKey, Binary binKey, Binary binValue) {
        this.registerKey(oKey, binKey, binValue, this.getExpiryDelay());
    }

    protected synchronized void registerKey(Object oKey, Binary binKey, Binary binValue, int cMillis) {
        EntryAttributes attr;
        LongArray arrayLRU = this.getLruArray();
        LongArray arrayExpiry = this.getExpiryArray();
        Map mapKeys = this.getKeyMap();
        int cOldUnits = -1;
        int cNewUnits = -1;
        if (binKey != null && binValue != null) {
            ConfigurableCacheMap.UnitCalculator calculator = this.m_calculator;
            int n = cNewUnits = calculator == null ? 1 : calculator.calculateUnits(binKey, binValue);
        }
        if ((attr = (EntryAttributes)mapKeys.get(oKey)) != null) {
            Set setKeys;
            arrayLRU.remove(attr.getTouchCount());
            long ldtExpires = attr.getExpiryTime();
            if (ldtExpires != 0L && (setKeys = (Set)arrayExpiry.get(ldtExpires)) != null) {
                setKeys.remove(oKey);
                if (setKeys.isEmpty()) {
                    arrayExpiry.remove(ldtExpires);
                }
            }
            cOldUnits = attr.getUnits();
            if (cNewUnits < 0) {
                cNewUnits = cOldUnits;
            }
        }
        long nTouch = this.getTouchCounter();
        arrayLRU.set(nTouch, oKey);
        long ldtExpires = 0L;
        if (cMillis > 0) {
            ldtExpires = SerializationCache.getSafeTimeMillis() + (long)cMillis & 0xFFFFFFFFFFFFFF00L;
            Set setKeys = (Set)arrayExpiry.get(ldtExpires);
            if (setKeys == null) {
                setKeys = new LiteSet();
                arrayExpiry.set(ldtExpires, setKeys);
            }
            setKeys.add(oKey);
        }
        if (cNewUnits != cOldUnits) {
            this.m_cCurUnits += (long)(Math.max(0, cNewUnits) - Math.max(0, cOldUnits));
        }
        attr = this.instantiateEntryAttributes(attr, ldtExpires, nTouch, cNewUnits);
        mapKeys.put(oKey, attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void touch(Object oKey) {
        LongArray arrayLRU = this.getLruArray();
        Map mapKeys = this.getKeyMap();
        SerializationCache serializationCache = this;
        synchronized (serializationCache) {
            if (mapKeys.containsKey(oKey)) {
                EntryAttributes attr = (EntryAttributes)mapKeys.get(oKey);
                if (attr != null) {
                    arrayLRU.remove(attr.getTouchCount());
                }
                long nTouch = this.getTouchCounter();
                arrayLRU.set(nTouch, oKey);
                attr = this.instantiateEntryAttributes(attr, attr.getExpiryTime(), nTouch, attr.getUnits());
                mapKeys.put(oKey, attr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unregisterKey(Object oKey) {
        LongArray arrayLRU = this.getLruArray();
        LongArray arrayExpiry = this.getExpiryArray();
        Map mapKeys = this.getKeyMap();
        SerializationCache serializationCache = this;
        synchronized (serializationCache) {
            EntryAttributes attr = (EntryAttributes)mapKeys.remove(oKey);
            if (attr != null) {
                Set setKeys;
                arrayLRU.remove(attr.getTouchCount());
                long ldtPrevExpires = attr.getExpiryTime();
                if (ldtPrevExpires != 0L && (setKeys = (Set)arrayExpiry.get(ldtPrevExpires)) != null) {
                    setKeys.remove(oKey);
                    if (setKeys.isEmpty()) {
                        arrayExpiry.remove(ldtPrevExpires);
                    }
                }
                this.m_cCurUnits -= (long)attr.getUnits();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSize() {
        long cMax = this.m_cMaxUnits;
        if (cMax > 0L && cMax < this.m_cCurUnits) {
            SerializationCache serializationCache = this;
            synchronized (serializationCache) {
                LongArray arrayLRU = this.getLruArray();
                while (this.m_cCurUnits > cMax) {
                    Object oKey = arrayLRU.get(arrayLRU.getFirstIndex());
                    if (oKey == null) continue;
                    this.evict(oKey);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkExpiry() {
        LongArray arrayExpiry = this.getExpiryArray();
        if (arrayExpiry.isEmpty()) {
            return;
        }
        long ldtCurrent = SerializationCache.getSafeTimeMillis();
        if (ldtCurrent > arrayExpiry.getFirstIndex()) {
            SerializationCache serializationCache = this;
            synchronized (serializationCache) {
                Set setKeys;
                Set setEvict = null;
                LongArray.Iterator iter = arrayExpiry.iterator();
                while (iter.hasNext() && (setKeys = (Set)iter.next()) != null && ldtCurrent > iter.getIndex()) {
                    iter.remove();
                    if (setEvict == null) {
                        setEvict = setKeys;
                        continue;
                    }
                    setEvict.addAll(setKeys);
                }
                if (setEvict != null) {
                    this.evictAll(setEvict);
                }
            }
        }
    }

    public EntryAttributes instantiateEntryAttributes(EntryAttributes attrOrig, long ldtExpires, long nTouch, int cUnits) {
        return new EntryAttributes(ldtExpires, nTouch, cUnits);
    }

    @Override
    protected Set instantiateEntrySet() {
        return new EntrySet();
    }

    public static class InternalEvictionPolicy
    implements ConfigurableCacheMap.EvictionPolicy {
        static final InternalEvictionPolicy INSTANCE = new InternalEvictionPolicy();

        private InternalEvictionPolicy() {
        }

        @Override
        public void entryTouched(ConfigurableCacheMap.Entry entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void requestEviction(int cMaximum) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return "Internal-LRU";
        }
    }

    public class EntrySet
    extends AbstractKeySetBasedMap.EntrySet {
        public EntrySet() {
            super(SerializationCache.this);
        }

        @Override
        protected Map.Entry instantiateEntry(Object oKey, Object oValue) {
            return new Entry(oKey, oValue);
        }

        public class Entry
        extends AbstractKeyBasedMap.EntrySet.Entry
        implements ConfigurableCacheMap.Entry {
            public Entry(Object oKey, Object oValue) {
                super(EntrySet.this, oKey, oValue);
            }

            @Override
            public void touch() {
                SerializationCache.this.touch(this.getKey());
            }

            @Override
            public int getTouchCount() {
                EntryAttributes attr = this.getAttributes();
                return (int)Math.max(attr == null ? 0L : attr.getTouchCount(), Integer.MAX_VALUE);
            }

            @Override
            public long getLastTouchMillis() {
                return 0L;
            }

            @Override
            public long getExpiryMillis() {
                EntryAttributes attr = this.getAttributes();
                return attr == null ? 0L : attr.getExpiryTime();
            }

            @Override
            public void setExpiryMillis(long lMillis) {
                EntryAttributes attr = this.getAttributes();
                if (attr != null) {
                    SerializationCache.this.registerKey(this.getKey(), null, null, (int)Math.max(Math.min(1L, lMillis - Entry.getSafeTimeMillis()), Integer.MAX_VALUE));
                }
            }

            @Override
            public int getUnits() {
                EntryAttributes attr = this.getAttributes();
                return attr == null ? -1 : attr.getUnits();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUnits(int cUnits) {
                SerializationCache cache;
                SerializationCache serializationCache = cache = SerializationCache.this;
                synchronized (serializationCache) {
                    int cOld;
                    EntryAttributes attr = this.getAttributes();
                    if (attr != null && (cOld = attr.getUnits()) >= 0 && cUnits >= 0 && cOld != cUnits) {
                        cache.getKeyMap().put(this.getKey(), cache.instantiateEntryAttributes(attr, attr.getExpiryTime(), this.getTouchCount(), cUnits));
                        cache.m_cCurUnits += (long)(cUnits - cOld);
                    }
                }
            }

            protected EntryAttributes getAttributes() {
                return (EntryAttributes)SerializationCache.this.getKeyMap().get(this.getKey());
            }
        }
    }

    protected class EntryAttributes
    extends Base {
        private long m_ldtExpires;
        private long m_nTouch;
        private int m_cUnits;

        public EntryAttributes(long ldtExpires, long nTouch, int cUnits) {
            this.m_ldtExpires = ldtExpires;
            this.m_nTouch = nTouch;
            this.m_cUnits = cUnits;
        }

        public long getExpiryTime() {
            return this.m_ldtExpires;
        }

        public long getTouchCount() {
            return this.m_nTouch;
        }

        public int getUnits() {
            return this.m_cUnits;
        }
    }
}

