/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractEvent
implements Event {
    protected Enum m_eventType;
    protected Iterator<? extends EventInterceptor> m_iterInterceptor;

    public AbstractEvent(Enum eventType) {
        this.m_eventType = eventType;
    }

    protected Iterator<? extends EventInterceptor> getIterator() {
        return this.m_iterInterceptor;
    }

    protected void setIterator(Iterator<? extends EventInterceptor> iter) {
        this.m_iterInterceptor = iter;
    }

    @Override
    public Enum getType() {
        return this.m_eventType;
    }

    @Override
    public void nextInterceptor() {
        Iterator<? extends EventInterceptor> iter = this.getIterator();
        while (iter.hasNext()) {
            EventInterceptor interceptor = iter.next();
            try {
                interceptor.onEvent(this);
            }
            catch (EventDeathException eDeath) {
                if (this.isVetoable()) {
                    while (iter.hasNext()) {
                        iter.next();
                    }
                    throw eDeath;
                }
                CacheFactory.log("EventDeathException caught while dispatching  to non veto-able event\" " + interceptor + " \": " + eDeath.getMessage(), 1);
            }
            catch (Exception e) {
                CacheFactory.log("Exception caught while dispatching to \"" + interceptor + "\": " + e.getMessage() + "\n" + Base.getStackTrace(e), 1);
            }
        }
    }

    protected void dispatch(Collection<? extends EventInterceptor> colIter) {
        this.setIterator(colIter.iterator());
        this.nextInterceptor();
    }

    protected boolean isMutableEvent() {
        return false;
    }

    protected boolean isVetoable() {
        return this.isMutableEvent();
    }

    public String toString() {
        String sEvt = this.getClass().getName();
        return sEvt.substring(sEvt.lastIndexOf(46) + 1) + '{' + this.getType() + '}';
    }
}

