/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.net.security.Security;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SegmentedConcurrentMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.Subject;

public class ScopedReferenceStore {
    private ConcurrentMap m_mapByName = new SegmentedConcurrentMap();

    public void clear() {
        this.m_mapByName.clear();
    }

    public Collection<Integer> clearInactiveCacheRefs(String sCacheName) {
        Map mapByLoader = (Map)this.m_mapByName.get(sCacheName);
        if (mapByLoader == null) {
            return null;
        }
        HashSet<Integer> setHashCode = new HashSet<Integer>();
        Iterator iter = mapByLoader.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ClassLoader loaderTmp = (ClassLoader)entry.getKey();
            Object oHolder = entry.getValue();
            if (oHolder instanceof NamedCache) {
                NamedCache cacheTmp = (NamedCache)entry.getValue();
                if (cacheTmp.isActive()) continue;
                setHashCode.add(loaderTmp == null ? 0 : loaderTmp.hashCode());
                iter.remove();
                continue;
            }
            if (oHolder instanceof SubjectScopedReference) {
                for (NamedCache cacheTmp : ((SubjectScopedReference)oHolder).values()) {
                    if (cacheTmp.isActive()) continue;
                    setHashCode.add(loaderTmp == null ? 0 : loaderTmp.hashCode());
                    iter.remove();
                }
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return setHashCode;
    }

    public NamedCache getCache(String sCacheName, ClassLoader loader) {
        NamedCache cache = null;
        Map mapByLoader = (Map)this.m_mapByName.get(sCacheName);
        if (mapByLoader != null) {
            Object oHolder = mapByLoader.get(loader);
            if (oHolder == null || oHolder instanceof NamedCache) {
                return (NamedCache)oHolder;
            }
            if (oHolder instanceof SubjectScopedReference) {
                return (NamedCache)((SubjectScopedReference)oHolder).get();
            }
            throw new UnsupportedOperationException();
        }
        return cache;
    }

    public Service getService(String sServiceName) {
        Object oHolder = this.m_mapByName.get(sServiceName);
        if (oHolder == null || oHolder instanceof Service) {
            return (Service)oHolder;
        }
        if (oHolder instanceof SubjectScopedReference) {
            return (Service)((SubjectScopedReference)oHolder).get();
        }
        throw new UnsupportedOperationException();
    }

    public Collection getAllCaches() {
        HashSet setRef = new HashSet();
        Collection colLoader = this.m_mapByName.values();
        Iterator iterLoader = colLoader.iterator();
        while (iterLoader.hasNext()) {
            Collection colRef = ((Map)iterLoader.next()).values();
            for (Object oHolder : colRef) {
                if (oHolder instanceof SubjectScopedReference) {
                    setRef.addAll(((SubjectScopedReference)oHolder).values());
                    continue;
                }
                if (oHolder instanceof NamedCache) {
                    setRef.add(oHolder);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        return setRef;
    }

    public Collection getAllCaches(String sCacheName) {
        HashSet setRef = new HashSet();
        Map mapByLoader = (Map)this.m_mapByName.get(sCacheName);
        if (mapByLoader != null) {
            Collection col = mapByLoader.values();
            for (Object oHolder : col) {
                if (oHolder instanceof SubjectScopedReference) {
                    setRef.addAll(((SubjectScopedReference)oHolder).values());
                    continue;
                }
                if (oHolder instanceof NamedCache) {
                    setRef.add(oHolder);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        return setRef;
    }

    public Set getNames() {
        return this.m_mapByName.keySet();
    }

    public boolean lock(String sName) {
        return this.m_mapByName.lock(sName, -1L);
    }

    public boolean lockAll() {
        return this.m_mapByName.lock(ConcurrentMap.LOCK_ALL, -1L);
    }

    public void putCache(NamedCache cache, ClassLoader loader) {
        ConcurrentMap mapByName = this.m_mapByName;
        String sCacheName = cache.getCacheName();
        WeakHashMap<ClassLoader, Object> mapByLoader = (WeakHashMap<ClassLoader, Object>)mapByName.get(sCacheName);
        if (mapByLoader == null) {
            mapByLoader = new WeakHashMap<ClassLoader, Object>();
            mapByName.put(sCacheName, mapByLoader);
        }
        if (ScopedReferenceStore.isRemoteServiceType(cache.getCacheService().getInfo().getServiceType()) && Security.SUBJECT_SCOPED) {
            SubjectScopedReference scopedRef = (SubjectScopedReference)mapByLoader.get(loader);
            if (scopedRef == null) {
                scopedRef = new SubjectScopedReference();
                mapByLoader.put(loader, scopedRef);
            }
            scopedRef.set(cache);
        } else {
            mapByLoader.put(loader, cache);
        }
    }

    public void putService(Service service, String sName, String sType) {
        ConcurrentMap mapByName = this.m_mapByName;
        if (ScopedReferenceStore.isRemoteServiceType(sType) && Security.SUBJECT_SCOPED) {
            SubjectScopedReference scopedRef = (SubjectScopedReference)mapByName.get(sName);
            if (scopedRef == null) {
                scopedRef = new SubjectScopedReference();
                mapByName.put(sName, scopedRef);
            }
            scopedRef.set(service);
        } else {
            mapByName.put(sName, service);
        }
    }

    public boolean releaseCache(NamedCache cache, ClassLoader loader) {
        ConcurrentMap mapByName = this.m_mapByName;
        String sCacheName = cache.getCacheName();
        Map mapByLoader = (Map)mapByName.get(sCacheName);
        boolean fFound = false;
        if (mapByLoader != null) {
            SubjectScopedReference scopedRef;
            Object oHolder = mapByLoader.get(loader);
            if (oHolder == cache) {
                mapByLoader.remove(loader);
                fFound = true;
            } else if (oHolder instanceof SubjectScopedReference && (scopedRef = (SubjectScopedReference)oHolder).get() == cache) {
                scopedRef.remove();
                fFound = true;
                if (scopedRef.isEmpty()) {
                    mapByLoader.remove(loader);
                }
            }
            if (mapByLoader.isEmpty()) {
                mapByName.remove(sCacheName);
            }
        }
        return fFound;
    }

    public boolean releaseCache(NamedCache cache) {
        ConcurrentMap mapByName = this.m_mapByName;
        String sCacheName = cache.getCacheName();
        Map mapByLoader = (Map)mapByName.get(sCacheName);
        boolean fFound = false;
        if (mapByLoader != null) {
            Collection col = mapByLoader.values();
            fFound = col.remove(cache);
            if (!fFound) {
                Object oHolder;
                if (cache instanceof ClassLoaderAware) {
                    return this.releaseCache(cache, ((ClassLoaderAware)((Object)cache)).getContextClassLoader());
                }
                Iterator iter = col.iterator();
                while (iter.hasNext() && (oHolder = iter.next()) instanceof SubjectScopedReference) {
                    SubjectScopedReference scopedRef = (SubjectScopedReference)oHolder;
                    if (scopedRef.get() != cache) continue;
                    scopedRef.remove();
                    fFound = true;
                    if (!scopedRef.isEmpty()) break;
                    iter.remove();
                    break;
                }
            }
            if (mapByLoader.isEmpty()) {
                mapByName.remove(sCacheName);
            }
        }
        return fFound;
    }

    public void remove(String sName) {
        this.m_mapByName.remove(sName);
    }

    public boolean unlock(String sName) {
        return this.m_mapByName.unlock(sName);
    }

    public boolean unlockAll() {
        return this.m_mapByName.unlock(ConcurrentMap.LOCK_ALL);
    }

    public static boolean isRemoteServiceType(String sType) {
        return sType.equals("RemoteCache") || sType.equals("RemoteInvocation");
    }

    public class SubjectScopedReference {
        private Map m_mapSubjectScope = new WeakHashMap();
        private Object m_oRef;

        public Object get() {
            Subject subject = SecurityHelper.getCurrentSubject();
            return subject == null ? this.m_oRef : this.m_mapSubjectScope.get(subject);
        }

        public boolean isEmpty() {
            Subject subject = SecurityHelper.getCurrentSubject();
            return subject == null ? this.m_oRef == null : this.m_mapSubjectScope.isEmpty();
        }

        public void set(Object oRef) {
            Subject subject = SecurityHelper.getCurrentSubject();
            if (subject == null) {
                this.m_oRef = oRef;
            } else {
                this.m_mapSubjectScope.put(subject, oRef);
            }
        }

        public Object remove() {
            Subject subject = SecurityHelper.getCurrentSubject();
            return subject == null ? (this.m_oRef = null) : (Object)this.m_mapSubjectScope.remove(subject);
        }

        public Collection values() {
            if (SecurityHelper.getCurrentSubject() == null) {
                Object oRef = this.m_oRef;
                return oRef == null ? NullImplementation.getSet() : Collections.singleton(oRef);
            }
            return this.m_mapSubjectScope.values();
        }
    }
}

