/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.internal.SessionOptimisticPut;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SessionOptimisticRemove
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    public int m_nVersion;

    public SessionOptimisticRemove() {
    }

    public SessionOptimisticRemove(int nVersion) {
        if (nVersion < 0) {
            throw new IllegalArgumentException();
        }
        this.m_nVersion = nVersion;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        int nVersionRet = 0;
        if (entry.isPresent()) {
            int nVersionExp;
            Binary binSession = ((BinaryEntry)entry).getBinaryValue();
            int nVersionOld = SessionOptimisticPut.extractVersion(binSession);
            if (nVersionOld == (nVersionExp = this.m_nVersion)) {
                entry.remove(false);
                nVersionRet = nVersionOld;
            } else {
                nVersionRet = -nVersionOld;
            }
        }
        return SessionOptimisticRemove.makeInteger(nVersionRet);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nVersion = ExternalizableHelper.readInt(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt(out, this.m_nVersion);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nVersion = in.readInt(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nVersion);
    }
}

