/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.net.Member;
import com.tangosol.net.partition.DistributionManager;
import com.tangosol.net.partition.Ownership;
import com.tangosol.net.partition.PartitionAssignmentStrategy;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.DeltaSet;
import com.tangosol.util.Filter;
import com.tangosol.util.comparator.ChainedComparator;
import com.tangosol.util.comparator.InverseComparator;
import com.tangosol.util.filter.AllFilter;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.NotFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SimpleAssignmentStrategy
implements PartitionAssignmentStrategy {
    protected static final Comparator MEMBERID_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Member)o1).getId() - ((Member)o2).getId();
        }
    };
    protected DistributionManager m_manager;
    protected AnalysisContext m_ctxLast;

    public DistributionManager getManager() {
        return this.m_manager;
    }

    public AnalysisContext getLastAnalysisContext() {
        return this.m_ctxLast;
    }

    public void setLastAnalysisContext(AnalysisContext ctx) {
        this.m_ctxLast = ctx;
    }

    @Override
    public void init(DistributionManager manager) {
        this.m_manager = manager;
    }

    @Override
    public long analyzeDistribution() {
        return this.analyzeDistribution(this.instantiateAnalysisContext());
    }

    protected long analyzeDistribution(AnalysisContext ctx) {
        this.checkLeaving(ctx);
        this.validateBackups(ctx);
        this.checkPrimaryBalance(ctx);
        if (ctx.getActualBackupCount() > 0) {
            this.checkEndangered(ctx);
            do {
                int cChanges = 0;
                cChanges += this.checkBackupStrong(ctx);
            } while ((cChanges += this.checkBackupBalance(ctx)) > 0);
        }
        this.setLastAnalysisContext(ctx);
        return ctx.suggestDistribution() ? 1000L : 10000L;
    }

    @Override
    public String getDescription() {
        AnalysisContext ctxLast = this.getLastAnalysisContext();
        StringBuilder sb = new StringBuilder();
        if (ctxLast != null) {
            sb.append("Fair-Share=").append(ctxLast.getFairShare(true)).append("(primary), ").append(ctxLast.getFairShare(false)).append("(backup)").append('\n');
            sb.append("Backup-Strength=").append(ctxLast.getBackupStrength().getDescription());
        }
        return sb.toString();
    }

    public String toString() {
        return "{" + ClassHelper.getSimpleName(this.getClass()) + " " + this.getDescription() + "}";
    }

    protected void checkLeaving(AnalysisContext ctx) {
        Set<Member> setLeaving = this.getManager().getOwnershipLeavingMembers();
        Member[] aOwners = ctx.getOwnershipMembersList();
        int cBackupsConfig = this.getBackupCount();
        if (setLeaving.isEmpty()) {
            return;
        }
        for (Member memberLeaving : setLeaving) {
            PartitionSet partsPrime = ctx.getOwnedPartitions(memberLeaving, 0);
            int iPart = partsPrime.next(0);
            while (iPart >= 0) {
                block6: {
                    Ownership owners = ctx.getPartitionOwnership(iPart);
                    for (int iStore = cBackupsConfig; iStore >= 1; --iStore) {
                        int nOwner = owners.getOwner(iStore);
                        if (nOwner == 0) continue;
                        Member memberTo = this.getMember(nOwner);
                        ctx.transitionPartition(iPart, 0, memberLeaving, memberTo);
                        ctx.transitionPartition(iPart, iStore, memberTo, null);
                        break block6;
                    }
                    Arrays.sort(aOwners, ctx.instantiateLoadComparator(true));
                    ctx.transitionPartition(iPart, 0, memberLeaving, aOwners[0]);
                }
                iPart = partsPrime.next(iPart + 1);
            }
            for (int iStore = 1; iStore <= cBackupsConfig; ++iStore) {
                PartitionSet parts = ctx.getOwnedPartitions(memberLeaving, iStore);
                int iPart2 = parts.next(0);
                while (iPart2 >= 0) {
                    ctx.transitionPartition(iPart2, iStore, memberLeaving, null);
                    iPart2 = parts.next(iPart2 + 1);
                }
            }
        }
    }

    protected void validateBackups(AnalysisContext ctx) {
        int cPartitions = this.getPartitionCount();
        int cBackupsActual = ctx.getActualBackupCount();
        int cBackupsConfig = this.getBackupCount();
        if (cBackupsConfig != cBackupsActual) {
            for (int iPart = 0; iPart < cPartitions; ++iPart) {
                Ownership owners = ctx.getPartitionOwnership(iPart);
                int iStoreValid = 1;
                for (int iStore = 1; iStore <= cBackupsConfig; ++iStore) {
                    int nBackupOwner = owners.getOwner(iStore);
                    if (nBackupOwner == 0) continue;
                    if (iStore > iStoreValid) {
                        Member memberThis = this.getMember(nBackupOwner);
                        ctx.transitionPartition(iPart, iStoreValid, null, memberThis);
                        ctx.transitionPartition(iPart, iStore, memberThis, null);
                    }
                    ++iStoreValid;
                }
            }
        }
    }

    protected void checkPrimaryBalance(AnalysisContext ctx) {
        int cChanges;
        Object[] aMembersOverload = ctx.getOwnershipMembersList();
        Member[] aMembersTarget = (Member[])aMembersOverload.clone();
        do {
            cChanges = 0;
            int cOverloaded = SimpleAssignmentStrategy.filterSort(aMembersOverload, new InverseComparator(ctx.instantiateLoadComparator(true)), ctx.instantiateOverloadedFilter(true));
            for (int i = 0; i < cOverloaded; ++i) {
                Object memberFrom = aMembersOverload[i];
                PartitionSet partsAll = new PartitionSet(ctx.getOwnedPartitions((Member)memberFrom, 0));
                PartitionSet partsEndangered = ctx.collectEndangered(partsAll);
                partsAll.remove(partsEndangered);
                cChanges += this.doBalancePrimary(ctx, (Member)memberFrom, partsEndangered, aMembersTarget);
                PartitionSet partsWeak = ctx.collectWeak(partsAll);
                partsAll.remove(partsWeak);
                cChanges += this.doBalancePrimary(ctx, (Member)memberFrom, partsWeak, aMembersTarget);
                cChanges += this.doBalancePrimary(ctx, (Member)memberFrom, partsAll, aMembersTarget);
            }
        } while (cChanges > 0);
    }

    protected int doBalancePrimary(AnalysisContext ctx, Member memberFrom, PartitionSet parts, Member[] aMembersTarget) {
        int cFairShare = ctx.getFairShare(true);
        int cLoadMemberFrom = ctx.getMemberLoad(memberFrom, true);
        int cChanges = 0;
        int iPart = parts.next(0);
        while (iPart >= 0 && cLoadMemberFrom >= cFairShare) {
            Ownership owners = (Ownership)ctx.getPartitionOwnership(iPart).clone();
            int cLoad = ctx.getPartitionLoad(iPart, true);
            owners.setOwner(0, 0);
            int cUnderloaded = SimpleAssignmentStrategy.filterSort(aMembersTarget, SimpleAssignmentStrategy.chainComparators(ctx.instantiateStrengthComparator(owners), ctx.instantiateLoadComparator(true), MEMBERID_COMPARATOR), ctx.instantiateUnderloadedFilter(true));
            for (int i = 0; i < cUnderloaded; ++i) {
                Member memberTo = aMembersTarget[i];
                int cLoadMemberTo = ctx.getMemberLoad(memberTo, true);
                if (cLoadMemberTo + cLoad >= cLoadMemberFrom) continue;
                ctx.transitionPartition(iPart, 0, memberFrom, memberTo);
                cLoadMemberFrom -= cLoad;
                ++cChanges;
                break;
            }
            iPart = parts.next(iPart + 1);
        }
        return cChanges;
    }

    protected void checkEndangered(AnalysisContext ctx) {
        int cBackups = ctx.getActualBackupCount();
        int cPartitions = this.getPartitionCount();
        Object[] aMember = ctx.getOwnershipMembersList();
        for (int iPart = 0; iPart < cPartitions; ++iPart) {
            Ownership owners = ctx.getPartitionOwnership(iPart);
            Member memberPrimary = this.getMember(owners.getPrimaryOwner());
            Base.azzert(memberPrimary != null);
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                if (owners.getOwner(iStore) != 0) continue;
                int cStrong = SimpleAssignmentStrategy.filterSort(aMember, SimpleAssignmentStrategy.chainComparators(ctx.instantiateLoadComparator(false), ctx.instantiateStrengthComparator(owners), MEMBERID_COMPARATOR), new AndFilter(ctx.instantiateSafetyFilter(owners), ctx.instantiateNotOwnedFilter(owners)));
                Base.azzert(cStrong > 0, "Failed to find a member to receive backup(" + iStore + ") transfer of endangered partition " + iPart + ", " + owners);
                ctx.transitionPartition(iPart, iStore, null, (Member)aMember[0]);
            }
        }
    }

    protected int checkBackupStrong(AnalysisContext ctx) {
        int cPartitions = this.getPartitionCount();
        int cBackups = ctx.getActualBackupCount();
        int cChanges = 0;
        Object[] aMembersTarget = ctx.getOwnershipMembersList();
        block0: for (int iPart = 0; iPart < cPartitions; ++iPart) {
            if (ctx.isPartitionStrong(iPart)) continue;
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                Ownership owners = (Ownership)ctx.getPartitionOwnership(iPart).clone();
                Member memberFrom = this.getMember(owners.getOwner(iStore));
                owners.setOwner(iStore, 0);
                int cUnderloaded = SimpleAssignmentStrategy.filterSort(aMembersTarget, SimpleAssignmentStrategy.chainComparators(ctx.instantiateStrengthComparator(owners), ctx.instantiateLoadComparator(false), MEMBERID_COMPARATOR), new AllFilter(new Filter[]{ctx.instantiateSafetyFilter(owners), ctx.instantiateUnderloadedFilter(false), ctx.instantiateNotOwnedFilter(owners)}));
                if (cUnderloaded > 0) {
                    ctx.transitionPartition(iPart, iStore, memberFrom, (Member)aMembersTarget[0]);
                    ++cChanges;
                    continue block0;
                }
                int cOverloaded = SimpleAssignmentStrategy.filterSort(aMembersTarget, SimpleAssignmentStrategy.chainComparators(ctx.instantiateLoadComparator(false), ctx.instantiateStrengthComparator(owners), MEMBERID_COMPARATOR), new AllFilter(new Filter[]{ctx.instantiateSafetyFilter(owners), ctx.instantiateOverloadedFilter(false), ctx.instantiateNotOwnedFilter(owners)}));
                if (cOverloaded <= 0) continue;
                ctx.transitionPartition(iPart, iStore, memberFrom, (Member)aMembersTarget[0]);
                ++cChanges;
                continue block0;
            }
        }
        return cChanges;
    }

    protected int checkBackupBalance(AnalysisContext ctx) {
        int cBackups = ctx.getActualBackupCount();
        Object[] aMembersOverload = ctx.getOwnershipMembersList();
        Object[] aMembersTarget = (Member[])aMembersOverload.clone();
        int cFairShare = ctx.getFairShare(false);
        int cChanges = 0;
        int cOverloaded = SimpleAssignmentStrategy.filterSort(aMembersOverload, new InverseComparator(ctx.instantiateLoadComparator(false)), ctx.instantiateOverloadedFilter(false));
        block0: for (int i = 0; i < cOverloaded; ++i) {
            Object memberFrom = aMembersOverload[i];
            int cLoadMemberFrom = ctx.getMemberLoad((Member)memberFrom, false);
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                PartitionSet parts = ctx.getOwnedPartitions((Member)memberFrom, iStore);
                int iPart = parts.next(0);
                while (iPart >= 0) {
                    int cLoad = ctx.getPartitionLoad(iPart, true);
                    Ownership owners = (Ownership)ctx.getPartitionOwnership(iPart).clone();
                    owners.setOwner(iStore, 0);
                    int cUnderloaded = SimpleAssignmentStrategy.filterSort(aMembersTarget, SimpleAssignmentStrategy.chainComparators(ctx.instantiateLoadComparator(false), ctx.instantiateStrengthComparator(owners), MEMBERID_COMPARATOR), new AllFilter(new Filter[]{ctx.instantiateSafetyFilter(owners), ctx.instantiateUnderloadedFilter(false), ctx.instantiateNotOwnedFilter(owners)}));
                    for (int j = 0; j < cUnderloaded; ++j) {
                        Object memberTo = aMembersTarget[j];
                        int cLoadMemberTo = ctx.getMemberLoad((Member)memberTo, false);
                        if (cLoadMemberTo + cLoad >= cLoadMemberFrom) continue;
                        ctx.transitionPartition(iPart, iStore, (Member)memberFrom, (Member)memberTo);
                        cLoadMemberFrom -= cLoad;
                        ++cChanges;
                        break;
                    }
                    if (cLoadMemberFrom < cFairShare) continue block0;
                    iPart = parts.next(iPart + 1);
                }
            }
        }
        return cChanges;
    }

    protected int getPartitionCount() {
        return this.getManager().getService().getPartitionCount();
    }

    protected int getBackupCount() {
        return this.getManager().getService().getBackupCount();
    }

    protected Member getMember(int nMemberId) {
        return this.getManager().getMember(nMemberId);
    }

    protected static Ownership cloneOwnership(Ownership owners, int iStore) {
        Ownership ownersNew = (Ownership)owners.clone();
        ownersNew.setOwner(iStore, 0);
        return ownersNew;
    }

    protected static Comparator chainComparators(Comparator comp1, Comparator comp2, Comparator comp3) {
        return new ChainedComparator(new Comparator[]{comp1, comp2, comp3});
    }

    protected static int filterSort(Object[] ao, Comparator comparator, Filter filter) {
        int cElems = SimpleAssignmentStrategy.filterArray(ao, filter);
        if (cElems > 1) {
            Arrays.sort(ao, 0, cElems, comparator);
        }
        return cElems;
    }

    protected static int filterArray(Object[] ao, Filter filter) {
        int cElems = ao.length;
        int iShift = 0;
        for (int i = 0; i < cElems; ++i) {
            if (!filter.evaluate(ao[i])) {
                ++iShift;
                continue;
            }
            if (iShift <= 0) continue;
            Object oTemp = ao[i - iShift];
            ao[i - iShift] = ao[i];
            ao[i] = oTemp;
        }
        return cElems - iShift;
    }

    public LoadCalculator instantiateLoadCalculator(boolean fPrimary) {
        return new SimpleLoadCalculator();
    }

    public AnalysisContext instantiateAnalysisContext() {
        return new AnalysisContext();
    }

    protected static class BackupStrength {
        protected static final int NODE_SAFE = 1;
        protected static final int MACHINE_SAFE = 2;
        protected static final int RACK_SAFE = 3;
        protected static final int SITE_SAFE = 4;
        protected int m_nStrength;

        protected BackupStrength(int nStrength) {
            this.m_nStrength = nStrength;
        }

        protected boolean isStrong(Member member1, Member member2) {
            switch (this.m_nStrength) {
                default: {
                    return member1.getId() != member2.getId();
                }
                case 2: {
                    return member1.getMachineId() != member2.getMachineId();
                }
                case 3: {
                    return !Base.equals(member1.getRackName(), member2.getRackName());
                }
                case 4: 
            }
            return !Base.equals(member1.getSiteName(), member2.getSiteName());
        }

        public String getDescription() {
            switch (this.m_nStrength) {
                default: {
                    return "<unknown>";
                }
                case 1: {
                    return "node-safe";
                }
                case 2: {
                    return "machine-safe";
                }
                case 3: {
                    return "rack-safe";
                }
                case 4: 
            }
            return "site-safe";
        }

        public String toString() {
            return "{BackupStrength " + this.getDescription() + "}";
        }
    }

    protected class AnalysisContext {
        protected LoadCalculator m_calculatorPrimary;
        protected LoadCalculator m_calculatorBackup;
        protected Map m_mapOwnedPartitions = new HashMap();
        protected Ownership[] m_aOwners = new Ownership[SimpleAssignmentStrategy.this.getPartitionCount()];
        protected PartitionSet m_partsUpdated;
        protected BackupStrength m_strength;
        protected int m_cBackupActual;
        protected int m_cFairSharePrimary;
        protected int m_cFairShareBackup;
        protected Set m_setOwnershipMembers;
        protected Member[] m_aOwnershipMembers;

        public AnalysisContext() {
            this.initialize();
        }

        protected PartitionSet getUpdatedPartitions() {
            return this.m_partsUpdated;
        }

        protected BackupStrength getBackupStrength() {
            return this.m_strength;
        }

        protected Set getOwnershipMembers() {
            return this.m_setOwnershipMembers;
        }

        protected Member[] getOwnershipMembersList() {
            return this.m_aOwnershipMembers;
        }

        public LoadCalculator getPrimaryLoadCalculator() {
            return this.m_calculatorPrimary;
        }

        public LoadCalculator getBackupLoadCalculator() {
            return this.m_calculatorBackup;
        }

        protected int getActualBackupCount() {
            return this.m_cBackupActual;
        }

        protected void initialize() {
            DistributionManager manager = SimpleAssignmentStrategy.this.getManager();
            DeltaSet setOwners = manager.getOwnershipMembers();
            Set<Member> setLeaving = manager.getOwnershipLeavingMembers();
            if (!setLeaving.isEmpty()) {
                setOwners = new DeltaSet(setOwners);
                setOwners.removeAll(setLeaving);
            }
            this.m_setOwnershipMembers = setOwners;
            this.m_aOwnershipMembers = setOwners.toArray(new Member[setOwners.size()]);
            this.m_cBackupActual = Math.min(SimpleAssignmentStrategy.this.getBackupCount(), setOwners.size() - 1);
            this.m_strength = this.instantiateBackupStrength(setOwners);
            this.m_calculatorPrimary = SimpleAssignmentStrategy.this.instantiateLoadCalculator(true);
            this.m_calculatorBackup = SimpleAssignmentStrategy.this.instantiateLoadCalculator(false);
            this.m_cFairSharePrimary = this.calculateFairShare(true);
            this.m_cFairShareBackup = this.calculateFairShare(false);
        }

        protected int getFairShare(boolean fPrimary) {
            return fPrimary ? this.m_cFairSharePrimary : this.m_cFairShareBackup;
        }

        protected int calculateFairShare(boolean fPrimary) {
            Set setOwners = this.getOwnershipMembers();
            LoadCalculator calculator = fPrimary ? this.getPrimaryLoadCalculator() : this.getBackupLoadCalculator();
            int cMembers = setOwners.size();
            PartitionSet partsAll = new PartitionSet(SimpleAssignmentStrategy.this.getPartitionCount());
            partsAll.fill();
            int cLoadTotal = calculator.getLoad(partsAll);
            if (!fPrimary) {
                cLoadTotal *= this.getActualBackupCount();
            }
            return cMembers <= 1 ? cLoadTotal : cLoadTotal / cMembers + 1;
        }

        protected boolean isMemberLeaving(Member member) {
            return SimpleAssignmentStrategy.this.getManager().getOwnershipLeavingMembers().contains(member);
        }

        protected BackupStrength instantiateBackupStrength(Set setOwners) {
            HashMap<String, HashSet<Member>> mapBySite = new HashMap<String, HashSet<Member>>();
            HashMap<String, HashSet<Member>> mapByRack = new HashMap<String, HashSet<Member>>();
            HashMap<Integer, HashSet<Member>> mapByMachine = new HashMap<Integer, HashSet<Member>>();
            for (Member member : setOwners) {
                String sSite = member.getSiteName();
                String sRack = member.getRackName();
                int nMachine = member.getMachineId();
                HashSet<Member> setSite = (HashSet<Member>)mapBySite.get(sSite);
                if (setSite == null) {
                    setSite = new HashSet<Member>();
                    mapBySite.put(sSite, setSite);
                }
                setSite.add(member);
                HashSet<Member> setRack = (HashSet<Member>)mapByRack.get(sRack);
                if (setRack == null) {
                    setRack = new HashSet<Member>();
                    mapByRack.put(sRack, setRack);
                }
                setRack.add(member);
                HashSet<Member> setMachine = (HashSet<Member>)mapByMachine.get(nMachine);
                if (setMachine == null) {
                    setMachine = new HashSet<Member>();
                    mapByMachine.put(nMachine, setMachine);
                }
                setMachine.add(member);
            }
            int nStrength = 1;
            if (this.isStrongPossible(setOwners, mapBySite)) {
                nStrength = 4;
            } else if (this.isStrongPossible(setOwners, mapByRack)) {
                nStrength = 3;
            } else if (this.isStrongPossible(setOwners, mapByMachine)) {
                nStrength = 2;
            }
            return new BackupStrength(nStrength);
        }

        protected boolean isStrongPossible(Set setOwners, Map mapSplit) {
            int cMax = 0;
            for (Set setGroup : mapSplit.values()) {
                int cMembers = setGroup.size();
                if (cMembers <= cMax) continue;
                cMax = cMembers;
            }
            return cMax * 2 <= setOwners.size();
        }

        protected boolean isPartitionStrong(int iPartition) {
            return this.isPartitionStrong(this.getPartitionOwnership(iPartition));
        }

        protected boolean isPartitionStrong(Ownership owners) {
            Member memberPrime = SimpleAssignmentStrategy.this.getMember(owners.getPrimaryOwner());
            BackupStrength strength = this.getBackupStrength();
            int cBackups = this.getActualBackupCount();
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                Member memberBackup = SimpleAssignmentStrategy.this.getMember(owners.getOwner(iStore));
                if (memberBackup == null || !strength.isStrong(memberPrime, memberBackup)) continue;
                return true;
            }
            return false;
        }

        protected boolean isTransferStrong(int iPartition, int iStore, Member member) {
            Ownership owners = (Ownership)this.getPartitionOwnership(iPartition).clone();
            owners.setOwner(iStore, member.getId());
            return this.isPartitionStrong(owners);
        }

        protected boolean isStrong(Member member1, Member member2) {
            return this.getBackupStrength().isStrong(member1, member2);
        }

        protected boolean isStrong(Member member, Ownership owners) {
            int cBackups = SimpleAssignmentStrategy.this.getBackupCount();
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                int nOwner = owners.getOwner(iStore);
                if (nOwner == 0 || !this.isStrong(member, SimpleAssignmentStrategy.this.getMember(nOwner))) continue;
                return true;
            }
            return false;
        }

        protected PartitionSet collectWeak(PartitionSet parts) {
            PartitionSet partsWeak = new PartitionSet(parts.getPartitionCount());
            int iPart = parts.next(0);
            while (iPart >= 0) {
                if (!this.isPartitionStrong(iPart)) {
                    partsWeak.add(iPart);
                }
                iPart = parts.next(iPart + 1);
            }
            return partsWeak;
        }

        protected boolean isPartitionEndangered(int iPartition) {
            return this.isPartitionEndangered(this.getPartitionOwnership(iPartition));
        }

        protected boolean isPartitionEndangered(Ownership owners) {
            int cBackups = this.getActualBackupCount();
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                if (owners.getOwner(iStore) != 0) continue;
                return true;
            }
            return false;
        }

        protected PartitionSet collectEndangered(PartitionSet parts) {
            PartitionSet partsEndangered = new PartitionSet(parts.getPartitionCount());
            int iPart = parts.next(0);
            while (iPart >= 0) {
                if (this.isPartitionEndangered(iPart)) {
                    partsEndangered.add(iPart);
                }
                iPart = parts.next(iPart + 1);
            }
            return partsEndangered;
        }

        protected PartitionSet ensureUpdatedPartitions() {
            PartitionSet partsUpdated = this.getUpdatedPartitions();
            if (partsUpdated == null) {
                this.m_partsUpdated = partsUpdated = new PartitionSet(SimpleAssignmentStrategy.this.getPartitionCount());
            }
            return partsUpdated;
        }

        public int getOwnedIndex(Member member, int iPartition) {
            Ownership owners = this.getPartitionOwnership(iPartition);
            int cBackups = SimpleAssignmentStrategy.this.getBackupCount();
            int nMember = member.getId();
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                if (owners.getOwner(iStore) != nMember) continue;
                return iStore;
            }
            return -1;
        }

        public PartitionSet getOwnedPartitions(Member member, int iStore) {
            PartitionSet parts;
            PartitionSet[] aParts = (PartitionSet[])this.m_mapOwnedPartitions.get(member);
            if (aParts == null) {
                aParts = new PartitionSet[1 + SimpleAssignmentStrategy.this.getBackupCount()];
                this.m_mapOwnedPartitions.put(member, aParts);
            }
            if ((parts = aParts[iStore]) == null) {
                aParts[iStore] = parts = SimpleAssignmentStrategy.this.getManager().getOwnedPartitions(member, iStore);
            }
            return parts;
        }

        public Ownership getPartitionOwnership(int iPartition) {
            Ownership owners = this.m_aOwners[iPartition];
            if (owners == null) {
                this.m_aOwners[iPartition] = owners = SimpleAssignmentStrategy.this.getManager().getPartitionOwnership(iPartition);
            }
            return owners;
        }

        protected int getPartitionLoad(int iPartition, boolean fPrimary) {
            return (fPrimary ? this.getPrimaryLoadCalculator() : this.getBackupLoadCalculator()).getLoad(iPartition);
        }

        protected int getMemberLoad(Member member, boolean fPrimary) {
            if (fPrimary) {
                return this.getPrimaryLoadCalculator().getLoad(this.getOwnedPartitions(member, 0));
            }
            LoadCalculator calculator = this.getBackupLoadCalculator();
            int cBackups = SimpleAssignmentStrategy.this.getBackupCount();
            int cLoad = 0;
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                cLoad += calculator.getLoad(this.getOwnedPartitions(member, iStore));
            }
            return cLoad;
        }

        protected void transitionPartition(int iPartition, int iStore, Member memberFrom, Member memberTo) {
            int nMemberTo = memberTo == null ? 0 : memberTo.getId();
            int cBackups = SimpleAssignmentStrategy.this.getBackupCount();
            Ownership owners = this.getPartitionOwnership(iPartition);
            if (memberFrom != null) {
                this.getOwnedPartitions(memberFrom, iStore).remove(iPartition);
            }
            if (memberTo != null) {
                this.getOwnedPartitions(memberTo, iStore).add(iPartition);
            }
            block0: for (int i = 0; i <= cBackups; ++i) {
                if (i == iStore) {
                    owners.setOwner(iStore, nMemberTo);
                    if (iStore != 0 || memberTo == null || memberFrom == null || this.isMemberLeaving(memberFrom)) continue;
                    for (int j = 1; j <= cBackups; ++j) {
                        Member memberBackup = SimpleAssignmentStrategy.this.getMember(owners.getOwner(j));
                        if (memberTo.getMachineId() == memberFrom.getMachineId() || memberBackup != null && memberTo.getMachineId() != memberBackup.getMachineId()) continue;
                        this.getOwnedPartitions(memberFrom, j).add(iPartition);
                        if (memberBackup != null) {
                            this.getOwnedPartitions(memberBackup, j).remove(iPartition);
                        }
                        owners.setOwner(j, memberFrom.getId());
                        continue block0;
                    }
                    continue;
                }
                if (nMemberTo == 0 || owners.getOwner(i) != nMemberTo) continue;
                owners.setOwner(i, 0);
                this.getOwnedPartitions(memberTo, i).remove(iPartition);
            }
            this.ensureUpdatedPartitions().add(iPartition);
        }

        protected boolean suggestDistribution() {
            PartitionSet partsUpdated = this.getUpdatedPartitions();
            if (partsUpdated == null) {
                return false;
            }
            int cPartitions = SimpleAssignmentStrategy.this.getPartitionCount();
            HashMap<Ownership, PartitionSet> mapOwnership = new HashMap<Ownership, PartitionSet>();
            DistributionManager manager = SimpleAssignmentStrategy.this.getManager();
            int iPart = partsUpdated.next(0);
            while (iPart >= 0) {
                Ownership owners = this.getPartitionOwnership(iPart);
                PartitionSet parts = (PartitionSet)mapOwnership.get(owners);
                if (parts == null) {
                    parts = new PartitionSet(cPartitions);
                    mapOwnership.put(owners, parts);
                }
                if (!owners.equals(manager.getPartitionOwnership(iPart))) {
                    parts.add(iPart);
                }
                iPart = partsUpdated.next(iPart + 1);
            }
            for (Map.Entry entry : mapOwnership.entrySet()) {
                Ownership owners = (Ownership)entry.getKey();
                PartitionSet parts = (PartitionSet)entry.getValue();
                if (parts.isEmpty()) continue;
                manager.suggest(parts, owners);
            }
            return true;
        }

        protected String reportState() {
            int cBackups = SimpleAssignmentStrategy.this.getBackupCount();
            StringBuilder sb = new StringBuilder();
            for (Member member : this.getOwnershipMembers()) {
                sb.append("Member ").append(member.getId()).append("\n");
                for (int iStore = 0; iStore <= cBackups; ++iStore) {
                    PartitionSet parts = this.getOwnedPartitions(member, iStore);
                    sb.append(iStore == 0 ? "Primary (" : "Backup[" + iStore + "] (").append(parts.cardinality()).append("): ").append(parts).append("\n");
                }
                sb.append("\n\n");
            }
            return sb.toString();
        }

        public Filter instantiateNotOwnedFilter(Ownership owners) {
            return new NotOwnedFilter(owners);
        }

        public Filter instantiateSafetyFilter(Ownership owners) {
            return new SafetyFilter(owners);
        }

        public Filter instantiateOverloadedFilter(boolean fPrimary) {
            return new NotFilter(new UnderloadedFilter(fPrimary));
        }

        public Filter instantiateUnderloadedFilter(boolean fPrimary) {
            return new UnderloadedFilter(fPrimary);
        }

        public LoadComparator instantiateLoadComparator(boolean fPrimary) {
            return new LoadComparator(fPrimary);
        }

        public StrengthComparator instantiateStrengthComparator(Ownership owners) {
            return new StrengthComparator(owners);
        }

        public class StrengthComparator
        implements Comparator {
            protected Ownership m_owners;

            public StrengthComparator(Ownership owners) {
                this.m_owners = owners;
            }

            public Ownership getOwnership() {
                return this.m_owners;
            }

            public int compare(Object o1, Object o2) {
                return this.getDistance((Member)o2) - this.getDistance((Member)o1);
            }

            protected int getDistance(Member member) {
                Ownership owners = this.getOwnership();
                int cBackups = owners.getBackupCount();
                int nDistance = 0;
                for (int iStore = 0; iStore <= cBackups; ++iStore) {
                    int nOwner = owners.getOwner(iStore);
                    if (nOwner == 0) continue;
                    int n = this.getDistance(member, SimpleAssignmentStrategy.this.getMember(nOwner));
                    nDistance += n * n;
                }
                return nDistance;
            }

            protected int getDistance(Member member1, Member member2) {
                if (!Base.equals(member1.getSiteName(), member2.getSiteName())) {
                    return 4;
                }
                if (!Base.equals(member1.getRackName(), member2.getRackName())) {
                    return 3;
                }
                if (member1.getMachineId() != member2.getMachineId()) {
                    return 2;
                }
                if (member1.getId() != member2.getId()) {
                    return 1;
                }
                Base.azzert(member1 == member2);
                return 0;
            }
        }

        public class LoadComparator
        implements Comparator {
            protected int m_cFairShare;
            protected boolean m_fPrimary;

            public LoadComparator(boolean fPrimary) {
                this.m_cFairShare = AnalysisContext.this.getFairShare(fPrimary);
                this.m_fPrimary = fPrimary;
            }

            public int getFairShare() {
                return this.m_cFairShare;
            }

            public boolean isPrimary() {
                return this.m_fPrimary;
            }

            public int compare(Object o1, Object o2) {
                Member member1 = (Member)o1;
                Member member2 = (Member)o2;
                boolean fPrimary = this.isPrimary();
                int cLoad1 = AnalysisContext.this.getMemberLoad(member1, fPrimary);
                int cLoad2 = AnalysisContext.this.getMemberLoad(member2, fPrimary);
                return cLoad1 - cLoad2;
            }
        }

        public class UnderloadedFilter
        implements Filter {
            protected int m_cFairShare;
            protected boolean m_fPrimary;

            protected UnderloadedFilter(boolean fPrimary) {
                this.m_fPrimary = fPrimary;
                this.m_cFairShare = AnalysisContext.this.getFairShare(fPrimary);
            }

            public boolean isPrimary() {
                return this.m_fPrimary;
            }

            public int getFairShare() {
                return this.m_cFairShare;
            }

            @Override
            public boolean evaluate(Object o) {
                return AnalysisContext.this.getMemberLoad((Member)o, this.isPrimary()) < this.getFairShare();
            }
        }

        public class SafetyFilter
        implements Filter {
            protected Ownership m_owners;

            public SafetyFilter(Ownership owners) {
                this.m_owners = owners;
            }

            public Ownership getOwnership() {
                return this.m_owners;
            }

            @Override
            public boolean evaluate(Object o) {
                return AnalysisContext.this.isStrong((Member)o, this.getOwnership());
            }
        }

        public class NotOwnedFilter
        implements Filter {
            protected Ownership m_owners;

            public NotOwnedFilter(Ownership owners) {
                this.m_owners = owners;
            }

            public Ownership getOwnership() {
                return this.m_owners;
            }

            @Override
            public boolean evaluate(Object o) {
                Ownership owners = this.getOwnership();
                int nMember = ((Member)o).getId();
                int cBackups = AnalysisContext.this.getActualBackupCount();
                for (int iStore = 0; iStore <= cBackups; ++iStore) {
                    if (owners.getOwner(iStore) != nMember) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public static class SimpleLoadCalculator
    implements LoadCalculator {
        @Override
        public int getLoad(int nPartition) {
            return 1;
        }

        @Override
        public int getLoad(PartitionSet parts) {
            return parts.cardinality();
        }
    }

    public static interface LoadCalculator {
        public int getLoad(int var1);

        public int getLoad(PartitionSet var1);
    }
}

