/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.ssl;

import com.tangosol.net.WrapperSelector;
import com.tangosol.net.WrapperSocket;
import com.tangosol.net.WrapperSocketChannel;
import com.tangosol.net.ssl.SSLSocketProvider;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SSLSocketChannel
extends WrapperSocketChannel {
    protected final SSLEngine m_engine;
    protected boolean m_fBlocking;
    protected final ByteBuffer[] m_aBuffSingleInbound = new ByteBuffer[1];
    protected final ByteBuffer[] m_aBuffSingleOutbound = new ByteBuffer[1];
    protected ByteBuffer m_buffEncOut;
    protected ByteBuffer m_buffEncIn;
    protected ByteBuffer m_buffClearIn;
    protected ByteBuffer[] m_aBuffClear = new ByteBuffer[1];
    protected SSLSelectionKey m_keyFirst;
    protected boolean m_fHandshaking;
    protected int m_cJobsPending;
    protected static final ByteBuffer[] s_aBuffEmpty = new ByteBuffer[]{ByteBuffer.allocate(0)};

    protected SSLSocketChannel(SocketChannel channel, SSLSocketProvider provider) throws IOException {
        super(channel, provider);
        SSLEngine engine = provider.openSSLEngine();
        boolean fConnected = channel.isConnected();
        engine.setUseClientMode(!fConnected);
        this.m_engine = engine;
        this.m_delegate = channel;
        this.m_fBlocking = channel.isBlocking();
        int cbPacket = engine.getSession().getPacketBufferSize();
        ByteBuffer buffOut = this.m_buffEncOut = ByteBuffer.allocate(cbPacket);
        buffOut.flip();
        ByteBuffer buffIn = this.m_buffEncIn = ByteBuffer.allocate(cbPacket);
        buffIn.flip();
        ByteBuffer buffClear = this.m_buffClearIn = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
        buffClear.flip();
        this.m_aBuffClear[0] = buffClear;
    }

    @Override
    protected Socket wrapSocket(Socket socket) {
        return new WrapperSocket(socket){

            @Override
            public void shutdownInput() throws IOException {
                throw new UnsupportedOperationException("The method shutdownInput() is not supported in SSLSocket");
            }

            @Override
            public void shutdownOutput() throws IOException {
                throw new UnsupportedOperationException("The method shutdownInput() is not supported in SSLSocket");
            }

            @Override
            public SocketChannel getChannel() {
                return SSLSocketChannel.this;
            }

            @Override
            public void close() throws IOException {
                SSLSocketChannel.this.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        ByteBuffer[] aBuffRead;
        ByteBuffer[] byteBufferArray = aBuffRead = this.m_aBuffSingleInbound;
        synchronized (aBuffRead) {
            int cb;
            try {
                aBuffRead[0] = dst;
                cb = (int)this.readInternal(aBuffRead, 0, 1);
            }
            finally {
                aBuffRead[0] = null;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (cb == 0) {
                return this.runProtocol() ? 0 : -1;
            }
            if (cb == -1) {
                this.onEndOfStream();
            }
            return cb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        ByteBuffer[] aBuffWrite;
        ByteBuffer[] byteBufferArray = aBuffWrite = this.m_aBuffSingleOutbound;
        synchronized (aBuffWrite) {
            int cb;
            try {
                aBuffWrite[0] = src;
                cb = (int)this.writeInternal(aBuffWrite, 0, 1);
            }
            finally {
                aBuffWrite[0] = null;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return cb == 0 && !this.runProtocol() ? -1 : cb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        ByteBuffer[] byteBufferArray = this.m_aBuffSingleInbound;
        synchronized (this.m_aBuffSingleInbound) {
            long cb = this.readInternal(dsts, offset, length);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            if (cb == 0L) {
                return this.runProtocol() ? 0L : -1L;
            }
            if (cb == -1L) {
                this.onEndOfStream();
            }
            return cb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        ByteBuffer[] byteBufferArray = this.m_aBuffSingleOutbound;
        synchronized (this.m_aBuffSingleOutbound) {
            long cb = this.writeInternal(srcs, offset, length);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return cb == 0L && !this.runProtocol() ? -1L : cb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        ByteBuffer[] byteBufferArray = this.m_aBuffSingleOutbound;
        synchronized (this.m_aBuffSingleOutbound) {
            ByteBuffer[] byteBufferArray2 = this.m_aBuffSingleInbound;
            synchronized (this.m_aBuffSingleInbound) {
                boolean fInterrupted = Thread.interrupted();
                SSLSelectionKey key = this.m_keyFirst;
                while (key != null) {
                    key.setDataReadyOps(0);
                    key.setProtocolReadyOps(0);
                    key = key.m_keyNext;
                }
                try {
                    this.closeOutbound();
                }
                finally {
                    this.m_delegate.close();
                }
                if (fInterrupted) {
                    throw new InterruptedIOException();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        if (block) {
            throw new IllegalBlockingModeException();
        }
        super.implConfigureBlocking(block);
        this.m_fBlocking = block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WrapperSelector.WrapperSelectionKey registerInternal(WrapperSelector selector, int ops, Object att) throws IOException {
        SSLSelectionKey key = new SSLSelectionKey(selector, this.m_delegate.register(selector.getDelegate(), ops), att);
        ByteBuffer[] byteBufferArray = this.m_aBuffSingleInbound;
        synchronized (this.m_aBuffSingleInbound) {
            key.m_keyNext = this.m_keyFirst;
            this.m_keyFirst = key;
            if (this.m_buffClearIn.hasRemaining()) {
                this.markKeysReadable(true);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.runProtocol();
            return key;
        }
    }

    public String toString() {
        return "SSLSocketChannel(" + this.m_socket + ", buffered{clear=" + this.m_buffClearIn.remaining() + " encrypted=" + this.m_buffEncIn.remaining() + " out=" + this.m_buffEncOut.remaining() + "}, handshake=" + (Object)((Object)this.m_engine.getHandshakeStatus()) + ", jobs=" + this.m_cJobsPending + ")";
    }

    protected long readInternal(ByteBuffer[] aBuffDst, int ofBuff, int cBuff) throws IOException {
        if (this.m_fBlocking) {
            throw new IllegalBlockingModeException();
        }
        long cbFill = 0L;
        int cbRead = 0;
        ByteBuffer buffEnd = aBuffDst[ofBuff + cBuff - 1];
        int ofEnd = ofBuff + cBuff;
        while (ofBuff < ofEnd) {
            cbFill += (long)this.drainClearBuffer(aBuffDst, ofBuff, ofEnd);
            if (buffEnd.hasRemaining()) {
                cbFill += (long)this.decrypt(aBuffDst, ofBuff, ofEnd);
                if (buffEnd.hasRemaining()) {
                    this.fillClearBuffer();
                    cbRead = this.readEncrypted();
                    if (cbRead <= 0) {
                        cbFill += (long)this.drainClearBuffer(aBuffDst, ofBuff, ofEnd);
                        break;
                    }
                }
            }
            ofBuff += this.advance(aBuffDst, ofBuff, ofEnd);
        }
        boolean fMore = this.m_buffClearIn.hasRemaining() || this.fillClearBuffer() > 0;
        this.markKeysReadable(fMore);
        if (cbFill == 0L && cbRead == -1 && !fMore) {
            return -1L;
        }
        return cbFill;
    }

    protected long writeInternal(ByteBuffer[] aBuffSrc, int ofBuff, int cBuff) throws IOException {
        if (this.m_fBlocking) {
            throw new IllegalBlockingModeException();
        }
        long cbFill = 0L;
        int ofEnd = ofBuff + cBuff;
        while (ofBuff < ofEnd) {
            cbFill += (long)this.encrypt(aBuffSrc, ofBuff, ofEnd);
            if (this.writeEncrypted() == 0) break;
            ofBuff += this.advance(aBuffSrc, ofBuff, ofEnd);
        }
        return cbFill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int encrypt(ByteBuffer[] aBuffSrc, int ofBuff, int ofEnd) throws IOException {
        ByteBuffer buffDst = this.m_buffEncOut;
        int ofPos = buffDst.position();
        int ofLimit = buffDst.limit();
        int cbAdded = 0;
        try {
            if (ofPos == ofLimit) {
                buffDst.clear();
                ofLimit = 0;
                ofPos = 0;
            } else {
                buffDst.limit(buffDst.capacity()).position(ofLimit);
            }
            if (this.m_cJobsPending == 0) {
                SSLEngineResult result = this.m_engine.wrap(aBuffSrc, ofBuff, ofEnd - ofBuff, buffDst);
                cbAdded = result.bytesProduced();
                int n = result.bytesConsumed();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            buffDst.position(ofPos).limit(ofLimit + cbAdded);
        }
    }

    protected int decrypt(ByteBuffer[] aBuffDst, int ofBuff, int ofEnd) throws IOException {
        ByteBuffer buffSrc = this.m_buffEncIn;
        SSLEngineResult result = this.m_engine.unwrap(buffSrc, aBuffDst, ofBuff, ofEnd - ofBuff);
        int cb = result.bytesProduced();
        if (cb == 0 && result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW && buffSrc.limit() == buffSrc.capacity()) {
            buffSrc.compact().flip();
        }
        return cb;
    }

    protected void closeOutbound() {
        this.m_engine.closeOutbound();
        try {
            ByteBuffer buffOut = this.m_buffEncOut;
            ByteBuffer[] aBuffIn = s_aBuffEmpty;
            int cb = buffOut.remaining();
            int cbLast = -1;
            while (cb != cbLast) {
                this.writeInternal(aBuffIn, 0, 1);
                cbLast = cb;
                cb = buffOut.remaining();
            }
        }
        catch (NotYetConnectedException e) {
        }
        catch (IllegalBlockingModeException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEndOfStream() throws IOException {
        ByteBuffer[] byteBufferArray = this.m_aBuffSingleOutbound;
        synchronized (this.m_aBuffSingleOutbound) {
            ByteBuffer[] byteBufferArray2 = this.m_aBuffSingleInbound;
            synchronized (this.m_aBuffSingleInbound) {
                if (this.m_engine.getSession().isValid()) {
                    try {
                        this.m_engine.closeInbound();
                        this.closeOutbound();
                    }
                    catch (SSLException sSLException) {}
                } else {
                    throw new SSLException("invalid session");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean runProtocol() throws IOException {
        SSLEngine engine = this.m_engine;
        ByteBuffer[] aBuffEmpty = s_aBuffEmpty;
        final ByteBuffer[] oRead = this.m_aBuffSingleInbound;
        final ByteBuffer[] oWrite = this.m_aBuffSingleOutbound;
        block25: while (true) {
            switch (engine.getHandshakeStatus()) {
                case NEED_TASK: {
                    ByteBuffer[] byteBufferArray;
                    this.m_fHandshaking = true;
                    final Runnable runnable = engine.getDelegatedTask();
                    if (runnable == null) {
                        byteBufferArray = oRead;
                        // MONITORENTER : oRead
                        if (this.m_cJobsPending > 0) {
                            this.delayProtocol(0, 4, 5);
                        }
                        // MONITOREXIT : byteBufferArray
                        return true;
                    }
                    Runnable task = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                runnable.run();
                            }
                            finally {
                                Object object = oWrite;
                                synchronized (object) {
                                    Object object2 = oRead;
                                    synchronized (object2) {
                                        --SSLSocketChannel.this.m_cJobsPending;
                                        SSLSocketChannel.this.continueProtocol();
                                    }
                                }
                            }
                        }
                    };
                    ByteBuffer[] byteBufferArray2 = oWrite;
                    // MONITORENTER : oWrite
                    ByteBuffer[] byteBufferArray3 = oRead;
                    // MONITORENTER : oRead
                    ++this.m_cJobsPending;
                    // MONITOREXIT : byteBufferArray3
                    // MONITOREXIT : byteBufferArray2
                    try {
                        ((SSLSocketProvider)this.provider()).getExecutor().execute(task);
                        task = null;
                    }
                    catch (RejectedExecutionException e) {}
                    continue block25;
                    finally {
                        if (task == null) continue block25;
                        task.run();
                        continue block25;
                    }
                }
                case NEED_WRAP: {
                    ByteBuffer[] byteBufferArray3;
                    this.m_fHandshaking = true;
                    ByteBuffer[] byteBufferArray = oWrite;
                    // MONITORENTER : oWrite
                    this.encrypt(aBuffEmpty, 0, 0);
                    int cbWrite = this.writeEncrypted();
                    if (cbWrite == 0) {
                        byteBufferArray3 = oRead;
                        // MONITORENTER : oRead
                        this.delayProtocol(4, 0, 1);
                        // MONITOREXIT : byteBufferArray3
                        // MONITOREXIT : byteBufferArray
                        return true;
                    }
                    // MONITOREXIT : byteBufferArray
                    break;
                }
                case NEED_UNWRAP: {
                    this.m_fHandshaking = true;
                    ByteBuffer[] byteBufferArray = oRead;
                    // MONITORENTER : oRead
                    int cbRead = this.readEncrypted();
                    int cbFill = this.fillClearBuffer();
                    if (cbRead == 0 && cbFill == 0) {
                        this.delayProtocol(1, 4, 4);
                        // MONITOREXIT : byteBufferArray
                        return true;
                    }
                    // MONITOREXIT : byteBufferArray
                    if (cbRead != -1) continue block25;
                    this.onEndOfStream();
                    return false;
                }
                case NOT_HANDSHAKING: 
                case FINISHED: {
                    if (!this.m_fHandshaking) return true;
                    ByteBuffer[] byteBufferArray = oRead;
                    // MONITORENTER : oRead
                    this.endProtocol();
                    this.m_fHandshaking = false;
                    // MONITOREXIT : byteBufferArray
                    return true;
                }
            }
        }
    }

    protected void delayProtocol(int nInterest, int nExclude, int nReady) {
        try {
            SSLSelectionKey key = this.m_keyFirst;
            while (key != null) {
                key.setProtocolReadyOps(nReady);
                key.interestProtocol(nInterest, nExclude);
                key = key.m_keyNext;
            }
        }
        catch (CancelledKeyException e) {
            // empty catch block
        }
    }

    protected void continueProtocol() {
        SSLSelectionKey key = this.m_keyFirst;
        while (key != null) {
            try {
                key.setProtocolReadyOps(5);
                key.interestProtocol(5, 0);
                key.selector().wakeup();
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
            key = key.m_keyNext;
        }
    }

    protected void endProtocol() throws IOException {
        try {
            SSLSelectionKey key = this.m_keyFirst;
            while (key != null) {
                key.setProtocolReadyOps(0);
                key.interestProtocol(0, 0);
                key = key.m_keyNext;
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
        this.validatePeer();
    }

    protected void validatePeer() throws SSLException {
        SSLSocketProvider provider = (SSLSocketProvider)this.provider();
        SSLSession session = this.m_engine.getSession();
        Socket socket = this.m_delegate.socket();
        try {
            provider.ensureSessionValidity(session, socket);
        }
        catch (SSLException e) {
            try {
                this.m_delegate.close();
            }
            catch (IOException eIEIO) {
                // empty catch block
            }
            throw e;
        }
    }

    protected int drainClearBuffer(ByteBuffer[] aBuffDst, int ofBuff, int ofEnd) throws IOException {
        ByteBuffer buffSrc = this.m_buffClearIn;
        byte[] abSrc = buffSrc.array();
        int ofSrc = buffSrc.arrayOffset() + buffSrc.position();
        int cbSrc = buffSrc.remaining();
        int cbAdded = 0;
        while (ofBuff < ofEnd && cbSrc > 0) {
            ByteBuffer buffDst = aBuffDst[ofBuff];
            int cb = Math.min(buffDst.remaining(), cbSrc);
            if (cb > 0) {
                buffDst.put(abSrc, ofSrc, cb);
                ofSrc += cb;
                cbAdded += cb;
                cbSrc -= cb;
            }
            ++ofBuff;
        }
        buffSrc.position(buffSrc.position() + cbAdded);
        return cbAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int fillClearBuffer() throws IOException {
        ByteBuffer buffEnc = this.m_buffEncIn;
        ByteBuffer buffClear = this.m_buffClearIn;
        int ofPos = buffClear.position();
        int ofLim = buffClear.limit();
        int cb = 0;
        int cbStart = buffEnc.remaining();
        try {
            if (ofPos == ofLim) {
                buffClear.clear();
                ofLim = 0;
                ofPos = 0;
            } else {
                buffClear.position(buffClear.limit()).limit(buffClear.capacity());
            }
            cb = this.decrypt(this.m_aBuffClear, 0, 1);
            int n = cbStart - buffEnc.remaining();
            return n;
        }
        finally {
            buffClear.position(ofPos).limit(ofLim + cb);
        }
    }

    protected int writeEncrypted() throws IOException {
        return this.m_delegate.write(this.m_buffEncOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readEncrypted() throws IOException {
        int n;
        ByteBuffer buff = this.m_buffEncIn;
        int ofPos = buff.position();
        int ofLimit = buff.limit();
        int cbRead = 0;
        try {
            if (ofLimit == ofPos) {
                buff.clear();
                ofPos = 0;
                ofLimit = 0;
            } else {
                buff.position(buff.limit()).limit(buff.capacity());
            }
            n = cbRead = this.m_delegate.read(buff);
            buff.position(ofPos).limit(ofLimit + (cbRead < 0 ? 0 : cbRead));
        }
        catch (Throwable throwable) {
            buff.position(ofPos).limit(ofLimit + (cbRead < 0 ? 0 : cbRead));
            throw throwable;
        }
        return n;
    }

    protected int advance(ByteBuffer[] aBuff, int ofBuff, int ofEnd) {
        int c = 0;
        while (ofBuff < ofEnd && !aBuff[ofBuff].hasRemaining()) {
            ++ofBuff;
            ++c;
        }
        return c;
    }

    protected void markKeysReadable(boolean fReadable) {
        SSLSelectionKey key = this.m_keyFirst;
        while (key != null) {
            if (fReadable) {
                key.setDataReadyOps(1);
                key.interestData(4);
            } else {
                key.setDataReadyOps(0);
                key.interestData(0);
            }
            key = key.m_keyNext;
        }
    }

    public class SSLSelectionKey
    extends WrapperSelector.WrapperSelectionKey {
        protected int m_nOpsInterestApp;
        protected int m_nOpsReadyData;
        protected int m_nOpsInterestData;
        protected int m_nOpsInterestProtocol;
        protected int m_nOpsReadyProtocol;
        protected int m_nOpsInterestExclude;
        protected SSLSelectionKey m_keyNext;

        protected SSLSelectionKey(WrapperSelector selector, SelectionKey key, Object att) {
            super(selector, key, att);
            this.m_nOpsInterestApp = key == null ? 0 : key.interestOps();
        }

        protected void setDataReadyOps(int nOps) {
            this.m_nOpsReadyData = nOps;
        }

        protected int getDataReadyOps() {
            return this.m_nOpsReadyData;
        }

        protected synchronized SSLSelectionKey interestData(int nOps) {
            if (nOps != this.m_nOpsInterestData) {
                this.m_delegate.interestOps((nOps | this.m_nOpsInterestApp | this.m_nOpsInterestProtocol) & ~this.m_nOpsInterestExclude);
                this.m_nOpsInterestData = nOps;
            }
            return this;
        }

        protected int interestData() {
            return this.m_nOpsInterestData;
        }

        protected void setProtocolReadyOps(int nOps) {
            this.m_nOpsReadyProtocol = nOps;
        }

        protected int getProtocolReadyOps() {
            return this.m_nOpsReadyProtocol;
        }

        protected synchronized SSLSelectionKey interestProtocol(int nOps, int nExclusions) {
            if (nOps != this.m_nOpsInterestProtocol || nExclusions != this.m_nOpsInterestExclude) {
                this.m_delegate.interestOps((nOps | this.m_nOpsInterestApp | this.m_nOpsInterestData) & ~nExclusions);
                this.m_nOpsInterestProtocol = nOps;
                this.m_nOpsInterestExclude = nExclusions;
            }
            return this;
        }

        protected int interestProtocol() {
            return this.m_nOpsInterestProtocol;
        }

        @Override
        public SelectableChannel channel() {
            return SSLSocketChannel.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            this.m_delegate.cancel();
            ByteBuffer[] byteBufferArray = SSLSocketChannel.this.m_aBuffSingleInbound;
            synchronized (SSLSocketChannel.this.m_aBuffSingleInbound) {
                SSLSelectionKey keyPrev = null;
                SSLSelectionKey keyCurr = SSLSocketChannel.this.m_keyFirst;
                while (keyCurr != null) {
                    if (keyCurr == this) {
                        if (keyPrev == null) {
                            SSLSocketChannel.this.m_keyFirst = this.m_keyNext;
                        } else {
                            keyPrev.m_keyNext = this.m_keyNext;
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    keyPrev = keyCurr;
                    keyCurr = keyCurr.m_keyNext;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public int interestOps() {
            return this.m_nOpsInterestApp;
        }

        @Override
        public synchronized SelectionKey interestOps(int ops) {
            this.m_delegate.interestOps((ops | this.m_nOpsInterestData | this.m_nOpsInterestProtocol) & ~this.m_nOpsInterestExclude);
            this.m_nOpsInterestApp = ops;
            return this;
        }

        @Override
        public int readyOps() {
            int nReady = this.m_delegate.readyOps();
            int nReturn = (nReady | this.m_nOpsReadyData | this.m_nOpsReadyProtocol) & this.m_nOpsInterestApp;
            return nReady == 0 ? 0 : (nReturn == 0 ? this.m_nOpsInterestApp : nReturn);
        }

        @Override
        public String toString() {
            return "SSLSelectionKey(" + this.getKeyString(this) + ", delegate{" + this.getKeyString(this.m_delegate) + "}, data{interest=" + this.interestData() + " ready=" + this.getDataReadyOps() + "}, protocol{interest=" + this.interestProtocol() + " ready=" + this.getProtocolReadyOps() + "}, exclude=" + this.m_nOpsInterestExclude + ", " + SSLSocketChannel.this + ")";
        }
    }
}

