/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.SimpleAdapter;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeAdapter
extends SimpleAdapter {
    private static boolean s_fForceUTC = true;
    private static TimeZone s_tzUTC;
    private static SimpleDateFormat s_formatter;
    private static String[] s_asPattern;

    public DateTimeAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        super(infoBean, clzType, sName, sXml, xml);
        DateTimeAdapter.azzert(clzType == Date.class);
    }

    @Override
    public boolean isCloneRequired() {
        return true;
    }

    @Override
    public Object fromXml(XmlElement xml) {
        String sDate = xml.getString(null);
        if (sDate == null) {
            return null;
        }
        try {
            return DateTimeAdapter.parse(sDate);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    @Override
    public XmlElement toXml(Object o) {
        return o == null ? null : super.toXml(DateTimeAdapter.format((Date)o));
    }

    @Override
    public Object fromUri(String sUri) {
        sUri = sUri.replace('c', ':').replace('p', '+');
        try {
            return DateTimeAdapter.parse(sUri);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    @Override
    public String toUri(Object o) {
        String sUri = DateTimeAdapter.format((Date)o);
        return sUri.replace(':', 'c').replace('+', 'p');
    }

    @Override
    public Object readExternal(DataInput in) throws IOException {
        return new Date(DateTimeAdapter.readLong(in));
    }

    @Override
    public void writeExternal(DataOutput out, Object o) throws IOException {
        DateTimeAdapter.writeLong(out, ((Date)o).getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parse(String sDate) throws ParseException {
        SimpleDateFormat parser = s_formatter;
        String[] asPattern = s_asPattern;
        SimpleDateFormat simpleDateFormat = parser;
        synchronized (simpleDateFormat) {
            TimeZone tz;
            ParsePosition pos = new ParsePosition(0);
            parser.applyPattern(asPattern[0]);
            Date date = parser.parse(sDate, pos);
            int ofErr = pos.getErrorIndex();
            int ofZone = ofErr < 0 ? pos.getIndex() : ofErr;
            int chZone = ofZone < sDate.length() ? (int)sDate.charAt(ofZone) : 63;
            TimeZone tzOrig = parser.getTimeZone();
            switch (chZone) {
                case 90: {
                    tz = TimeZone.getTimeZone("UTC");
                    break;
                }
                case 43: 
                case 45: {
                    tz = TimeZone.getTimeZone("GMT" + sDate.substring(ofZone));
                    break;
                }
                default: {
                    throw new ParseException("Invalid zone format: " + sDate, ofZone);
                }
            }
            if (date == null || !tzOrig.hasSameRules(tz)) {
                ParseException exceptionFormat = null;
                sDate = sDate.substring(0, ofZone);
                parser.setTimeZone(tz);
                try {
                    int c = asPattern.length;
                    for (int i = 0; i < c; ++i) {
                        try {
                            parser.applyPattern(asPattern[i]);
                            date = s_formatter.parse(sDate);
                            break;
                        }
                        catch (ParseException e) {
                            exceptionFormat = e;
                            continue;
                        }
                    }
                }
                finally {
                    parser.setTimeZone(tzOrig);
                }
                if (date == null) {
                    throw exceptionFormat == null ? new ParseException("Failed to parse: " + sDate, 0) : exceptionFormat;
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Date date) {
        SimpleDateFormat formatter;
        SimpleDateFormat simpleDateFormat = formatter = s_formatter;
        synchronized (simpleDateFormat) {
            formatter.applyPattern(s_asPattern[0]);
            StringBuffer sb = new StringBuffer(formatter.format(date));
            Calendar calendar = formatter.getCalendar();
            int iOffset = calendar.get(15) + calendar.get(16);
            if (iOffset == 0) {
                sb.append('Z');
            } else {
                DecimalFormat df = new DecimalFormat("00");
                int nMin = Math.abs((iOffset /= 60000) % 60);
                int nHour = Math.abs(iOffset / 60);
                sb.append(iOffset >= 0 ? (char)'+' : '-').append(df.format(nHour)).append(':').append(df.format(nMin));
            }
            return sb.toString();
        }
    }

    static {
        s_asPattern = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyyMMdd'T'HHmmss"};
        s_formatter = new SimpleDateFormat();
        s_tzUTC = TimeZone.getTimeZone("UTC");
        if (s_fForceUTC) {
            s_formatter.setTimeZone(s_tzUTC);
        }
    }
}

