/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.SyntaxException;
import com.tangosol.net.CacheFactory;
import com.tangosol.run.xml.SaxParser;
import com.tangosol.run.xml.SimpleDocument;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlToken;
import com.tangosol.run.xml.XmlTokenizer;
import com.tangosol.util.Base;
import com.tangosol.util.ErrorList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class SimpleParser
extends Base {
    protected final boolean m_fValidate;
    protected XmlTokenizer m_toker;
    protected XmlToken m_token;
    private static final String XML_DEFAULT_ENCODING = "UTF-8";

    public SimpleParser() {
        this(true);
    }

    public SimpleParser(boolean fValidate) {
        boolean fDisable = Boolean.getBoolean("tangosol.xml.validation.disable");
        if (fDisable && fValidate) {
            CacheFactory.log("XML validation disabled", 3);
        }
        this.m_fValidate = !fDisable && fValidate;
    }

    protected void init() {
        this.m_toker = null;
        this.m_token = null;
    }

    public XmlDocument parseXml(String sXml) throws IOException {
        return this.parseXml(sXml, null);
    }

    public XmlDocument parseXml(Reader reader) throws IOException {
        return this.parseXml(SimpleParser.read(reader), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument parseXml(InputStream stream) throws IOException {
        XmlDocument doc;
        ByteArrayInputStream in = new ByteArrayInputStream(SimpleParser.read(stream));
        try {
            ((InputStream)in).mark(0);
            try {
                doc = this.parseXml(in, XML_DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                ((InputStream)in).reset();
                doc = this.parseXml(new InputStreamReader(in));
            }
            String sEncoding = doc.getEncoding();
            if (sEncoding != null && !sEncoding.equalsIgnoreCase(XML_DEFAULT_ENCODING)) {
                ((InputStream)in).reset();
                try {
                    doc = this.parseXml(in, sEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    CacheFactory.log("Could not parse XML with encoding " + sEncoding, 2);
                }
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return doc;
    }

    public XmlDocument parseXml(InputStream stream, String sCharset) throws IOException {
        return this.parseXml(new InputStreamReader(stream, sCharset));
    }

    public synchronized XmlDocument parseXml(String sXml, XmlDocument xml) throws IOException {
        SimpleParser.azzert(sXml != null);
        if (xml == null) {
            xml = this.instantiateDocument();
        }
        this.init();
        ErrorList errlist = new ErrorList();
        try {
            this.m_toker = new XmlTokenizer(sXml, errlist);
            this.m_token = this.next();
            this.parseDocument(xml);
        }
        catch (Exception e) {
            String s = "Exception occurred during parsing: " + e.getMessage();
            if (!errlist.isEmpty()) {
                s = s + "\nLogged errors:\n" + errlist;
            }
            throw new IOException(s, e);
        }
        if (this.m_fValidate) {
            try {
                new SaxParser().validateXsd(sXml, xml);
            }
            catch (Exception e) {
                String s = "Exception occurred during schema validation: \n" + e.getMessage();
                throw new IOException(s, e);
            }
        }
        return xml;
    }

    protected XmlDocument instantiateDocument() {
        return new SimpleDocument();
    }

    public static void main(String[] asArgs) {
        try {
            String sFile = "TestXml.xml";
            try {
                sFile = asArgs[0];
            }
            catch (Exception e) {
                // empty catch block
            }
            File file = new File(sFile);
            SimpleParser.azzert(file.exists() && file.canRead());
            SimpleParser.out();
            SimpleParser.out("Original Document:");
            String sXml = new String(SimpleParser.read(file));
            SimpleParser.out(sXml);
            SimpleParser.out();
            SimpleParser.out("Parsing ...");
            XmlDocument xml = new SimpleParser().parseXml(sXml);
            SimpleParser.out();
            SimpleParser.out("Parsed Document:");
            sXml = ((Object)xml).toString();
            SimpleParser.out(sXml);
            SimpleParser.out();
            SimpleParser.out("Parsing the Parsed Document...");
            XmlDocument xml2 = new SimpleParser().parseXml(sXml);
            SimpleParser.out();
            SimpleParser.out("Re-parsed Document:");
            String sXml2 = ((Object)xml2).toString();
            SimpleParser.out(sXml2);
            SimpleParser.out();
            SimpleParser.out("Comparing:");
            SimpleParser.trace(((Object)xml).equals(xml2));
            SimpleParser.trace(sXml.equals(sXml2));
        }
        catch (Exception e) {
            SimpleParser.out("Exception occurred in test: " + e);
            SimpleParser.out(e);
        }
    }

    protected void parseDocument(XmlDocument xml) throws CompilerException {
        if (this.peek(6) != null) {
            this.parsePi(xml, true);
        }
        this.parseMisc(xml);
        if (this.peek(8) != null) {
            this.parseDoctype(xml);
        }
        this.parseMisc(xml);
        this.match(9);
        if (xml.getName() != null) {
            this.match(xml.getName());
        } else {
            String sName = this.match(1).getText();
            xml.setName(sName);
        }
        this.parseElement(xml);
        this.parseMisc(xml);
    }

    protected void parsePi(XmlElement xml) throws CompilerException {
        this.parsePi(xml, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parsePi(XmlElement xml, boolean fXmlDeclAllowed) throws CompilerException {
        XmlToken tokName = this.match(1);
        if (tokName.getText().equals("xml")) {
            if (!fXmlDeclAllowed) throw new SyntaxException("XML declaration can only appear at the beginning of a document");
            this.parseXmlDecl((XmlDocument)xml);
            return;
        } else {
            while (this.current().getID() != 7) {
            }
        }
    }

    protected void parseXmlDecl(XmlDocument xml) throws CompilerException {
        String sValue;
        if (this.peek("version") == null) {
            throw new SyntaxException("The version value is is missing from the XML declaration");
        }
        this.match(15);
        this.match(2);
        if (this.peek("encoding") != null) {
            this.match(15);
            sValue = this.match(2).getText();
            if (!XmlHelper.isEncodingValid(sValue)) {
                throw new SyntaxException("The encoding value in the XML declaration is illegal (" + sValue + ")");
            }
            xml.setEncoding(sValue);
        }
        if (this.peek("standalone") != null) {
            this.match(15);
            sValue = this.match(2).getText();
            if (!sValue.equals("yes") && !sValue.equals("no")) {
                throw new SyntaxException("The standalone value in the XML declaration must be 'yes' or 'no'");
            }
        }
        this.match(7);
    }

    protected void parseDoctype(XmlDocument xml) throws CompilerException {
        boolean fPublic;
        xml.setName(this.match(1).getText());
        boolean bl = fPublic = this.peek("PUBLIC") != null;
        if (fPublic) {
            String sName = this.match(2).getText();
            if (!XmlHelper.isPublicIdentifierValid(sName = XmlHelper.decodeAttribute(sName))) {
                throw new SyntaxException("The public identifier in the XML DOCTYPE is invalid (" + sName + ")");
            }
            xml.setDtdName(sName);
        }
        if (fPublic || this.peek("SYSTEM") != null) {
            String sUri = this.match(2).getText();
            if (!XmlHelper.isSystemIdentifierValid(sUri = XmlHelper.decodeUri(XmlHelper.decodeAttribute(sUri)))) {
                throw new SyntaxException("The system identifier in the XML DOCTYPE is invalid (" + sUri + ")");
            }
            xml.setDtdUri(sUri);
        }
        if (this.peek(16) != null) {
            while (this.current().getID() != 17) {
            }
        }
        this.match(10);
    }

    protected void parseElement(XmlElement xml) throws CompilerException {
        XmlToken token;
        while ((token = this.peek(1)) != null) {
            String sAttr = token.getText();
            if (!XmlHelper.isNameValid(sAttr)) {
                throw new SyntaxException("Illegal attribute name: " + sAttr);
            }
            this.match(15);
            String sValue = this.match(2).getText();
            sValue = XmlHelper.decodeAttribute(sValue);
            xml.addAttribute(sAttr).setString(sValue);
        }
        if (this.peek(12) != null) {
            return;
        }
        this.match(10);
        String sValue = null;
        block9: while (true) {
            XmlToken token2 = this.current();
            switch (token2.getID()) {
                case 13: {
                    this.parseComment(xml);
                    break;
                }
                case 6: {
                    this.parsePi(xml);
                    break;
                }
                case 3: {
                    String sChunk = (String)token2.getValue();
                    sChunk = XmlHelper.trim(sChunk);
                    if ((sChunk = XmlHelper.decodeContent(sChunk)).length() <= 0) continue block9;
                    if (sValue == null) {
                        sValue = sChunk;
                        break;
                    }
                    sValue = sValue + sChunk;
                    break;
                }
                case 4: {
                    String sChunk = (String)token2.getValue();
                    if (sValue == null) {
                        sValue = sChunk;
                        break;
                    }
                    sValue = sValue + sChunk;
                    break;
                }
                case 9: {
                    String sName = this.match(1).getText();
                    this.parseElement(xml.addElement(sName));
                    break;
                }
                case 11: {
                    if (sValue != null) {
                        xml.setString(sValue);
                    }
                    this.match(xml.getName());
                    this.match(10);
                    return;
                }
            }
        }
    }

    protected void parseMisc(XmlElement xml) throws CompilerException {
        while (true) {
            if (!this.hasCurrent()) {
                return;
            }
            if (this.peek(13) != null) {
                this.parseComment(xml, true);
                continue;
            }
            if (this.peek(6) == null) break;
            this.parsePi(xml);
        }
    }

    protected void parseComment(XmlElement xml) throws CompilerException {
        this.parseComment(xml, false);
    }

    protected void parseComment(XmlElement xml, boolean fIsDocument) throws CompilerException {
        String sComment;
        StringBuilder sb = new StringBuilder();
        boolean fFirst = true;
        int cchIndent = 0;
        int cDeferredBlanks = 0;
        while (this.peek(14) == null) {
            int of;
            sComment = this.match(5).getText();
            char[] ach = sComment.toCharArray();
            int cch = ach.length;
            if (fFirst) {
                cchIndent = 0;
                block10: for (int of2 = 0; of2 < cch; ++of2) {
                    switch (ach[of2]) {
                        case '\t': 
                        case ' ': {
                            ++cchIndent;
                            continue block10;
                        }
                        default: {
                            fFirst = false;
                            break block10;
                        }
                    }
                }
            }
            int ofStart = 0;
            if (cchIndent > 0) {
                block11: for (of = 0; of < cch && of < cchIndent; ++of) {
                    switch (ach[of]) {
                        case '\t': 
                        case ' ': {
                            ++ofStart;
                            continue block11;
                        }
                    }
                }
            }
            block12: for (of = cch - 1; of >= ofStart; --of) {
                switch (ach[of]) {
                    case '\t': 
                    case ' ': {
                        --cch;
                        continue block12;
                    }
                }
            }
            if (sb.length() > 0) {
                ++cDeferredBlanks;
            }
            if (ofStart >= cch) continue;
            for (int i = 0; i < cDeferredBlanks; ++i) {
                sb.append('\n');
            }
            cDeferredBlanks = 0;
            sb.append(ach, ofStart, cch);
        }
        if (sb.length() > 0) {
            if (fIsDocument) {
                XmlDocument doc = (XmlDocument)xml;
                String sComment2 = doc.getDocumentComment();
                sComment2 = sComment2 == null || sComment2.length() == 0 ? sb.toString() : sComment2 + '\n' + sb.toString();
                doc.setDocumentComment(sComment2);
            } else {
                sComment = xml.getComment();
                sComment = sComment == null || sComment.length() == 0 ? sb.toString() : sComment + '\n' + sb.toString();
                xml.setComment(sComment);
            }
        }
    }

    protected boolean hasCurrent() {
        return this.m_token != null;
    }

    protected XmlToken current() throws CompilerException {
        XmlToken current = this.m_token;
        this.next();
        return current;
    }

    protected boolean hasNext() {
        return this.m_toker.hasMoreTokens();
    }

    protected XmlToken next() throws CompilerException {
        XmlTokenizer toker = this.m_toker;
        if (toker.hasMoreTokens()) {
            this.m_token = (XmlToken)toker.nextToken();
            return this.m_token;
        }
        if (this.m_token == null) {
            throw new CompilerException("Invalid root element");
        }
        this.m_token = null;
        return null;
    }

    protected XmlToken match(int id) throws CompilerException {
        if (this.m_token.getID() != id) {
            throw new SyntaxException("looking for id=" + id + ", found id=" + this.m_token.getID() + '(' + this.m_token + ')');
        }
        return this.current();
    }

    protected XmlToken match(String sName) throws CompilerException {
        XmlToken token = this.peek(sName);
        if (token == null) {
            throw new SyntaxException("looking for name token=" + sName + ", found token=" + this.m_token);
        }
        return token;
    }

    protected XmlToken peek(int id) throws CompilerException {
        return this.m_token.getID() == id ? this.current() : null;
    }

    protected XmlToken peek(int cat, int subcat) throws CompilerException {
        XmlToken token = this.m_token;
        return token.getCategory() == cat && token.getSubCategory() == subcat ? this.current() : null;
    }

    protected XmlToken peek(String sName) throws CompilerException {
        XmlToken token = this.m_token;
        return token.getID() == 1 && token.getText().equals(sName) ? this.current() : null;
    }

    protected XmlToken mark() {
        return this.m_token;
    }
}

