/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.AbstractByteArrayReadBuffer;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public final class Binary
extends AbstractByteArrayReadBuffer
implements Cloneable,
Comparable,
Externalizable,
ExternalizableLite {
    private transient int m_nHash;

    public Binary() {
        super(NO_BYTES, 0, 0);
    }

    public Binary(byte[] ab) {
        this(ab, 0, ab.length, true);
    }

    public Binary(byte[] ab, int of, int cb) {
        this(ab, of, cb, true);
    }

    private Binary(byte[] ab, int of, int cb, boolean fCopy) {
        if (cb == 0) {
            this.m_ab = NO_BYTES;
        } else if (fCopy) {
            byte[] abNew;
            try {
                abNew = new byte[cb];
                System.arraycopy(ab, of, abNew, 0, cb);
            }
            catch (Exception e) {
                Binary.azzert(ab != null, "byte array is null");
                Binary.azzert(of >= 0, "offset is negative");
                Binary.azzert(of <= ab.length, "offset > array length");
                Binary.azzert(cb >= 0, "length is negative");
                Binary.azzert(of + cb <= ab.length, "offset + length > array length");
                throw Binary.ensureRuntimeException(e);
            }
            this.m_ab = abNew;
            this.m_cb = cb;
        } else {
            this.m_ab = ab;
            this.m_of = of;
            this.m_cb = cb;
        }
    }

    public Binary(Binary that) {
        int cbAlloc = that.m_ab.length;
        int cbUsed = that.m_cb;
        if (cbAlloc - 1024 > cbUsed && (cbAlloc >>> 1) + (cbAlloc >>> 2) > cbUsed) {
            byte[] abNew = new byte[cbUsed];
            System.arraycopy(that.m_ab, that.m_of, abNew, 0, cbUsed);
            this.m_ab = abNew;
            this.m_cb = cbUsed;
        } else {
            this.m_ab = that.m_ab;
            this.m_of = that.m_of;
            this.m_cb = that.m_cb;
            this.m_nHash = that.m_nHash;
        }
    }

    public Binary(ByteArrayOutputStream stream) {
        byte[] ab = stream.toByteArray();
        if (stream.getClass() != ByteArrayOutputStream.class) {
            ab = (byte[])ab.clone();
        }
        this.m_ab = ab;
        this.m_cb = ab.length;
    }

    public Binary(DataInput stream) throws IOException {
        this.readExternal(stream);
    }

    Binary(Binary that, int of, int cb) {
        super(that.m_ab, that.m_of + of, cb);
    }

    Binary(BinaryWriteBuffer buf) {
        byte[] ab = buf.getInternalByteArray();
        int cbData = buf.length();
        int cbTotal = ab.length;
        int cbWaste = cbTotal - cbData;
        if (cbWaste <= cbData >>> 3) {
            this.m_ab = ab;
        } else {
            byte[] abNew = new byte[cbData];
            System.arraycopy(ab, 0, abNew, 0, cbData);
            this.m_ab = abNew;
        }
        this.m_cb = cbData;
    }

    public boolean regionMatches(int ofThis, Binary that, int ofThat, int cb) {
        if (ofThis < 0 || (long)ofThis > (long)this.m_cb - (long)cb || ofThat < 0 || (long)ofThat > (long)that.m_cb - (long)cb) {
            return false;
        }
        return Binary.equals(this.m_ab, this.m_of + ofThis, that.m_ab, that.m_of + ofThat, cb);
    }

    public boolean startsWith(Binary bin, int ofFrom) {
        return this.regionMatches(ofFrom, bin, 0, bin.m_cb);
    }

    public boolean startsWith(Binary bin) {
        return this.startsWith(bin, 0);
    }

    public boolean endsWith(Binary bin) {
        return this.startsWith(bin, this.m_cb - bin.m_cb);
    }

    public int indexOf(byte b) {
        int ofThis = this.m_of;
        int ofResult = Binary.memchr(this.m_ab, ofThis, this.m_cb, b);
        return ofResult < 0 ? ofResult : ofResult - ofThis;
    }

    public int indexOf(byte b, int ofFrom) {
        int ofThis;
        int ofResult;
        if (ofFrom < 0) {
            ofFrom = 0;
        }
        return (ofResult = Binary.memchr(this.m_ab, (ofThis = this.m_of) + ofFrom, this.m_cb - ofFrom, b)) < 0 ? ofResult : ofResult - ofThis;
    }

    public int indexOf(Binary bin) {
        Binary that = bin;
        int ofThis = this.m_of;
        int ofResult = Binary.memmem(this.m_ab, ofThis, this.m_cb, that.m_ab, that.m_of, that.m_cb);
        return ofResult < 0 ? ofResult : ofResult - ofThis;
    }

    public int indexOf(Binary bin, int ofFrom) {
        Binary that = bin;
        if (ofFrom < 0) {
            ofFrom = 0;
        }
        int ofThis = this.m_of;
        int cbThis = this.m_cb;
        int cbThat = that.m_cb;
        int cbRemain = cbThis - ofFrom;
        if (cbRemain < 0) {
            return cbThat == 0 ? cbThis : -1;
        }
        int ofResult = Binary.memmem(this.m_ab, ofThis + ofFrom, cbRemain, that.m_ab, that.m_of, cbThat);
        return ofResult < 0 ? ofResult : ofResult - ofThis;
    }

    public int lastIndexOf(byte b) {
        int ofThis = this.m_of;
        int ofResult = Binary.memchr(this.m_ab, ofThis, this.m_cb, b, true);
        return ofResult < 0 ? ofResult : ofResult - ofThis;
    }

    public int lastIndexOf(byte b, int ofFrom) {
        int ofThis = this.m_of;
        int ofResult = Binary.memchr(this.m_ab, ofThis, Math.min(this.m_cb, ofFrom + 1), b, true);
        return ofResult < 0 ? ofResult : ofResult - ofThis;
    }

    public int lastIndexOf(Binary bin) {
        Binary that = bin;
        int ofThis = this.m_of;
        int ofResult = Binary.memmem(this.m_ab, ofThis, this.m_cb, that.m_ab, that.m_of, that.m_cb, true);
        return ofResult < 0 ? ofResult : ofResult - ofThis;
    }

    public int lastIndexOf(Binary bin, int ofFrom) {
        Binary that = bin;
        int ofThis = this.m_of;
        int cbThat = that.m_cb;
        int ofResult = Binary.memmem(this.m_ab, ofThis, Math.min(this.m_cb, ofFrom + cbThat), that.m_ab, that.m_of, cbThat, true);
        return ofResult < 0 ? ofResult : ofResult - ofThis;
    }

    public Binary replace(byte bOld, byte bNew) {
        if (bOld == bNew) {
            return this;
        }
        byte[] abThis = this.m_ab;
        int ofThis = this.m_of;
        int cbThis = this.m_cb;
        int ofByte = Binary.memchr(abThis, ofThis, cbThis, bOld);
        if (ofByte < 0) {
            return this;
        }
        byte[] abResult = Binary.clone(abThis, ofThis, cbThis);
        ofByte -= ofThis;
        do {
            abResult[ofByte++] = bNew;
        } while ((ofByte = Binary.memchr(abResult, ofByte, cbThis - ofByte, bOld)) >= 0);
        return new Binary(abResult, 0, cbThis, false);
    }

    public Binary replace(Binary binOld, Binary binNew) {
        int cbOld = binOld.m_cb;
        if (cbOld == 0) {
            return this;
        }
        int cbNew = binNew.m_cb;
        if (cbOld == 1 && cbNew == 1) {
            return this.replace(binOld.byteAt(0), binNew.byteAt(0));
        }
        byte[] abThis = this.m_ab;
        int ofThis = this.m_of;
        int cbThis = this.m_cb;
        byte[] abOld = binOld.m_ab;
        int ofOld = binOld.m_of;
        byte[] abNew = binNew.m_ab;
        int ofNew = binNew.m_of;
        int ofNext = Binary.memmem(abThis, ofThis, cbThis, abOld, ofOld, cbOld);
        if (ofNext < 0) {
            return this;
        }
        if (cbOld == cbNew) {
            byte[] abResult = Binary.clone(abThis, ofThis, cbThis);
            ofNext -= ofThis;
            do {
                Binary.memcpy(abNew, ofNew, abResult, ofNext, cbNew);
                ofNext += cbNew;
            } while ((ofNext = Binary.memmem(abResult, ofNext, cbThis - ofNext, abOld, ofOld, cbOld)) >= 0);
            return new Binary(abResult, 0, cbThis, false);
        }
        BinaryWriteBuffer buf = new BinaryWriteBuffer(cbThis + cbNew - cbOld);
        WriteBuffer.BufferOutput out = buf.getBufferOutput();
        try {
            int cbRemain;
            int ofPrev = ofThis;
            do {
                int cbCopy;
                if ((cbCopy = ofNext - ofPrev) > 0) {
                    out.write(abThis, ofPrev, cbCopy);
                }
                if (cbNew <= 0) continue;
                out.write(abNew, ofNew, cbNew);
            } while ((ofNext = Binary.memmem(abThis, ofPrev = ofNext + cbOld, cbRemain = cbThis - (ofPrev - ofThis), abOld, ofOld, cbOld)) >= 0);
            if (cbRemain > 0) {
                out.write(abThis, ofPrev, cbRemain);
            }
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
        return buf.toBinary();
    }

    public Binary replaceRegion(int of, int cb, Binary binNew) {
        byte[] abThis = this.m_ab;
        int ofThis = this.m_of;
        int cbThis = this.m_cb;
        byte[] abNew = binNew.m_ab;
        int ofNew = binNew.m_of;
        int cbNew = binNew.m_cb;
        if (cb == cbNew) {
            byte[] abResult = Binary.clone(abThis, ofThis, cbThis);
            Binary.memcpy(abNew, ofNew, abResult, of, cb);
            return new Binary(abResult, 0, cbThis, false);
        }
        BinaryWriteBuffer buf = new BinaryWriteBuffer(cbThis + cbNew - cb);
        WriteBuffer.BufferOutput out = buf.getBufferOutput();
        try {
            this.writeTo(out, 0, of);
            binNew.writeTo(out);
            int ofRemain = of + cb;
            this.writeTo(out, ofRemain, this.length() - ofRemain);
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
        return buf.toBinary();
    }

    public Binary concat(Binary bin) {
        Binary that = bin;
        int cbThis = this.m_cb;
        if (cbThis == 0) {
            return that;
        }
        int cbThat = that.m_cb;
        if (cbThat == 0) {
            return this;
        }
        int cbNew = cbThis + cbThat;
        byte[] abNew = new byte[cbNew];
        System.arraycopy(this.m_ab, this.m_of, abNew, 0, cbThis);
        System.arraycopy(that.m_ab, that.m_of, abNew, cbThis, cbThat);
        return new Binary(abNew, 0, cbNew, false);
    }

    public Binary reverse() {
        int cb = this.m_cb;
        if (cb < 2) {
            return this;
        }
        byte[] abOld = this.m_ab;
        byte[] abNew = new byte[cb];
        int ofOld = this.m_of;
        int ofNew = cb - 1;
        while (ofNew >= 0) {
            abNew[ofNew--] = abOld[ofOld++];
        }
        return new Binary(abNew, 0, cb, false);
    }

    @Override
    public Binary toBinary() {
        return this;
    }

    @Override
    public Binary toBinary(int of, int cb) {
        int cbBuf = this.m_cb;
        if (of == 0 && cb == cbBuf) {
            return this;
        }
        if (of < 0 || cb < 0 || of + cb > cbBuf) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", length()=" + cbBuf);
        }
        return cb == 0 ? NO_BINARY : new Binary(this, of, cb);
    }

    @Override
    protected ReadBuffer instantiateReadBuffer(int of, int cb) {
        return this.toBinary(of, cb);
    }

    @Override
    protected boolean isByteArrayPrivate() {
        return true;
    }

    @Override
    public Object clone() {
        return this;
    }

    public String toString() {
        int cb = this.m_cb;
        int MAX = 256;
        boolean fTrunc = cb > 256;
        return "Binary(length=" + cb + ", value=" + Binary.toHexEscape(this.m_ab, this.m_of, fTrunc ? 256 : cb) + (fTrunc ? "...)" : ")");
    }

    public int hashCode() {
        int nHash = this.m_nHash;
        if (nHash == 0) {
            nHash = Binary.toCrc(this.m_ab, this.m_of, this.m_cb);
            if (nHash == 0) {
                nHash = 17;
            }
            this.m_nHash = nHash;
        }
        return nHash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Binary) {
            Binary that = (Binary)o;
            int cbThis = this.m_cb;
            int cbThat = that.m_cb;
            if (cbThis == cbThat) {
                if (cbThis == 0) {
                    return true;
                }
                int nThisHash = this.m_nHash;
                int nThatHash = that.m_nHash;
                if (nThisHash == 0 || nThatHash == 0 || nThisHash == nThatHash) {
                    if (this.m_of == 0 && that.m_of == 0 && this.m_ab.length == cbThis && that.m_ab.length == cbThis) {
                        return Arrays.equals(this.m_ab, that.m_ab);
                    }
                    return Binary.equals(this.m_ab, this.m_of, that.m_ab, that.m_of, cbThat);
                }
            }
        }
        return false;
    }

    public int calculateNaturalPartition(int cPartitions) {
        long lHash = (long)this.hashCode() & 0xFFFFFFFFL;
        return cPartitions == 0 ? (int)lHash : (int)(lHash % (long)cPartitions);
    }

    public int compareTo(Object o) {
        Binary that = (Binary)o;
        return Binary.memcmp(this.m_ab, this.m_of, this.m_cb, that.m_ab, that.m_of, that.m_cb);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readExternal((DataInput)in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        if (this.m_cb > 0) {
            throw new NotActiveException();
        }
        int cb = in.readInt();
        byte[] ab = new byte[cb];
        in.readFully(ab);
        this.m_ab = ab;
        this.m_cb = cb;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_cb);
        out.write(this.m_ab, this.m_of, this.m_cb);
    }

    public InputStream getInputStream() {
        return (InputStream)((Object)this.getBufferInput());
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.m_ab, this.m_of, this.m_cb);
    }

    public void writeTo(OutputStream out, int of, int cb) throws IOException {
        out.write(this.m_ab, this.m_of + of, cb);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.write(this.m_ab, this.m_of, this.m_cb);
    }

    public void writeTo(DataOutput out, int of, int cb) throws IOException {
        out.write(this.m_ab, this.m_of + of, cb);
    }

    public void writeTo(ByteBuffer buf) {
        buf.put(this.m_ab, this.m_of, this.m_cb);
    }

    public void writeTo(ByteBuffer buf, int of, int cb) throws IOException {
        buf.put(this.m_ab, this.m_of + of, cb);
    }

    public static Binary readBinary(FileChannel channel, long of, int cb, byte[] ab2) throws IOException {
        int cbChunk;
        if (cb == 0) {
            return NO_BINARY;
        }
        byte[] ab = new byte[cb];
        ByteBuffer buf = ByteBuffer.wrap(ab);
        int cbRead = 0;
        do {
            if ((cbChunk = channel.read(buf, of + (long)cbRead)) >= 0) continue;
            throw new EOFException("succeeded in only reading " + cbRead + " bytes out of a requested " + cb + " bytes at offset " + of + " from channel: " + channel.toString());
        } while ((cbRead += cbChunk) < cb);
        assert (cb == cbRead);
        if (ab2 != null && ab2.length == 256) {
            int ofCur = 0;
            int ofOv = (int)(of & 0xFFL);
            while (ofCur < cb) {
                ab[ofCur] = (byte)(ab[ofCur] ^ ab2[ofOv & 0xFF]);
                ++ofCur;
                ++ofOv;
            }
        }
        return new Binary(ab, 0, cb, false);
    }

    public static int memchr(byte[] abHaystack, int ofHaystack, int cbHaystack, byte bNeedle) {
        return Binary.memchr(abHaystack, ofHaystack, cbHaystack, bNeedle, false);
    }

    public static int memchr(byte[] abHaystack, int ofHaystack, int cbHaystack, byte bNeedle, boolean fBackwards) {
        try {
            if (fBackwards) {
                int ofStop = ofHaystack;
                for (int of = ofStop + cbHaystack - 1; of >= ofStop; --of) {
                    if (abHaystack[of] != bNeedle) continue;
                    return of;
                }
            } else {
                int of;
                int ofStop = of + cbHaystack;
                for (of = ofHaystack; of < ofStop; ++of) {
                    if (abHaystack[of] != bNeedle) continue;
                    return of;
                }
            }
            return -1;
        }
        catch (RuntimeException e) {
            throw new WrapperException(e, "abHaystack=" + Binary.toString(abHaystack) + ", ofHaystack=" + ofHaystack + ", cbHaystack=" + cbHaystack);
        }
    }

    public static int memmem(byte[] abHaystack, int ofHaystack, int cbHaystack, byte[] abNeedle, int ofNeedle, int cbNeedle) {
        return Binary.memmem(abHaystack, ofHaystack, cbHaystack, abNeedle, ofNeedle, cbNeedle, false);
    }

    public static int memmem(byte[] abHaystack, int ofHaystack, int cbHaystack, byte[] abNeedle, int ofNeedle, int cbNeedle, boolean fBackwards) {
        try {
            if (cbNeedle >= cbHaystack) {
                return cbNeedle == cbHaystack && Binary.equals(abHaystack, ofHaystack, abNeedle, ofNeedle, cbNeedle) ? ofHaystack : -1;
            }
            if (cbNeedle <= 1) {
                return cbNeedle == 0 ? ofHaystack + (fBackwards ? cbHaystack : 0) : Binary.memchr(abHaystack, ofHaystack, cbHaystack, abNeedle[ofNeedle * cbNeedle], fBackwards);
            }
            byte bNeedle = abNeedle[ofNeedle];
            if (fBackwards) {
                int ofStop = ofHaystack;
                for (int of = ofStop + cbHaystack - cbNeedle; of >= ofStop; --of) {
                    if (abHaystack[of] != bNeedle || !Binary.equals(abHaystack, of + 1, abNeedle, ofNeedle + 1, cbNeedle - 1)) continue;
                    return of;
                }
            } else {
                int of;
                int ofStop = of + cbHaystack - cbNeedle;
                for (of = ofHaystack; of <= ofStop; ++of) {
                    if (abHaystack[of] != bNeedle || !Binary.equals(abHaystack, of + 1, abNeedle, ofNeedle + 1, cbNeedle - 1)) continue;
                    return of;
                }
            }
            return -1;
        }
        catch (RuntimeException e) {
            throw new WrapperException(e, "abHaystack=" + Binary.toString(abHaystack) + ", ofHaystack=" + ofHaystack + ", cbHaystack=" + cbHaystack + ", abNeedle=" + Binary.toString(abNeedle) + ", ofNeedle=" + ofNeedle + ", cbNeedle=" + cbNeedle);
        }
    }

    public static int memcmp(byte[] ab1, int of1, int cb1, byte[] ab2, int of2, int cb2) {
        try {
            int c = Math.min(cb1, cb2);
            for (int i = 0; i < c; ++i) {
                if (ab1[of1 + i] == ab2[of2 + i]) continue;
                return (ab1[of1 + i] & 0xFF) - (ab2[of2 + i] & 0xFF);
            }
            return cb1 - cb2;
        }
        catch (RuntimeException e) {
            throw new WrapperException(e, "ab1=" + Binary.toString(ab1) + ", of1=" + of1 + ", cb1=" + cb1 + ", ab2=" + Binary.toString(ab2) + ", of2=" + of2 + ", cb2=" + cb2);
        }
    }

    public static void memcpy(byte[] abSrc, int ofSrc, byte[] abDest, int ofDest, int cbCopy) {
        try {
            System.arraycopy(abSrc, ofSrc, abDest, ofDest, cbCopy);
        }
        catch (RuntimeException e) {
            throw new WrapperException(e, "abSrc=" + Binary.toString(abSrc) + ", ofSrc=" + ofSrc + ", abDest=" + Binary.toString(abDest) + ", ofDest=" + ofDest + ", cbCopy=" + cbCopy);
        }
    }

    public static boolean equals(byte[] ab1, int of1, byte[] ab2, int of2, int cb) {
        try {
            while (--cb >= 0) {
                if (ab1[of1++] == ab2[of2++]) continue;
                return false;
            }
            return true;
        }
        catch (RuntimeException e) {
            throw new WrapperException(e, "ab1=" + Binary.toString(ab1) + ", of1=" + of1 + ", ab2=" + Binary.toString(ab2) + ", of2=" + of2 + ", cb=" + cb);
        }
    }

    public static byte[] clone(byte[] ab, int of, int cb) {
        try {
            byte[] abNew = new byte[cb];
            System.arraycopy(ab, of, abNew, 0, cb);
            return abNew;
        }
        catch (RuntimeException e) {
            throw new WrapperException(e, "ab=" + Binary.toString(ab) + ", of=" + of + ", cb=" + cb);
        }
    }

    public static String toString(byte[] ab) {
        return ab == null ? "null" : "byte[" + ab.length + "]";
    }
}

