/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;

public class CopyOnWriteLongArray
implements LongArray {
    protected static final LongArray EMPTY_ARRAY = new SparseArray();
    private volatile LongArray m_arrayInternal;

    public CopyOnWriteLongArray() {
        this.setInternalArray(EMPTY_ARRAY);
    }

    public CopyOnWriteLongArray(Class clazz) throws IllegalAccessException, InstantiationException {
        if (!LongArray.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz.getName());
        }
        this.setInternalArray((LongArray)clazz.newInstance());
    }

    public CopyOnWriteLongArray(LongArray array) {
        this.setInternalArray(this.copyArray(array));
    }

    protected LongArray getInternalArray() {
        return this.m_arrayInternal;
    }

    protected void setInternalArray(LongArray array) {
        this.m_arrayInternal = array;
    }

    public LongArray copyArray(LongArray array) {
        return (LongArray)array.clone();
    }

    @Override
    public Object get(long lIndex) {
        return this.getInternalArray().get(lIndex);
    }

    @Override
    public synchronized Object set(long lIndex, Object oValue) {
        LongArray arrayNew = this.copyArray(this.getInternalArray());
        Object oValueOld = arrayNew.set(lIndex, oValue);
        this.setInternalArray(arrayNew);
        return oValueOld;
    }

    @Override
    public synchronized long add(Object oValue) {
        LongArray arrayNew = this.copyArray(this.getInternalArray());
        long lIndex = arrayNew.add(oValue);
        this.setInternalArray(arrayNew);
        return lIndex;
    }

    @Override
    public boolean exists(long lIndex) {
        return this.getInternalArray().exists(lIndex);
    }

    @Override
    public synchronized Object remove(long lIndex) {
        LongArray arrayNew = this.copyArray(this.getInternalArray());
        Object oValueOld = arrayNew.remove(lIndex);
        this.setInternalArray(arrayNew);
        return oValueOld;
    }

    @Override
    public boolean contains(Object oValue) {
        return this.getInternalArray().contains(oValue);
    }

    @Override
    public synchronized void clear() {
        LongArray arrayNew = this.copyArray(this.getInternalArray());
        arrayNew.clear();
        this.setInternalArray(arrayNew);
    }

    @Override
    public boolean isEmpty() {
        return this.getInternalArray().isEmpty();
    }

    @Override
    public int getSize() {
        return this.getInternalArray().getSize();
    }

    @Override
    public LongArray.Iterator iterator() {
        return this.instantiateUnmodifiableIterator(this.getInternalArray().iterator());
    }

    @Override
    public LongArray.Iterator iterator(long lIndex) {
        return this.instantiateUnmodifiableIterator(this.getInternalArray().iterator(lIndex));
    }

    @Override
    public LongArray.Iterator reverseIterator() {
        return this.instantiateUnmodifiableIterator(this.getInternalArray().reverseIterator());
    }

    @Override
    public LongArray.Iterator reverseIterator(long lIndex) {
        return this.instantiateUnmodifiableIterator(this.getInternalArray().reverseIterator(lIndex));
    }

    @Override
    public long getFirstIndex() {
        return this.getInternalArray().getFirstIndex();
    }

    @Override
    public long getLastIndex() {
        return this.getInternalArray().getLastIndex();
    }

    @Override
    public long indexOf(Object oValue) {
        return this.getInternalArray().indexOf(oValue);
    }

    @Override
    public long indexOf(Object oValue, long lIndex) {
        return this.getInternalArray().indexOf(oValue, lIndex);
    }

    @Override
    public long lastIndexOf(Object oValue) {
        return this.getInternalArray().lastIndexOf(oValue);
    }

    @Override
    public long lastIndexOf(Object oValue, long lIndex) {
        return this.getInternalArray().lastIndexOf(oValue, lIndex);
    }

    @Override
    public Object clone() {
        CopyOnWriteLongArray arrayNew = new CopyOnWriteLongArray();
        arrayNew.setInternalArray(this.getInternalArray());
        return arrayNew;
    }

    public LongArray.Iterator instantiateUnmodifiableIterator(LongArray.Iterator iterator) {
        return new UnmodifiableIterator(iterator);
    }

    public static class UnmodifiableIterator
    implements LongArray.Iterator {
        protected LongArray.Iterator m_iteratorInternal;

        public UnmodifiableIterator(LongArray.Iterator iterator) {
            this.m_iteratorInternal = iterator;
        }

        public LongArray.Iterator getInternalIterator() {
            return this.m_iteratorInternal;
        }

        @Override
        public boolean hasNext() {
            return this.getInternalIterator().hasNext();
        }

        @Override
        public Object next() {
            return this.getInternalIterator().next();
        }

        @Override
        public long getIndex() {
            return this.getInternalIterator().getIndex();
        }

        @Override
        public Object getValue() {
            return this.getInternalIterator().getValue();
        }

        @Override
        public Object setValue(Object oValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

