/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.WrapperCollections;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ImmutableMultiList
extends AbstractList
implements List,
Set {
    private Object[][] m_aao;
    private Set m_set;
    private int m_cTotal;

    public ImmutableMultiList(Object[][] aao) {
        this.m_cTotal = ImmutableMultiList.calculateTotalLength(aao);
        this.m_aao = aao;
    }

    public ImmutableMultiList(Collection collection) {
        this((Object[][])collection.toArray((T[])new Object[collection.size()][]));
    }

    public List getList() {
        return new ListView();
    }

    public Set getSet() {
        return new SetView();
    }

    @Override
    public int size() {
        return this.m_cTotal;
    }

    public Object get(int i) {
        Object[][] aao = this.m_aao;
        int caa = aao.length;
        for (int iaa = 0; iaa < caa; ++iaa) {
            int c = aao[iaa].length;
            if (i < c) {
                return aao[iaa][i];
            }
            i -= c;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        for (Object[] ao : this.m_aao) {
            int ia = 0;
            int ca = ao.length;
            while (ia < ca) {
                if (Base.equals(ao[ia], o)) {
                    return i;
                }
                ++ia;
                ++i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = this.m_cTotal - 1;
        Object[][] aao = this.m_aao;
        for (int iaa = aao.length - 1; iaa >= 0; --iaa) {
            Object[] ao = aao[iaa];
            int ia = ao.length - 1;
            while (ia >= 0) {
                if (Base.equals(ao[ia], o)) {
                    return i;
                }
                --ia;
                --i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        HashSet set = this.m_set;
        if (set == null) {
            if (this.m_cTotal < 32) {
                return this.indexOf(o) >= 0;
            }
            this.m_set = set = new HashSet(this);
        }
        return set.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    @Override
    public Object[] toArray(Object[] ao) {
        return ImmutableMultiList.flatten(this.m_aao, this.m_cTotal, ao);
    }

    public ListIterator listIterator() {
        return new MultiIterator(0);
    }

    public ListIterator listIterator(int i) {
        return new MultiIterator(i);
    }

    public List subList(int iFrom, int iTo) {
        int c;
        int cTotal = this.m_cTotal;
        if (iTo == -1) {
            iTo = cTotal - 1;
        }
        if (iFrom > iTo) {
            throw new IllegalArgumentException("iFrom > iTo");
        }
        if (iFrom >= cTotal) {
            throw new IllegalArgumentException("iFrom >= cTotal");
        }
        if (iTo > cTotal) {
            throw new IllegalArgumentException("iTo > cTotal");
        }
        Object[][] aao = this.m_aao;
        int iaaFrom = 0;
        Object[] aFrom = aao[iaaFrom];
        while (iFrom >= aFrom.length) {
            iFrom -= aFrom.length;
            aFrom = aao[++iaaFrom];
        }
        int iaaTo = iaaFrom;
        Object[] aTo = aFrom;
        while (iTo > aTo.length) {
            iTo -= aTo.length;
            aTo = aao[++iaaTo];
        }
        int caaSub = iaaTo - iaaFrom + 1;
        Object[][] aaSub = new Object[caaSub][];
        System.arraycopy(aao, iaaFrom, aaSub, 0, caaSub);
        if (iFrom != 0) {
            c = aFrom.length - iFrom;
            aaSub[0] = new Object[c];
            System.arraycopy(aFrom, iFrom, aaSub[0], 0, c);
        }
        if (iTo != aTo.length) {
            c = iTo + 1;
            Object[] objectArray = new Object[c];
            aaSub[caaSub - 1] = objectArray;
            System.arraycopy(aFrom, iFrom, objectArray, 0, c);
        }
        return new ImmutableMultiList(aaSub);
    }

    @Override
    public Iterator iterator() {
        return this.listIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof List) {
            return super.equals(o);
        }
        if (o instanceof Collection) {
            Collection that = (Collection)o;
            return this.size() == that.size() && this.containsAll(that);
        }
        return false;
    }

    public static int calculateTotalLength(Object[][] aao) {
        int cnt = 0;
        int c = aao.length;
        for (int i = 0; i < c; ++i) {
            cnt += aao[i].length;
        }
        return cnt;
    }

    public static Object[] flatten(Object[][] aaoFrom, int cTotal, Object[] aoTo) {
        if (cTotal < 0) {
            cTotal = ImmutableMultiList.calculateTotalLength(aaoFrom);
        }
        if (aoTo == null) {
            aoTo = new Object[cTotal];
        } else if (aoTo.length < cTotal) {
            aoTo = (Object[])Array.newInstance(aoTo.getClass().getComponentType(), cTotal);
        } else if (aoTo.length > cTotal) {
            aoTo[cTotal] = null;
        }
        int of = 0;
        for (Object[] aoNext : aaoFrom) {
            int cNext = aoNext.length;
            System.arraycopy(aoNext, 0, aoTo, of, cNext);
            of += cNext;
        }
        return aoTo;
    }

    protected class SetView
    extends WrapperCollections.AbstractWrapperSet {
        protected SetView() {
            super(ImmutableMultiList.this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Set setOther = (Set)o;
            return setOther.size() == this.size() && setOther.containsAll(this);
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                nHash += Base.hashCode(iter.next());
            }
            return nHash;
        }
    }

    protected class ListView
    extends WrapperCollections.AbstractWrapperList {
        protected ListView() {
            super(ImmutableMultiList.this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            Iterator iterThis = this.iterator();
            Iterator iterThat = ((List)o).iterator();
            while (iterThis.hasNext() && iterThat.hasNext()) {
                if (Base.equals(iterThis.next(), iterThat.next())) continue;
                return false;
            }
            return !iterThis.hasNext() && !iterThat.hasNext();
        }

        @Override
        public int hashCode() {
            int nHash = 1;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                nHash = 31 * nHash + Base.hashCode(iter.next());
            }
            return nHash;
        }
    }

    protected class MultiIterator
    implements ListIterator {
        private int m_i;
        private int m_ia;
        private int m_iaa;

        public MultiIterator(int i) {
            if (i == -1) {
                i = ImmutableMultiList.this.m_cTotal;
            }
            while (i-- > 0) {
                this.next();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("collection is read-only");
        }

        public void add(Object o) {
            throw new UnsupportedOperationException("collection is read-only");
        }

        public void set(Object o) {
            throw new UnsupportedOperationException("collection is read-only");
        }

        @Override
        public boolean hasNext() {
            return this.m_i < ImmutableMultiList.this.m_cTotal;
        }

        @Override
        public Object next() {
            if (this.m_i == ImmutableMultiList.this.m_cTotal) {
                throw new NoSuchElementException();
            }
            ++this.m_i;
            Object[][] aao = ImmutableMultiList.this.m_aao;
            int ia = this.m_ia;
            Object[] ao = aao[this.m_iaa];
            while (ia == ao.length) {
                ao = aao[++this.m_iaa];
                ia = 0;
            }
            this.m_ia = ia + 1;
            return ao[ia];
        }

        @Override
        public int nextIndex() {
            return this.m_i;
        }

        @Override
        public int previousIndex() {
            return this.m_i - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.m_i > 0;
        }

        public Object previous() {
            if (this.m_i == 0) {
                throw new NoSuchElementException();
            }
            --this.m_i;
            Object[][] aao = ImmutableMultiList.this.m_aao;
            int ia = this.m_ia;
            Object[] ao = aao[this.m_iaa];
            while (ia == 0) {
                ao = aao[--this.m_iaa];
                ia = ao.length;
            }
            this.m_ia = --ia;
            return ao[ia];
        }
    }
}

