/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapIndex;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.SimpleMapIndex;
import com.tangosol.util.SubSet;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.AbstractUpdater;
import com.tangosol.util.extractor.IndexAwareExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.LimitFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class InvocableMapHelper
extends Base {
    public static final Converter ENTRY_TO_KEY_CONVERTER = new Converter(){

        @Override
        public Object convert(Object o) {
            return ((Map.Entry)o).getKey();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeLocked(ConcurrentMap map, InvocableMap.Entry entry, InvocableMap.EntryProcessor agent) {
        Object oKey = entry.getKey();
        map.lock(oKey, -1L);
        try {
            Object object = agent.process(entry);
            return object;
        }
        finally {
            map.unlock(oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map invokeAllLocked(ConcurrentMap map, Set setEntries, InvocableMap.EntryProcessor agent) {
        ConverterCollections.ConverterSet setKeys = ConverterCollections.getSet(setEntries, ENTRY_TO_KEY_CONVERTER, NullImplementation.getConverter());
        List listLocked = InvocableMapHelper.lockAll(map, setKeys, 0L);
        if (listLocked == null) {
            HashMap<Object, Object> mapResult = new HashMap<Object, Object>(setEntries.size());
            for (InvocableMap.Entry entry : setEntries) {
                mapResult.put(entry.getKey(), InvocableMapHelper.invokeLocked(map, entry, agent));
            }
            return mapResult;
        }
        try {
            Map map2 = agent.processAll(setEntries);
            return map2;
        }
        finally {
            InvocableMapHelper.unlockAll(map, listLocked);
        }
    }

    public static List lockAll(ConcurrentMap map, Collection collKeys, long cWait) {
        Set setKeys = collKeys instanceof Set ? (Set)collKeys : new HashSet(collKeys);
        ArrayList listKeys = new ArrayList(setKeys);
        LinkedList listLocked = new LinkedList();
        int cKeys = listKeys.size();
        boolean fSuccess = true;
        do {
            long cWaitNext = cWait;
            for (int i = 0; i < cKeys; ++i) {
                Object oKey = listKeys.get(i);
                fSuccess = map.lock(oKey, cWaitNext);
                if (fSuccess) {
                    listLocked.add(0, oKey);
                    cWaitNext = 0L;
                    continue;
                }
                if (i == 0) {
                    return null;
                }
                Iterator iterLocked = listLocked.iterator();
                while (iterLocked.hasNext()) {
                    map.unlock(iterLocked.next());
                }
                listLocked.clear();
                listKeys.remove(i);
                listKeys.add(0, oKey);
            }
        } while (!fSuccess);
        return listLocked;
    }

    public static void unlockAll(ConcurrentMap map, Collection collKeys) {
        Iterator iterLocked = collKeys.iterator();
        while (iterLocked.hasNext()) {
            map.unlock(iterLocked.next());
        }
    }

    public static SimpleEntry makeEntry(Map map, Object oKey) {
        return new SimpleEntry(map, oKey, false);
    }

    public static Set makeEntrySet(Map map, Collection collKeys, boolean fReadOnly) {
        HashSet<SimpleEntry> setEntries = new HashSet<SimpleEntry>(collKeys.size());
        Iterator iter = collKeys.iterator();
        while (iter.hasNext()) {
            setEntries.add(new SimpleEntry(map, iter.next(), fReadOnly));
        }
        return setEntries;
    }

    public static Set makeEntrySet(Collection collEntries) {
        HashSet<SimpleEntry> setEntries = new HashSet<SimpleEntry>(collEntries.size());
        for (Map.Entry entry : collEntries) {
            setEntries.add(new SimpleEntry(entry.getKey(), entry.getValue()));
        }
        return setEntries;
    }

    public static boolean evaluateEntry(Filter filter, Map.Entry entry) {
        return filter instanceof EntryFilter ? ((EntryFilter)filter).evaluateEntry(entry) : filter.evaluate(entry.getValue());
    }

    public static boolean evaluateEntry(Filter filter, Object oKey, Object oValue) {
        return filter instanceof EntryFilter ? ((EntryFilter)filter).evaluateEntry(new SimpleMapEntry(oKey, oValue)) : filter.evaluate(oValue);
    }

    public static boolean evaluateOriginalEntry(Filter filter, MapTrigger.Entry entry) {
        if (entry.isOriginalPresent()) {
            Object oValueOrig = entry.getOriginalValue();
            return filter instanceof EntryFilter ? ((EntryFilter)filter).evaluateEntry(new SimpleMapEntry(entry.getKey(), oValueOrig)) : filter.evaluate(oValueOrig);
        }
        return false;
    }

    public static Object extractFromEntry(ValueExtractor extractor, Map.Entry entry) {
        return extractor instanceof AbstractExtractor ? ((AbstractExtractor)extractor).extractFromEntry(entry) : extractor.extract(entry.getValue());
    }

    public static Object extractOriginalFromEntry(ValueExtractor extractor, MapTrigger.Entry entry) {
        return extractor instanceof AbstractExtractor ? ((AbstractExtractor)extractor).extractOriginalFromEntry(entry) : (entry.isOriginalPresent() ? extractor.extract(entry.getOriginalValue()) : null);
    }

    public static void updateEntry(ValueUpdater updater, Map.Entry entry, Object oValue) {
        if (updater instanceof AbstractUpdater) {
            ((AbstractUpdater)updater).updateEntry(entry, oValue);
        } else {
            Object oTarget = entry.getValue();
            updater.update(oTarget, oValue);
            if (entry instanceof InvocableMap.Entry) {
                ((InvocableMap.Entry)entry).setValue(oTarget, false);
            } else {
                entry.setValue(oTarget);
            }
        }
    }

    public static Set query(Map map, Filter filter, boolean fEntries, boolean fSort, Comparator comparator) {
        return InvocableMapHelper.query(map, null, filter, fEntries, fSort, comparator);
    }

    public static Set query(Map map, Map mapIndexes, Filter filter, boolean fEntries, boolean fSort, Comparator comparator) {
        LimitFilter filterLimit;
        Object[] aoResult;
        Filter filterOrig = filter;
        if (AlwaysFilter.INSTANCE.equals(filter)) {
            filter = null;
        }
        if (mapIndexes != null && filter instanceof IndexAwareFilter) {
            IndexAwareFilter filterIx = (IndexAwareFilter)filter;
            SubSet setFilteredKeys = new SubSet(map.keySet());
            try {
                filter = filterIx.applyIndex(mapIndexes, setFilteredKeys);
            }
            catch (ConcurrentModificationException e) {
                setFilteredKeys = new SubSet(new ImmutableArrayList(map.keySet().toArray()));
                filter = filterIx.applyIndex(mapIndexes, setFilteredKeys);
            }
            aoResult = setFilteredKeys.toArray();
        } else {
            aoResult = map.keySet().toArray();
        }
        int cResults = 0;
        if (filter == null && !fEntries) {
            cResults = aoResult.length;
        } else {
            int c = aoResult.length;
            for (int i = 0; i < c; ++i) {
                Object oKey = aoResult[i];
                Object oValue = map.get(oKey);
                if (oValue == null && !map.containsKey(oKey)) continue;
                SimpleMapEntry entry = new SimpleMapEntry(oKey, oValue);
                if (filter != null && !InvocableMapHelper.evaluateEntry(filter, entry)) continue;
                aoResult[cResults++] = fEntries ? entry : oKey;
            }
        }
        LimitFilter limitFilter = filterLimit = filterOrig instanceof LimitFilter ? (LimitFilter)filterOrig : null;
        if (filterLimit != null || fEntries && fSort) {
            if (cResults < aoResult.length) {
                Object[] ao = new Object[cResults];
                System.arraycopy(aoResult, 0, ao, 0, cResults);
                aoResult = ao;
            }
            if (fEntries && fSort) {
                if (comparator == null) {
                    comparator = SafeComparator.INSTANCE;
                }
                Arrays.sort(aoResult, new EntryComparator(comparator));
            }
            if (filterLimit != null) {
                filterLimit.setComparator(null);
                aoResult = filterLimit.extractPage(aoResult);
                cResults = aoResult.length;
                filterLimit.setComparator(comparator);
            }
        }
        return new ImmutableArrayList(aoResult, 0, cResults).getSet();
    }

    public static void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator, ObservableMap map, Map mapIndex) {
        block9: {
            MapIndex index = (MapIndex)mapIndex.get(extractor);
            if (index == null) {
                int cAttempts = 4;
                while (true) {
                    if (extractor instanceof IndexAwareExtractor) {
                        index = ((IndexAwareExtractor)extractor).createIndex(fOrdered, comparator, mapIndex, null);
                        if (index == null) {
                            return;
                        }
                    } else {
                        index = new SimpleMapIndex(extractor, fOrdered, comparator, null);
                        mapIndex.put(extractor, index);
                    }
                    MapListener listener = InvocableMapHelper.ensureListener(index);
                    map.addMapListener(listener, null, false);
                    try {
                        for (Map.Entry entry : map.entrySet()) {
                            index.insert(entry);
                        }
                        break block9;
                    }
                    catch (ConcurrentModificationException cme) {
                        map.removeMapListener(listener);
                        if (--cAttempts != 0) continue;
                        InvocableMapHelper.removeIndex(extractor, map, mapIndex);
                        InvocableMapHelper.trace("Exception occured during index rebuild: " + InvocableMapHelper.getStackTrace(cme));
                        throw cme;
                    }
                    break;
                }
            }
            if (fOrdered != index.isOrdered() || !Base.equals(comparator, index.getComparator())) {
                throw new IllegalArgumentException("Index for " + extractor + " already exists;" + " remove the index and add it with the new settings");
            }
        }
    }

    public static void removeIndex(ValueExtractor extractor, ObservableMap map, Map mapIndex) {
        MapIndex index;
        MapIndex mapIndex2 = index = extractor instanceof IndexAwareExtractor ? ((IndexAwareExtractor)extractor).destroyIndex(mapIndex) : (MapIndex)mapIndex.remove(extractor);
        if (index != null) {
            map.removeMapListener(InvocableMapHelper.ensureListener(index));
        }
    }

    protected static MapListener ensureListener(MapIndex index) {
        return index instanceof MapListenerSupport.SynchronousListener ? (MapListener)((Object)index) : new IndexAdapter(index);
    }

    protected static class IndexAdapter
    implements MapListenerSupport.SynchronousListener {
        private MapIndex m_index;

        protected IndexAdapter(MapIndex index) {
            this.m_index = index;
        }

        @Override
        public void entryInserted(MapEvent evt) {
            this.m_index.insert(new SimpleMapEntry(evt.getKey(), evt.getNewValue()));
        }

        @Override
        public void entryUpdated(MapEvent evt) {
            this.m_index.update(new SimpleMapEntry(evt.getKey(), evt.getNewValue(), evt.getOldValue()));
        }

        @Override
        public void entryDeleted(MapEvent evt) {
            this.m_index.delete(new SimpleMapEntry(evt.getKey(), null, evt.getOldValue()));
        }

        public boolean equals(Object o) {
            return this == o || o instanceof IndexAdapter && Base.equals(this.m_index, ((IndexAdapter)o).m_index);
        }

        public int hashCode() {
            return this.m_index.hashCode();
        }
    }

    public static class SimpleEntry
    extends Base
    implements InvocableMap.Entry {
        private static final Object UNKNOWN = new Object();
        protected Map m_map;
        private Object m_oKey;
        private Object m_oValue;
        private boolean m_fReadOnly;

        public SimpleEntry(Map map, Object oKey, boolean fReadOnly) {
            SimpleEntry.azzert(map != null);
            this.m_map = map;
            this.m_oKey = oKey;
            this.m_fReadOnly = fReadOnly;
            this.m_oValue = UNKNOWN;
        }

        public SimpleEntry(Object oKey, Object oValue) {
            this.m_oKey = oKey;
            this.m_oValue = oValue;
            this.m_fReadOnly = true;
        }

        @Override
        public Object getKey() {
            return this.m_oKey;
        }

        @Override
        public Object getValue() {
            Object oValue = this.m_oValue;
            if (oValue == UNKNOWN) {
                oValue = this.m_oValue = this.m_map.get(this.m_oKey);
            }
            return oValue;
        }

        @Override
        public Object setValue(Object oValue) {
            this.checkMutable();
            this.m_oValue = oValue;
            return this.m_map.put(this.m_oKey, oValue);
        }

        @Override
        public void setValue(Object oValue, boolean fSynthetic) {
            this.checkMutable();
            this.m_map.putAll(Collections.singletonMap(this.m_oKey, oValue));
            this.m_oValue = oValue;
        }

        @Override
        public Object extract(ValueExtractor extractor) {
            return InvocableMapHelper.extractFromEntry(extractor, this);
        }

        @Override
        public void update(ValueUpdater updater, Object oValue) {
            Object oTarget = this.getValue();
            updater.update(oTarget, oValue);
            this.setValue(oTarget, false);
        }

        @Override
        public boolean isPresent() {
            Object oValue = this.m_oValue;
            return oValue != UNKNOWN && oValue != null || this.m_map == null || this.m_map.containsKey(this.m_oKey);
        }

        @Override
        public void remove(boolean fSynthetic) {
            this.checkMutable();
            Map map = this.m_map;
            Object oKey = this.m_oKey;
            if (fSynthetic && map instanceof LocalCache) {
                ((LocalCache)map).evict(oKey);
            } else {
                map.keySet().remove(oKey);
            }
            this.m_oValue = null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof SimpleEntry) {
                SimpleEntry that = (SimpleEntry)o;
                return SimpleEntry.equals(this.m_oKey, that.m_oKey);
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object oKey = this.m_oKey;
            return oKey == null ? 0 : oKey.hashCode();
        }

        public String toString() {
            return "SimpleEntry(key=" + this.m_oKey + ')';
        }

        protected void checkMutable() {
            if (this.m_fReadOnly) {
                throw new UnsupportedOperationException("Read-only entry does not allow Map modification");
            }
        }
    }
}

