/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Gate;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ThreadGateLite
implements Gate {
    private final ReentrantReadWriteLock m_rwLock = new ReentrantReadWriteLock();

    @Override
    public boolean close(long cMillis) {
        return this.acquireLock(this.m_rwLock.writeLock(), cMillis);
    }

    @Override
    public boolean enter(long cMillis) {
        return this.acquireLock(this.m_rwLock.readLock(), cMillis);
    }

    @Override
    public void exit() {
        this.m_rwLock.readLock().unlock();
    }

    @Override
    public boolean isClosedByCurrentThread() {
        return this.m_rwLock.isWriteLockedByCurrentThread();
    }

    @Override
    public boolean isClosed() {
        return this.m_rwLock.isWriteLocked();
    }

    @Override
    public boolean isEnteredByCurrentThread() {
        return this.m_rwLock.getReadHoldCount() > 0;
    }

    @Override
    public void open() {
        this.m_rwLock.writeLock().unlock();
    }

    private boolean acquireLock(Lock lock, long cMillis) {
        try {
            if (cMillis < 0L) {
                lock.lock();
                return true;
            }
            if (cMillis == 0L) {
                return lock.tryLock();
            }
            return lock.tryLock(cMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

