/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.AbstractKeySetBasedMap;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.ObservableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WrapperObservableMap
extends AbstractKeySetBasedMap
implements ObservableMap {
    protected Map m_map;
    protected MapListenerSupport m_listenerSupport;
    protected MapListener m_listenerInternal;
    protected SimpleCacheStatistics m_stats;
    private boolean m_fCollectStats;
    protected boolean m_fTranslateEvents;
    protected boolean m_fDeferredEvent;
    private boolean m_fEventBypass;

    public WrapperObservableMap(Map map) {
        this(map, false);
    }

    public WrapperObservableMap(Map map, boolean fDeferredEvent) {
        if (map == null) {
            throw new IllegalArgumentException("Map must be specified");
        }
        this.m_map = map;
        this.m_fDeferredEvent = fDeferredEvent;
    }

    @Override
    public synchronized void clear() {
        if (this.isEventFabricator()) {
            Iterator iter = this.getInternalKeySet().iterator();
            while (iter.hasNext()) {
                this.dispatchPendingEvent(iter.next(), 3, null, false);
            }
        }
        this.getMap().clear();
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.getMap().containsValue(oValue);
    }

    @Override
    public Object get(Object oKey) {
        Map mapInner = this.getMap();
        if (this.isCollectStats()) {
            boolean fContains;
            long ldtStart = WrapperObservableMap.getSafeTimeMillis();
            Object oValue = mapInner.get(oKey);
            boolean bl = fContains = oValue != null || mapInner.containsKey(oKey);
            if (fContains) {
                this.m_stats.registerHit(ldtStart);
            } else {
                this.m_stats.registerMiss(ldtStart);
            }
            return oValue;
        }
        return mapInner.get(oKey);
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        Object oOrig;
        long ldtStart;
        Map mapInner = this.getMap();
        boolean fStats = this.isCollectStats();
        long l = ldtStart = fStats ? WrapperObservableMap.getSafeTimeMillis() : 0L;
        if (this.isEventFabricator()) {
            int nEvent = mapInner.containsKey(oKey) ? 2 : 1;
            oOrig = mapInner.put(oKey, oValue);
            this.dispatchEvent(new CacheEvent(this, nEvent, oKey, oOrig, oValue, false));
        } else {
            oOrig = mapInner.put(oKey, oValue);
        }
        if (fStats) {
            this.m_stats.registerPut(ldtStart);
        }
        return oOrig;
    }

    @Override
    public void putAll(Map map) {
        long ldtStart;
        Map mapInner = this.getMap();
        boolean fStats = this.isCollectStats();
        long l = ldtStart = fStats ? WrapperObservableMap.getSafeTimeMillis() : 0L;
        if (this.isEventFabricator()) {
            for (Map.Entry entry : map.entrySet()) {
                Object oKey = entry.getKey();
                int nEvent = mapInner.containsKey(oKey) ? 2 : 1;
                this.dispatchPendingEvent(oKey, nEvent, entry.getValue(), false);
            }
        }
        mapInner.putAll(map);
        if (fStats) {
            this.m_stats.registerPuts(map.size(), ldtStart);
        }
    }

    @Override
    public Object remove(Object oKey) {
        Map mapInner = this.getMap();
        if (this.isEventFabricator()) {
            Object oOrig;
            boolean fContained = mapInner.containsKey(oKey);
            Object v0 = oOrig = fContained ? mapInner.remove(oKey) : null;
            if (fContained) {
                this.dispatchEvent(new CacheEvent(this, 3, oKey, oOrig, null, false));
            }
            return oOrig;
        }
        return mapInner.remove(oKey);
    }

    @Override
    protected Set getInternalKeySet() {
        return this.getMap().keySet();
    }

    @Override
    protected boolean isInternalKeySetIteratorMutable() {
        return !this.isEventFabricator();
    }

    @Override
    protected boolean removeBlind(Object oKey) {
        if (this.isEventFabricator()) {
            boolean fRemoved = false;
            if (this.getMap().containsKey(oKey)) {
                this.dispatchPendingEvent(oKey, 3, null, false);
                this.getMap().keySet().remove(oKey);
                fRemoved = true;
            }
            return fRemoved;
        }
        return this.getMap().keySet().remove(oKey);
    }

    @Override
    public synchronized void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        WrapperObservableMap.azzert(listener != null);
        Map map = this.getMap();
        if (this.m_fEventBypass || !this.isTranslateEvents() && map instanceof ObservableMap) {
            ((ObservableMap)map).addMapListener(listener, oKey, fLite);
            this.m_fEventBypass = true;
        } else {
            MapListenerSupport support = this.ensureMapListenerSupport();
            boolean fWasEmpty = support.isEmpty(oKey);
            boolean fWasLite = !fWasEmpty && !support.containsStandardListeners(oKey);
            support.addListener(listener, oKey, fLite);
            if ((fWasEmpty || fWasLite && !fLite) && map instanceof ObservableMap) {
                ObservableMap mapSource = (ObservableMap)map;
                MapListener listenerInternal = this.ensureInternalListener();
                if (fWasLite && !fLite) {
                    mapSource.removeMapListener(listenerInternal, oKey);
                }
                mapSource.addMapListener(listenerInternal, oKey, fLite);
            }
        }
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        WrapperObservableMap.azzert(listener != null);
        Map map = this.getMap();
        if (this.m_fEventBypass) {
            ((ObservableMap)map).removeMapListener(listener, oKey);
        } else {
            MapListenerSupport support = this.m_listenerSupport;
            if (support != null) {
                boolean fWasStandard = support.containsStandardListeners(oKey);
                support.removeListener(listener, oKey);
                MapListener listenerInternal = this.m_listenerInternal;
                if (listenerInternal != null) {
                    ObservableMap mapSource = (ObservableMap)this.getMap();
                    if (support.isEmpty(oKey)) {
                        mapSource.removeMapListener(listenerInternal, oKey);
                        if (support.isEmpty()) {
                            this.m_listenerSupport = null;
                            this.m_listenerInternal = null;
                        }
                    } else if (fWasStandard && !support.containsStandardListeners(oKey)) {
                        mapSource.removeMapListener(listenerInternal, oKey);
                        mapSource.addMapListener(listenerInternal, oKey, true);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        WrapperObservableMap.azzert(listener != null);
        Map map = this.getMap();
        if (this.m_fEventBypass || !this.isTranslateEvents() && map instanceof ObservableMap) {
            ((ObservableMap)map).addMapListener(listener, filter, fLite);
            this.m_fEventBypass = true;
        } else {
            MapListenerSupport support = this.ensureMapListenerSupport();
            boolean fWasEmpty = support.isEmpty(filter);
            boolean fWasLite = !fWasEmpty && !support.containsStandardListeners(filter);
            support.addListener(listener, filter, fLite);
            if ((fWasEmpty || fWasLite && !fLite) && map instanceof ObservableMap) {
                ObservableMap mapSource = (ObservableMap)map;
                MapListener listenerInternal = this.ensureInternalListener();
                if (fWasLite && !fLite) {
                    mapSource.removeMapListener(listenerInternal, filter);
                }
                mapSource.addMapListener(listenerInternal, filter, fLite);
            }
        }
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        WrapperObservableMap.azzert(listener != null);
        Map map = this.getMap();
        if (this.m_fEventBypass) {
            ((ObservableMap)map).removeMapListener(listener, filter);
        } else {
            MapListenerSupport support = this.m_listenerSupport;
            if (support != null) {
                boolean fWasStandard = support.containsStandardListeners(filter);
                support.removeListener(listener, filter);
                MapListener listenerInternal = this.m_listenerInternal;
                if (listenerInternal != null) {
                    ObservableMap mapSource = (ObservableMap)this.getMap();
                    if (support.isEmpty(filter)) {
                        mapSource.removeMapListener(listenerInternal, filter);
                        if (support.isEmpty()) {
                            this.m_listenerSupport = null;
                            this.m_listenerInternal = null;
                        }
                    } else if (fWasStandard && !support.containsStandardListeners(filter)) {
                        mapSource.removeMapListener(listenerInternal, filter);
                        mapSource.addMapListener(listenerInternal, filter, true);
                    }
                }
            }
        }
    }

    public Map getMap() {
        return this.m_map;
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    public boolean isCollectStats() {
        return this.m_fCollectStats;
    }

    public void setCollectStats(boolean fCollectStats) {
        if (fCollectStats != this.m_fCollectStats) {
            if (fCollectStats && this.m_stats == null) {
                this.m_stats = new SimpleCacheStatistics();
            }
            this.m_fCollectStats = fCollectStats;
        }
    }

    public boolean isTranslateEvents() {
        return this.m_fTranslateEvents;
    }

    public void setTranslateEvents(boolean fTranslate) {
        if (fTranslate != this.m_fTranslateEvents) {
            WrapperObservableMap.azzert(!this.hasListeners() && !this.m_fEventBypass);
            this.m_fTranslateEvents = fTranslate;
        }
    }

    protected String getDescription() {
        Map map = this.getMap();
        return "Map {class=" + map.getClass().getName() + ", size=" + map.size() + ", observable=" + (map instanceof ObservableMap) + "}, CollectStats=" + this.isCollectStats() + ", CacheStatistics=" + this.getCacheStatistics() + ", hasListeners=" + this.hasListeners() + ", EventFabricator=" + this.isEventFabricator();
    }

    @Override
    public String toString() {
        return "WrapperObservableMap {" + this.getDescription() + "}";
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected MapListenerSupport ensureMapListenerSupport() {
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            this.m_listenerSupport = support = new MapListenerSupport();
        }
        return support;
    }

    protected boolean hasListeners() {
        return this.m_listenerSupport != null;
    }

    protected boolean isEventFabricator() {
        return this.hasListeners() && this.m_listenerInternal == null;
    }

    protected static boolean isSynthetic(MapEvent evt) {
        return evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic();
    }

    protected void dispatchPendingEvent(Object oKey, int nId, Object oNewValue, boolean fSynthetic) {
        CacheEvent event = this.m_fDeferredEvent ? new CacheEvent(this, nId, oKey, null, oNewValue, fSynthetic){
            private Object m_oOldValue;

            @Override
            public Object getOldValue() {
                Object oOldValue = this.m_oOldValue;
                if (oOldValue == null) {
                    this.m_oOldValue = oOldValue = WrapperObservableMap.this.get(this.getKey());
                }
                return oOldValue;
            }
        } : new CacheEvent(this, nId, oKey, this.get(oKey), oNewValue, fSynthetic);
        this.dispatchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(MapEvent evt) {
        MapListenerSupport listenerSupport = this.getMapListenerSupport();
        if (listenerSupport != null) {
            if (this.isTranslateEvents() && evt.getMap() != this) {
                final MapEvent evtOrig = evt;
                evt = new CacheEvent(this, evt.getId(), evt.getKey(), null, null, false){

                    @Override
                    public Object getOldValue() {
                        return evtOrig.getOldValue();
                    }

                    @Override
                    public Object getNewValue() {
                        return evtOrig.getNewValue();
                    }

                    @Override
                    public boolean isSynthetic() {
                        return WrapperObservableMap.isSynthetic(evtOrig);
                    }
                };
            }
            WrapperObservableMap wrapperObservableMap = this;
            synchronized (wrapperObservableMap) {
                listenerSupport.fireEvent(evt, false);
            }
        }
    }

    protected MapListener ensureInternalListener() {
        MapListener listenerInternal = this.m_listenerInternal;
        if (listenerInternal == null) {
            this.m_listenerInternal = listenerInternal = this.instantiateInternalListener();
        }
        return listenerInternal;
    }

    protected MapListener instantiateInternalListener() {
        return new InternalListener();
    }

    protected class InternalListener
    extends MultiplexingMapListener {
        protected InternalListener() {
        }

        @Override
        protected void onMapEvent(MapEvent evt) {
            WrapperObservableMap.this.dispatchEvent(evt);
        }
    }
}

