/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.AbstractCompositeExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;

public class ComparisonValueExtractor
extends AbstractCompositeExtractor {
    protected Comparator m_comparator;

    public ComparisonValueExtractor() {
    }

    public ComparisonValueExtractor(String sMethod1, String sMethod2) {
        this(sMethod1, sMethod2, null);
    }

    public ComparisonValueExtractor(String sMethod1, String sMethod2, Comparator comp) {
        this(new ReflectionExtractor(sMethod1), new ReflectionExtractor(sMethod2), comp);
    }

    public ComparisonValueExtractor(ValueExtractor ve1, ValueExtractor ve2) {
        this(ve1, ve2, null);
    }

    public ComparisonValueExtractor(ValueExtractor ve1, ValueExtractor ve2, Comparator comp) {
        super(new ValueExtractor[]{ve1, ve2});
        this.m_comparator = comp;
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    @Override
    public Object extract(Object oTarget) {
        ValueExtractor[] aExtractor = this.getExtractors();
        Comparator comparator = this.getComparator();
        Object o1 = aExtractor[0].extract(oTarget);
        Object o2 = aExtractor[1].extract(oTarget);
        if (o1 instanceof Number && o2 instanceof Number && comparator == null) {
            int nType;
            Number num1 = (Number)o1;
            Number num2 = (Number)o2;
            if (num1.getClass() == num2.getClass()) {
                nType = ComparisonValueExtractor.getStreamFormat(o1);
            } else {
                int cTypes;
                int[] anType = new int[]{16, 15, 1, 2, 14, 3, 4, 5};
                int nType1 = ComparisonValueExtractor.getStreamFormat(num1);
                int nType2 = ComparisonValueExtractor.getStreamFormat(num2);
                int ix2 = cTypes = anType.length;
                int ix1 = cTypes;
                for (int i = 0; i < cTypes; ++i) {
                    int nT = anType[i];
                    if (nT == nType1) {
                        ix1 = i;
                    }
                    if (nT != nType2) continue;
                    ix2 = i;
                }
                switch (Math.max(ix1, ix2)) {
                    case 1: 
                    case 2: {
                        nType = 1;
                        break;
                    }
                    case 3: {
                        nType = 2;
                        break;
                    }
                    case 4: 
                    case 5: {
                        nType = 3;
                        break;
                    }
                    case 6: 
                    case 7: {
                        nType = 4;
                        num1 = ComparisonValueExtractor.ensureBigDecimal(num1);
                        num2 = ComparisonValueExtractor.ensureBigDecimal(num2);
                        break;
                    }
                    default: {
                        nType = 255;
                    }
                }
            }
            switch (nType) {
                case 1: 
                case 15: 
                case 16: {
                    return ComparisonValueExtractor.makeInteger(num1.intValue() - num2.intValue());
                }
                case 2: {
                    return ComparisonValueExtractor.makeLong(num1.longValue() - num2.longValue());
                }
                case 14: {
                    return new Float(num1.floatValue() - num2.floatValue());
                }
                case 3: {
                    return new Double(num1.doubleValue() - num2.doubleValue());
                }
                case 4: {
                    return ((BigInteger)num1).subtract((BigInteger)num2);
                }
                case 5: {
                    return ((BigDecimal)num1).subtract((BigDecimal)num2);
                }
            }
        }
        return ComparisonValueExtractor.makeInteger(SafeComparator.compareSafe(comparator, o1, o2));
    }

    private static BigDecimal ensureBigDecimal(Number num) {
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        if (num instanceof BigInteger) {
            return new BigDecimal((BigInteger)num);
        }
        return new BigDecimal(num.doubleValue());
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_comparator = (Comparator)ComparisonValueExtractor.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ComparisonValueExtractor.writeObject(out, this.m_comparator);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_comparator = (Comparator)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeObject(1, this.m_comparator);
    }
}

