/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ContainsAnyFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public ContainsAnyFilter() {
    }

    public ContainsAnyFilter(ValueExtractor extractor, Set setValues) {
        super(extractor, new HashSet(setValues));
        ContainsAnyFilter.azzert(setValues != null);
    }

    public ContainsAnyFilter(String sMethod, Set setValues) {
        super(sMethod, new HashSet(setValues));
        ContainsAnyFilter.azzert(setValues != null);
    }

    @Override
    protected boolean evaluateExtracted(Object oExtracted) {
        block4: {
            Collection colValues;
            block3: {
                colValues = (Collection)this.getValue();
                if (!(oExtracted instanceof Collection)) break block3;
                Collection colExtracted = (Collection)oExtracted;
                Iterator iter = colValues.iterator();
                while (iter.hasNext()) {
                    if (!colExtracted.contains(iter.next())) continue;
                    return true;
                }
                break block4;
            }
            if (!(oExtracted instanceof Object[])) break block4;
            Object[] aoExtracted = (Object[])oExtracted;
            int cExtracted = aoExtracted.length;
            for (Object oValue : colValues) {
                for (int i = 0; i < cExtracted; ++i) {
                    if (!ContainsAnyFilter.equals(aoExtracted[i], oValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        return index == null ? ContainsAnyFilter.calculateIteratorEffectiveness(setKeys.size()) : ((Collection)this.getValue()).size();
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        Collection colValues = (Collection)this.getValue();
        HashSet setIn = new HashSet();
        for (Object oValue : colValues) {
            Set setEQ = (Set)index.getIndexContents().get(oValue);
            if (setEQ == null) continue;
            setIn.addAll(setEQ);
        }
        if (setIn.isEmpty()) {
            setKeys.clear();
        } else {
            setKeys.retainAll(setIn);
        }
        return null;
    }
}

