/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapTrigger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FilterTrigger
extends ExternalizableHelper
implements MapTrigger,
ExternalizableLite,
PortableObject {
    public static final int ACTION_ROLLBACK = 0;
    public static final int ACTION_IGNORE = 1;
    public static final int ACTION_REMOVE = 2;
    protected Filter m_filter;
    protected int m_nAction;

    public FilterTrigger() {
    }

    public FilterTrigger(Filter filter) {
        this(filter, 0);
    }

    public FilterTrigger(Filter filter, int nAction) {
        FilterTrigger.azzert(filter != null, "Null filter");
        this.m_filter = filter;
        this.m_nAction = nAction;
    }

    @Override
    public void process(MapTrigger.Entry entry) {
        if (entry.isPresent() && !InvocableMapHelper.evaluateEntry(this.m_filter, entry)) {
            switch (this.m_nAction) {
                default: {
                    throw new IllegalArgumentException("Rejecting " + entry + " by trigger " + this);
                }
                case 1: {
                    Object oValue = entry.getOriginalValue();
                    if (oValue != null || entry.isOriginalPresent()) {
                        entry.setValue(oValue, true);
                        break;
                    }
                    entry.remove(true);
                    break;
                }
                case 2: {
                    entry.remove(true);
                }
            }
        }
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public int getAction() {
        return this.m_nAction;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)FilterTrigger.readObject(in);
        this.m_nAction = FilterTrigger.readInt(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        FilterTrigger.writeObject(out, this.m_filter);
        FilterTrigger.writeInt(out, this.m_nAction);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_nAction = in.readInt(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeInt(1, this.m_nAction);
    }

    public boolean equals(Object o) {
        if (o instanceof FilterTrigger) {
            FilterTrigger that = (FilterTrigger)o;
            return FilterTrigger.equals(this.m_filter, that.m_filter) && this.m_nAction == that.m_nAction;
        }
        return false;
    }

    public int hashCode() {
        return FilterTrigger.hashCode(this.m_filter);
    }

    public String toString() {
        String sAction;
        String sClass = this.getClass().getName();
        switch (this.m_nAction) {
            default: {
                sAction = "ACTION_ROLLBACK";
                break;
            }
            case 1: {
                sAction = "ACTION_IGNORE";
                break;
            }
            case 2: {
                sAction = "ACTION_REMOVE";
            }
        }
        return sClass.substring(sClass.lastIndexOf(46) + 1) + '(' + this.m_filter + ", " + sAction + ')';
    }
}

