/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Filter;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class KeyFilter
extends Base
implements EntryFilter,
IndexAwareFilter {
    protected Set m_setKeys = new HashSet();
    private transient boolean m_fBinary;

    public KeyFilter(Set setKeys) {
        Set set = this.m_setKeys;
        boolean fInit = true;
        for (Object oKey : setKeys) {
            if (fInit) {
                this.m_fBinary = oKey instanceof Binary;
                fInit = false;
            }
            set.add(oKey);
        }
    }

    @Override
    public boolean evaluate(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean evaluateEntry(Map.Entry entry) {
        return this.m_fBinary && entry instanceof BinaryEntry ? this.m_setKeys.contains(((BinaryEntry)entry).getBinaryKey()) : this.m_setKeys.contains(entry.getKey());
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        return 1;
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        setKeys.retainAll(this.m_setKeys);
        return null;
    }

    public Set getKeys() {
        return this.m_setKeys;
    }

    public String toString() {
        return "Key in " + this.m_setKeys;
    }
}

