/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.filter.EntryFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class PartitionedFilter
extends ExternalizableHelper
implements EntryFilter,
ExternalizableLite,
PortableObject {
    private Filter m_filter;
    private PartitionSet m_partitions;

    public PartitionedFilter() {
    }

    public PartitionedFilter(Filter filter, PartitionSet partitions) {
        if (filter == null || filter instanceof PartitionedFilter) {
            throw new IllegalArgumentException("Invalid filter: " + filter);
        }
        if (partitions == null) {
            throw new IllegalArgumentException("PartitionSet be specified");
        }
        this.m_filter = filter;
        this.m_partitions = partitions;
    }

    @Override
    public boolean evaluate(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean evaluateEntry(Map.Entry entry) {
        PartitionSet parts = this.m_partitions;
        Object oKey = entry.getKey();
        int nHash = oKey == null ? 0 : Math.abs(oKey.hashCode());
        return parts.contains(nHash % parts.getPartitionCount()) && InvocableMapHelper.evaluateEntry(this.m_filter, entry);
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public PartitionSet getPartitionSet() {
        return this.m_partitions;
    }

    public boolean equals(Object o) {
        if (o instanceof PartitionedFilter) {
            PartitionedFilter that = (PartitionedFilter)o;
            return PartitionedFilter.equals(this.m_filter, that.m_filter) && PartitionedFilter.equals(this.m_partitions, that.m_partitions);
        }
        return false;
    }

    public int hashCode() {
        return PartitionedFilter.hashCode(this.m_filter) + PartitionedFilter.hashCode(this.m_partitions);
    }

    public String toString() {
        String sClass = this.getClass().getName();
        return sClass.substring(sClass.lastIndexOf(46) + 1) + '(' + this.m_filter + ", " + this.m_partitions + ')';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)PartitionedFilter.readObject(in);
        this.m_partitions = (PartitionSet)PartitionedFilter.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        PartitionedFilter.writeObject(out, this.m_filter);
        PartitionedFilter.writeObject(out, this.m_partitions);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_partitions = (PartitionSet)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeObject(1, this.m_partitions);
    }
}

