/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.internal;

import com.tangosol.util.Gate;
import com.tangosol.util.ThreadGateLite;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class QueueFabric {
    protected Gate m_gateQueue = new ThreadGateLite();

    public boolean lockAll(long cMillis) {
        return this.getQueueControl().close(cMillis);
    }

    public void unlockAll() {
        this.getQueueControl().open();
    }

    public void add(LinkedNode node, LinkedQueue queueRow, LinkedQueue queueCol) {
        queueRow.add(node);
        queueCol.add(node);
    }

    public void remove(LinkedNode node) {
        node.getRowQueue().remove(node);
        node.getColumnQueue().remove(node);
    }

    protected Gate getQueueControl() {
        return this.m_gateQueue;
    }

    public class LinkedQueue {
        protected LinkedNode m_nodeFirst;
        protected LinkedNode m_nodeLast;
        protected boolean m_fRow;
        protected Lock m_lock = new ReentrantLock();
        private int m_cSize;

        public LinkedQueue(boolean fRow) {
            this.m_fRow = fRow;
        }

        public synchronized void add(LinkedNode nodeNew) {
            LinkedNode nodeFirst = this.getFirstNode();
            LinkedNode nodeLast = this.getLastNode();
            if (nodeFirst == null) {
                this.setFirstNode(nodeNew);
            }
            if (nodeLast != null) {
                this.link(nodeLast, nodeNew);
            }
            this.setLastNode(nodeNew);
            if (this.isRow()) {
                nodeNew.setRowQueue(this);
            } else {
                nodeNew.setColumnQueue(this);
            }
            ++this.m_cSize;
        }

        public synchronized boolean remove(LinkedNode node) {
            LinkedNode nodeNext;
            LinkedNode nodePrev;
            boolean fByRow = this.isRow();
            if (fByRow && node.getRowQueue() != this || !fByRow && node.getColumnQueue() != this) {
                return false;
            }
            if (fByRow) {
                nodePrev = node.getPrevInRow();
                nodeNext = node.getNextInRow();
            } else {
                nodePrev = node.getPrevInCol();
                nodeNext = node.getNextInCol();
            }
            if (nodePrev == null) {
                this.setFirstNode(nodeNext);
            }
            this.link(nodePrev, nodeNext);
            if (nodeNext == null) {
                this.setLastNode(nodePrev);
            }
            --this.m_cSize;
            return true;
        }

        public boolean isEmpty() {
            return this.getFirstNode() == null;
        }

        public int getSize() {
            return this.m_cSize;
        }

        protected void link(LinkedNode node1, LinkedNode node2) {
            if (this.isRow()) {
                if (node1 != null) {
                    node1.setNextInRow(node2);
                }
                if (node2 != null) {
                    node2.setPrevInRow(node1);
                }
            } else {
                if (node1 != null) {
                    node1.setNextInCol(node2);
                }
                if (node2 != null) {
                    node2.setPrevInCol(node1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean lock(long cMillis) {
            Gate gateQueue = QueueFabric.this.getQueueControl();
            boolean fLocked = false;
            if (gateQueue.enter(cMillis)) {
                try {
                    if (cMillis >= 0L) {
                        fLocked = this.getLock().tryLock(cMillis, TimeUnit.MILLISECONDS);
                    } else {
                        this.getLock().lockInterruptibly();
                        fLocked = true;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    if (!fLocked) {
                        gateQueue.exit();
                    }
                }
            }
            return fLocked;
        }

        public void unlock() {
            this.getLock().unlock();
            QueueFabric.this.getQueueControl().exit();
        }

        public boolean isRow() {
            return this.m_fRow;
        }

        public LinkedNode getFirstNode() {
            return this.m_nodeFirst;
        }

        protected void setFirstNode(LinkedNode nodeFirst) {
            this.m_nodeFirst = nodeFirst;
        }

        public LinkedNode getLastNode() {
            return this.m_nodeLast;
        }

        protected void setLastNode(LinkedNode nodeLast) {
            this.m_nodeLast = nodeLast;
        }

        public Lock getLock() {
            return this.m_lock;
        }
    }

    public static class LinkedNode {
        protected LinkedNode m_nodeNextInRow;
        protected LinkedNode m_nodePrevInRow;
        protected LinkedNode m_nodeNextInCol;
        protected LinkedNode m_nodePrevInCol;
        protected LinkedQueue m_queueRow;
        protected LinkedQueue m_queueCol;

        public LinkedNode getNextInRow() {
            return this.m_nodeNextInRow;
        }

        protected void setNextInRow(LinkedNode nodeNext) {
            this.m_nodeNextInRow = nodeNext;
        }

        public LinkedNode getPrevInRow() {
            return this.m_nodePrevInRow;
        }

        protected void setPrevInRow(LinkedNode nodePrev) {
            this.m_nodePrevInRow = nodePrev;
        }

        public LinkedNode getNextInCol() {
            return this.m_nodeNextInCol;
        }

        protected void setNextInCol(LinkedNode nodeNext) {
            this.m_nodeNextInCol = nodeNext;
        }

        public LinkedNode getPrevInCol() {
            return this.m_nodePrevInCol;
        }

        protected void setPrevInCol(LinkedNode nodePrev) {
            this.m_nodePrevInCol = nodePrev;
        }

        public LinkedQueue getRowQueue() {
            return this.m_queueRow;
        }

        protected void setRowQueue(LinkedQueue queueRow) {
            if (this.m_queueRow != null) {
                throw new IllegalStateException("Attempt to add a node to multiple queues along the same dimension");
            }
            this.m_queueRow = queueRow;
        }

        public LinkedQueue getColumnQueue() {
            return this.m_queueCol;
        }

        protected void setColumnQueue(LinkedQueue queueCol) {
            if (this.m_queueCol != null) {
                throw new IllegalStateException("Attempt to add a node to multiple queues along the same dimension");
            }
            this.m_queueCol = queueCol;
        }
    }
}

