/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueManipulator;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.processor.AbstractProcessor;
import com.tangosol.util.processor.PropertyManipulator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class PropertyProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected ValueManipulator m_manipulator;

    public PropertyProcessor() {
    }

    public PropertyProcessor(String sName) {
        this(sName, false);
    }

    public PropertyProcessor(String sName, boolean fUseIs) {
        this(sName == null ? null : new PropertyManipulator(sName, fUseIs));
    }

    public PropertyProcessor(ValueManipulator manipulator) {
        this.m_manipulator = manipulator;
    }

    protected Object get(InvocableMap.Entry entry) {
        ValueManipulator manipulator = this.m_manipulator;
        if (manipulator != null) {
            ValueExtractor extractor = manipulator.getExtractor();
            if (extractor == null) {
                throw new IllegalStateException("The ValueManipulator (" + manipulator + ") failed to provide a ValueExtractor");
            }
            return entry.extract(extractor);
        }
        return entry.getValue();
    }

    protected void set(InvocableMap.Entry entry, Object oValue) {
        ValueUpdater updater;
        ValueManipulator manipulator = this.m_manipulator;
        if (this.m_manipulator != null && (updater = manipulator.getUpdater()) != null) {
            entry.update(updater, oValue);
            return;
        }
        entry.setValue(oValue, false);
    }

    protected abstract String getDescription();

    public boolean equals(Object o) {
        if (o instanceof PropertyProcessor) {
            PropertyProcessor that = (PropertyProcessor)o;
            return PropertyProcessor.equals(this.m_manipulator, that.m_manipulator);
        }
        return false;
    }

    public int hashCode() {
        return this.m_manipulator.hashCode();
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + '(' + this.m_manipulator + this.getDescription() + ')';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_manipulator = (ValueManipulator)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_manipulator);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_manipulator = (ValueManipulator)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_manipulator);
    }
}

