/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.registry;

import com.tangosol.util.registry.FlatRegistry;

public class SimpleEntry
implements FlatRegistry.Entry {
    private FlatRegistry m_reg;
    private int m_nId = -1;
    private String m_sName;

    protected SimpleEntry() {
    }

    public SimpleEntry(int nId, String sName) {
        assert (nId >= 0 && sName != null);
        this.setId(nId);
        this.setName(sName);
    }

    public SimpleEntry(String sName) {
        assert (sName != null);
        this.setName(sName);
    }

    @Override
    public int getId() {
        return this.m_nId;
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public void onRegister(FlatRegistry reg, int nId) {
        assert (reg != null && this.getRegistry() == null);
        assert (nId >= 0 && (this.getId() == nId || this.getId() == -1));
        this.setRegistry(reg);
        int nIdOrig = this.getId();
        if (nIdOrig == -1) {
            this.setId(nId);
        }
    }

    @Override
    public void onUnregister(FlatRegistry reg) {
        assert (reg != null && this.getRegistry() == reg);
        this.setRegistry(null);
    }

    protected void setId(int nId) {
        this.m_nId = nId;
    }

    protected void setName(String sName) {
        this.m_sName = sName;
    }

    protected FlatRegistry getRegistry() {
        return this.m_reg;
    }

    protected void setRegistry(FlatRegistry reg) {
        this.m_reg = reg;
    }
}

