package org.gridvise.mavenplugin;


import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.gridvise.RemoteAPI;
import org.gridvise.RemoteRunBookAPI;
import org.gridvise.mgmtcache.coh.ManagementCacheServer;
import org.gridvise.mgmtcache.coh.entity.executioncontext.ExecutionContext;

import java.util.List;
import java.util.Map;

@Mojo( name = "runbook")
public class MvnPlugin extends AbstractMojo
{
    @Parameter( property = "cacheConfig")
    private String cacheConfig;

    @Parameter( property = "tangosolCoherenceOverride")
    private String tangosolCoherenceOverride;


    @Parameter( property = "runBookId")
    private String runBookId;

    @Parameter( property = "vars")
    private Map vars;

    @Parameter( property = "machines")
    private List<String> machines;

    public void execute() throws MojoExecutionException
    {
        System.setProperty("tangosol.coherence.distributed.localstorage", "false");
        if(this.cacheConfig == null){
            this.cacheConfig = ManagementCacheServer.CACHECONFIG_FILE_VALUE();
            getLog().info("no cache config set - using default "+cacheConfig);
        }else{
            getLog().info("using cache config "+cacheConfig);
        }
        if(this.tangosolCoherenceOverride!=null){
            getLog().info("using tangosol coherence override "+this.tangosolCoherenceOverride);
            System.setProperty("tangosol.coherence.override", this.tangosolCoherenceOverride);
        }
        System.setProperty(ManagementCacheServer.CACHECONFIG_FILE_PROP(),cacheConfig);
        getLog().info( "Running runbook "+runBookId);
        getLog().info( "using VARS "+vars);
        getLog().info( "machines "+machines);

        ExecutionContext c = RemoteAPI.createDefaultExecutionContext(machines);

        String r = RemoteRunBookAPI.invokeRunBook(c, runBookId, vars);

        getLog().info( "completed execution with: "+r);

    }
}

