package org.gridvise.mavenplugin;


import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.gridvise.RemoteAPI;
import org.gridvise.RemoteRunBookAPI;
import org.gridvise.logical.runbook.LocalRunBook;
import org.gridvise.mgmtcache.coh.ManagementCacheServer;
import org.gridvise.mgmtcache.coh.entity.executioncontext.ExecutionContext;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

@Mojo( name = "runbook")
public class MvnPlugin extends AbstractMojo
{
    private static final Logger LOG = Logger.getLogger(MvnPlugin.class.getName());

    @Component
    private MavenProject project;

    @Parameter( property = "cacheConfig")
    private String cacheConfig;

    @Parameter( property = "tangosolCoherenceOverride")
    private String tangosolCoherenceOverride;


    @Parameter( property = "runBookId")
    private String runBookId;

    @Parameter( property = "runBookLocation")
    private String runBookLocation;

    @Parameter( property = "vars")
    private Map vars;

    @Parameter( property = "machines")
    private List<String> machines;

    public void execute() throws MojoExecutionException
    {
        addProjectDependenciesToCP();

        System.setProperty("tangosol.coherence.distributed.localstorage", "false");
        if(this.cacheConfig == null){
            this.cacheConfig = ManagementCacheServer.CACHECONFIG_FILE_VALUE();
            getLog().info("no cache config set - using default "+cacheConfig);
        }else{
            getLog().info("using cache config "+cacheConfig);
        }
        if(this.tangosolCoherenceOverride!=null){
            getLog().info("using tangosol coherence override "+this.tangosolCoherenceOverride);
            System.setProperty("tangosol.coherence.override", this.tangosolCoherenceOverride);
        }
        System.setProperty(ManagementCacheServer.CACHECONFIG_FILE_PROP(),cacheConfig);
        if(this.runBookLocation!=null){
            getLog().info("loading runbook "+this.runBookLocation);
            String id = LocalRunBook.loadRunBook(this.runBookLocation);
            if(!id.equals(this.runBookId)){
                throw new RuntimeException("the runbook loaded from "+this.runBookLocation+" is expected to match the id this plugin is configured with ("+this.runBookId+")");
            }
        }
        getLog().info( "Running runbook "+runBookId);
        getLog().info( "using VARS "+vars);
        getLog().info( "machines "+machines);

        ExecutionContext c = RemoteAPI.createDefaultExecutionContext(machines);

        String r = RemoteRunBookAPI.invokeRunBook(c, runBookId, vars);

        getLog().info( "completed execution with: "+r);

    }

    private void addProjectDependenciesToCP(){
        try {
            Set<URL> urls = new HashSet<URL>();

            for(Object dep : project.getDependencyArtifacts()){
                DefaultArtifact dependency = (DefaultArtifact) dep;
                urls.add(dependency.getFile().toURI().toURL());
            }

            ClassLoader contextClassLoader = URLClassLoader.newInstance(
                    urls.toArray(new URL[urls.size()]),
                    Thread.currentThread().getContextClassLoader());

            Thread.currentThread().setContextClassLoader(contextClassLoader);

        } catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

