/*
 * Decompiled with CFR 0.152.
 */
package org.gridvise.mavenplugin;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.gridvise.RemoteAPI;
import org.gridvise.RemoteRunBookAPI;
import org.gridvise.logical.runbook.LocalRunBook;
import org.gridvise.mgmtcache.coh.ManagementCacheServer;
import org.gridvise.mgmtcache.coh.entity.executioncontext.ExecutionContext;

@Mojo(name="runbook")
public class MvnPlugin
extends AbstractMojo {
    private static final Logger LOG = Logger.getLogger(MvnPlugin.class.getName());
    @Component
    private MavenProject project;
    @Parameter(property="cacheConfig")
    private String cacheConfig;
    @Parameter(property="tangosolCoherenceOverride")
    private String tangosolCoherenceOverride;
    @Parameter(property="runBookId")
    private String runBookId;
    @Parameter(property="runBookLocation")
    private String runBookLocation;
    @Parameter(property="vars")
    private Map vars;
    @Parameter(property="machines")
    private List<String> machines;

    public void execute() throws MojoExecutionException {
        this.addProjectDependenciesToCP();
        System.setProperty("tangosol.coherence.distributed.localstorage", "false");
        if (this.cacheConfig == null) {
            this.cacheConfig = ManagementCacheServer.CACHECONFIG_FILE_VALUE();
            this.getLog().info((CharSequence)("no cache config set - using default " + this.cacheConfig));
        } else {
            this.getLog().info((CharSequence)("using cache config " + this.cacheConfig));
        }
        if (this.tangosolCoherenceOverride != null) {
            this.getLog().info((CharSequence)("using tangosol coherence override " + this.tangosolCoherenceOverride));
            System.setProperty("tangosol.coherence.override", this.tangosolCoherenceOverride);
        }
        System.setProperty(ManagementCacheServer.CACHECONFIG_FILE_PROP(), this.cacheConfig);
        if (this.runBookLocation != null) {
            this.getLog().info((CharSequence)("loading runbook " + this.runBookLocation));
            String id = LocalRunBook.loadRunBook((String)this.runBookLocation);
            if (!id.equals(this.runBookId)) {
                throw new RuntimeException("the runbook loaded from " + this.runBookLocation + " is expected to match the id this plugin is configured with (" + this.runBookId + ")");
            }
        }
        this.getLog().info((CharSequence)("Running runbook " + this.runBookId));
        this.getLog().info((CharSequence)("using VARS " + this.vars));
        this.getLog().info((CharSequence)("machines " + this.machines));
        ExecutionContext c = RemoteAPI.createDefaultExecutionContext(this.machines);
        String r = RemoteRunBookAPI.invokeRunBook((ExecutionContext)c, (String)this.runBookId, (Map)this.vars);
        this.getLog().info((CharSequence)("completed execution with: " + r));
    }

    private void addProjectDependenciesToCP() {
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (Object dep : this.project.getDependencyArtifacts()) {
                DefaultArtifact dependency = (DefaultArtifact)dep;
                urls.add(dependency.getFile().toURI().toURL());
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

