package org.gridvise.coherence.cache.invocation;

import java.util.Collection;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.InvocationService;

public abstract class AbstractInvocationService<R> {
	
	private InvocationService is = (InvocationService) CacheFactory.getService(this.getName());

	@SuppressWarnings("unchecked")
	public Collection<R> queryOnAllMembers(AbstractRemoteTask<R> task){
		return (Collection<R>)is.query(task, null).values();
	}
	
	public abstract String getName();
}
