package org.gridvise.coherence.cache.invocation;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.InvocationService;
import org.apache.log4j.Logger;

import java.util.Collection;
import java.util.Set;

public abstract class AbstractInvocationService<R> {
	
	private InvocationService is = (InvocationService) CacheFactory.getService(this.getName());
    private static final Logger LOG = Logger.getLogger(AbstractInvocationService.class);

	@SuppressWarnings("unchecked")
	public Collection<R> queryOnAllMembers(AbstractRemoteTask<R> task){
        Set m = is.getCluster().getMemberSet();
        LOG.info("invoking " + task + " on "+m);
        return (Collection<R>)is.query(task, null).values();
	}
	
	public abstract String getName();
}
