package org.gridvise.coherence.cache.scheduling;


import org.gridvise.coherence.cache.config.Configuration;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Trigger;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;

@SuppressWarnings({"unchecked"})
public class JobScheduler {
    /**
     * The name of the job scheduler cache.
     */
    public static final String CACHE_NAME = Configuration.getSchedulingCacheName();

    private static final NamedCache CACHE = CacheFactory.getCache(CACHE_NAME);

    public static void schedule(JobDetail job, Trigger schedule) {
        CACHE.put(job.getKey(), new ScheduledJob(job, schedule));
    }

    public static void unschedule(JobKey key) {
        CACHE.remove(key);
    }
}
